/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IAreaSupport;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.model.support.RetentionTimeRange;

public class AreaSupport
implements IAreaSupport {
    private double minimumArea = 0.0;
    private List<IRetentionTimeRange> ranges = new ArrayList<IRetentionTimeRange>();

    @Override
    public void setAreaSumOn(int startRetentionTime, int stopRetentionTime) {
        RetentionTimeRange retentionTimeRange = new RetentionTimeRange(startRetentionTime, stopRetentionTime);
        this.ranges.add((IRetentionTimeRange)retentionTimeRange);
    }

    @Override
    public boolean isAreaSumOn(int startRetentionTime) {
        boolean areaSumOn = false;
        for (IRetentionTimeRange range : this.ranges) {
            if (startRetentionTime < range.getStartRetentionTime() || startRetentionTime > range.getStopRetentionTime()) continue;
            areaSumOn = true;
            break;
        }
        return areaSumOn;
    }

    @Override
    public void setMinimumArea(double minimumArea) {
        if (minimumArea >= 0.0) {
            this.minimumArea = minimumArea;
        }
    }

    @Override
    public double getMinimumArea() {
        return this.minimumArea;
    }

    @Override
    public void reset() {
        this.minimumArea = 0.0;
        this.resetAreaSumOn();
    }

    @Override
    public void resetAreaSumOn() {
        this.ranges.clear();
    }

    @Override
    public boolean report(IPeak peak) {
        if (peak == null) {
            return false;
        }
        return !(peak.getIntegratedArea() < this.minimumArea);
    }
}

