/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.core;

import org.eclipse.chemclipse.chromatogram.msd.classifier.core.AbstractChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.IChromatogramClassifierResult;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.classifier.settings.IChromatogramClassifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.exceptions.ClassifierException;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.internal.core.support.Calculator;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIons;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.result.WncClassifierResult;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.settings.ClassifierSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.implementation.MeasurementResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class Classifier
extends AbstractChromatogramClassifier {
    public Classifier() {
        super(new DataType[]{DataType.MSD});
    }

    public IProcessingInfo<IChromatogramClassifierResult> applyClassifier(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramClassifierSettings chromatogramClassifierSettings, IProgressMonitor monitor) {
        ClassifierSettings classifierSettings = chromatogramClassifierSettings instanceof ClassifierSettings ? (ClassifierSettings)chromatogramClassifierSettings : PreferenceSupplier.getClassifierSettings();
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramClassifierSettings);
        if (!processingInfo.hasErrorMessages()) {
            try {
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                if (chromatogram instanceof IChromatogramMSD) {
                    IWncIons resultWncIons = Calculator.calculateIonPercentages((IChromatogramMSD)chromatogram, chromatogramSelection, classifierSettings);
                    WncClassifierResult chromatogramClassifierResult = new WncClassifierResult(ResultStatus.OK, "The chromatogram has been classified.", resultWncIons);
                    MeasurementResult measurementResult = new MeasurementResult("WNC Classifier", "org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc", "This is percentage area list of selected ions.", (Object)chromatogramClassifierResult);
                    chromatogramSelection.getChromatogram().addMeasurementResult((IMeasurementResult)measurementResult);
                    processingInfo.setProcessingResult((Object)chromatogramClassifierResult);
                } else {
                    processingInfo.addWarnMessage("WNC Classifier", "Can only process MSD-Chromatograms - skipping");
                }
            }
            catch (ClassifierException e) {
                ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "WNC Classifier", "The chromatogram couldn't be classified.");
                processingInfo.addMessage((IProcessingMessage)processingMessage);
            }
        }
        return processingInfo;
    }
}

