/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.runnables;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.PeakIdentifierMSD;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PeakIdentifierRunnable
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "File Peak Identifier";
    private static final String IDENTIFIER_ID = "org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.peak";
    private IChromatogramSelectionMSD chromatogramSelection;
    private boolean identifySelectedPeak;

    public PeakIdentifierRunnable(IChromatogramSelectionMSD chromatogramSelection, boolean identifySelectedPeak) {
        this.chromatogramSelection = chromatogramSelection;
        this.identifySelectedPeak = identifySelectedPeak;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IProcessingInfo processingInfo;
            monitor.beginTask(DESCRIPTION, -1);
            if (this.identifySelectedPeak) {
                IChromatogramPeakMSD peak = (IChromatogramPeakMSD)this.chromatogramSelection.getSelectedPeak();
                processingInfo = PeakIdentifierMSD.identify((IPeakMSD)peak, (String)IDENTIFIER_ID, (IProgressMonitor)monitor);
            } else {
                List peaks = this.chromatogramSelection.getChromatogramMSD().getPeaks((IRetentionTimeRange)this.chromatogramSelection);
                ArrayList<IChromatogramPeakMSD> peakList = new ArrayList<IChromatogramPeakMSD>();
                for (IChromatogramPeakMSD chromatogramPeak : peaks) {
                    peakList.add(chromatogramPeak);
                }
                processingInfo = PeakIdentifierMSD.identify(peakList, (String)IDENTIFIER_ID, (IProgressMonitor)monitor);
            }
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
            if (this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
                ((ChromatogramSelectionMSD)this.chromatogramSelection).update(false);
            }
        }
        finally {
            monitor.done();
        }
    }
}

