/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.support;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;

public class PenaltyCalculationSupport {
    private static final Logger logger = Logger.getLogger(PenaltyCalculationSupport.class);

    public static float calculatePenaltyFromRetentionIndex(IScanMSD unknown, IScanMSD reference, float retentionIndexWindow, float penaltyCalculationLevelFactor, float maxPenalty) {
        try {
            if (retentionIndexWindow == 0.0f) {
                throw new IllegalArgumentException();
            }
            if (maxPenalty < 0.0f || maxPenalty > 100.0f) {
                throw new IllegalArgumentException();
            }
            return PenaltyCalculationSupport.calculatePenalty(unknown.getRetentionIndex(), reference.getRetentionIndex(), retentionIndexWindow, penaltyCalculationLevelFactor, maxPenalty);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static float calculatePenaltyFromRetentionTime(int unknown, int reference, int retentionTimeWindow, float penaltyCalculationLevelFactor, float maxPenalty) {
        float result = 0.0f;
        try {
            if ((float)retentionTimeWindow == 0.0f) {
                throw new IllegalArgumentException();
            }
            if (maxPenalty < 0.0f || maxPenalty > 100.0f) {
                throw new IllegalArgumentException();
            }
            PenaltyCalculationSupport.runRetentionTimeCheck(unknown, reference);
            result = PenaltyCalculationSupport.calculatePenalty(unknown, reference, retentionTimeWindow, penaltyCalculationLevelFactor, maxPenalty);
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public static float calculatePenalty(float valueUnknown, float valueReference, float valueWindow, float penaltyCalculationLevelFactor, float maxPenalty) {
        if (Float.isNaN(valueUnknown) || valueUnknown < 0.0f) {
            throw new IllegalArgumentException("" + valueUnknown);
        }
        if (Float.isNaN(valueReference) || valueReference < 0.0f) {
            throw new IllegalArgumentException("" + valueReference);
        }
        if (Float.isNaN(valueWindow) || valueWindow <= 0.0f) {
            throw new IllegalArgumentException("" + valueWindow);
        }
        if (Float.isNaN(penaltyCalculationLevelFactor) || penaltyCalculationLevelFactor <= 0.0f) {
            throw new IllegalArgumentException("" + penaltyCalculationLevelFactor);
        }
        if (Float.isNaN(maxPenalty) || maxPenalty <= 0.0f) {
            throw new IllegalArgumentException("" + maxPenalty);
        }
        float windowRangeCount = Math.abs((valueUnknown - valueReference) / valueWindow);
        if (windowRangeCount <= 1.0f) {
            return 0.0f;
        }
        float result = (windowRangeCount - 1.0f) * penaltyCalculationLevelFactor;
        return result > maxPenalty ? maxPenalty : result;
    }

    private static void runRetentionIndexCheck(IScanMSD unknown, IScanMSD reference) {
        if (unknown.getRetentionIndex() == 0.0f || reference.getRetentionIndex() == 0.0f) {
            throw new IllegalArgumentException("The retention index of the unknown or reference is not set.");
        }
    }

    private static void runRetentionTimeCheck(int unknown, int reference) {
        if (unknown <= 0 || reference <= 0) {
            throw new IllegalArgumentException("The retention time of the unknown or reference is not set.");
        }
    }
}

