/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.ui.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.ui.internal.handlers.DetectorByFileRunnable;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DetectorByFileHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(DetectorByFileHandler.class);
    private static IChromatogramSelectionMSD chromatogramSelection;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        if (chromatogramSelection != null) {
            Shell shell = Display.getCurrent().getActiveShell();
            FileDialog fileDialog = new FileDialog(shell, 8);
            fileDialog.setText("Import ELU file");
            fileDialog.setFileName("");
            fileDialog.setFilterExtensions(new String[]{"*.ELU"});
            fileDialog.setFilterNames(new String[]{"AMDIS ELU File"});
            String pathname = fileDialog.open();
            if (pathname != null) {
                File file = new File(pathname);
                DetectorByFileRunnable runnable = new DetectorByFileRunnable(chromatogramSelection, file);
                ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
                try {
                    monitor.run(true, true, (IRunnableWithProgress)runnable);
                }
                catch (InvocationTargetException e) {
                    logger.warn((Object)e);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)e);
                }
                StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: ELU Peaks imported");
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

