/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.core.IPeakDetectorMSDSupport;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.core.PeakDetectorMSD;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.settings.IPeakDetectorSettingsMSD;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.IPeakDetectorSupplier;
import org.eclipse.chemclipse.chromatogram.peak.detector.exceptions.NoPeakDetectorAvailableException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakDetectorMSDProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Peak Detector";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IPeakDetectorMSDSupport support = PeakDetectorMSD.getPeakDetectorSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailablePeakDetectorIds()) {
                IPeakDetectorSupplier supplier = support.getPeakDetectorSupplier(processorId);
                list.add((IProcessSupplier<?>)new PeakDetectorProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoPeakDetectorAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class PeakDetectorProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IPeakDetectorSettingsMSD> {
        private IPeakDetectorSupplier supplier;

        public PeakDetectorProcessorSupplier(IPeakDetectorSupplier supplier, IProcessTypeSupplier parent) {
            super("PeakDetectorMSD." + supplier.getId(), supplier.getPeakDetectorName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IPeakDetectorSettingsMSD processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                if (processSettings instanceof IPeakDetectorSettingsMSD) {
                    messageConsumer.addMessages((MessageProvider)PeakDetectorMSD.detect(chromatogramSelectionMSD, processSettings, this.supplier.getId(), monitor));
                } else {
                    messageConsumer.addMessages((MessageProvider)PeakDetectorMSD.detect(chromatogramSelectionMSD, this.supplier.getId(), monitor));
                }
            } else {
                messageConsumer.addWarnMessage(this.getDescription(), "Only MSD Chromatogram supported, skipp processing");
            }
            return chromatogramSelection;
        }

        public boolean matchesId(String id) {
            return super.matchesId(id) || this.supplier.getId().equals(id);
        }
    }
}

