/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.internal.filter.BatchProcessJobEventFilter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.BatchProcessJob;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.model.ChromatogramInputEntry;
import org.eclipse.chemclipse.converter.model.IChromatogramInputEntry;
import org.eclipse.chemclipse.model.methods.ProcessEntry;
import org.eclipse.chemclipse.model.methods.ProcessMethod;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.core.runtime.IProgressMonitor;

public class JobReader {
    public BatchProcessJob read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        ProcessMethod processMethod = new ProcessMethod(ProcessMethod.CHROMATOGRAPHY);
        BatchProcessJob batchProcessJob = new BatchProcessJob((IProcessMethod)processMethod);
        try {
            this.readHeader(file, batchProcessJob);
            this.readChromatogramInputEntries(file, batchProcessJob, monitor);
            this.readChromatogramProcessEntries(file, processMethod, monitor);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return batchProcessJob;
    }

    private void readHeader(File file, BatchProcessJob batchProcessJob) throws XMLStreamException, IOException {
        XMLInputFactory.newInstance().setProperty("javax.xml.stream.isCoalescing", true);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        while (eventReader.hasNext()) {
            String elementName;
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                elementName = event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (event.isEndElement() && (elementName = event.asEndElement().getName().getLocalPart()).equals("Header")) break;
        }
        eventReader.close();
        bufferedInputStream.close();
    }

    private void readChromatogramInputEntries(File file, BatchProcessJob batchProcessJob, IProgressMonitor monitor) throws XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("InputEntry");
        BatchProcessJobEventFilter eventFilter = new BatchProcessJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        while (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            event = eventReader.nextEvent();
            ChromatogramInputEntry inputEntry = new ChromatogramInputEntry(event.asCharacters().getData());
            batchProcessJob.getChromatogramInputEntries().add((IChromatogramInputEntry)inputEntry);
        }
        eventReader.close();
        bufferedInputStream.close();
    }

    private void readChromatogramProcessEntries(File file, ProcessMethod method, IProgressMonitor monitor) throws XMLStreamException, IOException {
        String id = "";
        String name = "";
        String description = "";
        String jsonSettings = "{}";
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("ProcessEntry");
        BatchProcessJobEventFilter eventFilter = new BatchProcessJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        while (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            Iterator<Attribute> attributes = event.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                String attributeName = attribute.getName().getLocalPart();
                if (attributeName.equals("id")) {
                    id = attribute.getValue();
                    continue;
                }
                if (attributeName.equals("name")) {
                    name = attribute.getValue();
                    continue;
                }
                if (attributeName.equals("description")) {
                    description = attribute.getValue();
                    continue;
                }
                if (!attributeName.equals("jsonSettings")) continue;
                jsonSettings = attribute.getValue();
            }
            ProcessEntry processEntry = new ProcessEntry((ProcessEntryContainer)method);
            processEntry.setProcessorId(id);
            processEntry.setName(name);
            processEntry.setDescription(description);
            processEntry.setSettings(jsonSettings);
            method.getEntries().add(processEntry);
        }
        eventReader.close();
        bufferedInputStream.close();
    }
}

