/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.core;

import org.eclipse.chemclipse.chromatogram.msd.classifier.core.AbstractChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.IChromatogramClassifierResult;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.classifier.settings.IChromatogramClassifierSettings;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.processor.DurbinWatsonProcessor;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.result.DurbinWatsonClassifierResult;
import org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson.settings.ClassifierSettings;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.implementation.MeasurementResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class Classifier
extends AbstractChromatogramClassifier {
    public Classifier() {
        super(new DataType[]{DataType.MSD, DataType.WSD, DataType.CSD});
    }

    public IProcessingInfo<IChromatogramClassifierResult> applyClassifier(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramClassifierSettings chromatogramClassifierSettings, IProgressMonitor monitor) {
        ClassifierSettings classifierSettings = chromatogramClassifierSettings instanceof ClassifierSettings ? (ClassifierSettings)chromatogramClassifierSettings : PreferenceSupplier.getSettings();
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramClassifierSettings);
        if (!processingInfo.hasErrorMessages()) {
            DurbinWatsonProcessor durbinWatsonProcessor = new DurbinWatsonProcessor();
            DurbinWatsonClassifierResult durbinWatsonClassifierResult = new DurbinWatsonClassifierResult(ResultStatus.OK, "The chromatogram has been classified.");
            durbinWatsonProcessor.run(chromatogramSelection, classifierSettings, durbinWatsonClassifierResult, monitor);
            MeasurementResult measurementResult = new MeasurementResult("Durbin-Watson Classifier", "org.eclipse.chemclipse.chromatogram.xxd.classifier.supplier.durbinwatson", "This is the Durbin-Watson classifier result.", (Object)durbinWatsonClassifierResult);
            chromatogramSelection.getChromatogram().addMeasurementResult((IMeasurementResult)measurementResult);
            processingInfo.setProcessingResult((Object)durbinWatsonClassifierResult);
        }
        return processingInfo;
    }
}

