/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SnipCalculator {
    public static float[] calculateBaselineIntensityValues(float[] intensityValues, int iterations, IProgressMonitor monitor) {
        int size = intensityValues.length;
        float[] tmp = new float[size];
        int i = 1;
        while (i <= iterations) {
            int j = i;
            while (j < size - i) {
                float b = (intensityValues[j - i] + intensityValues[j + i]) / 2.0f;
                float a = intensityValues[j];
                if (b < a) {
                    a = b;
                }
                tmp[j] = a;
                ++j;
            }
            j = i;
            while (j < size - i) {
                intensityValues[j] = tmp[j];
                ++j;
            }
            ++i;
        }
        return intensityValues;
    }

    public static double[] calculateBaselineIntensityValues(double[] intensityValues, int iterations, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)iterations);
        double[] result = (double[])intensityValues.clone();
        int size = result.length;
        double[] tmp = new double[size];
        int i = 1;
        while (i <= iterations) {
            int j = i;
            while (j < size - i) {
                double b = (result[j - i] + result[j + i]) / 2.0;
                double a = result[j];
                if (b < a) {
                    a = b;
                }
                tmp[j] = a;
                ++j;
            }
            j = i;
            while (j < size - i) {
                result[j] = tmp[j];
                ++j;
            }
            subMonitor.worked(1);
            ++i;
        }
        return result;
    }
}

