/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.support;

import java.util.Arrays;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.FilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.IFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.BatchProcessWizardDialog;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.FilterWizard;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.internal.wizards.FiltersWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FiltersTable
extends Composite {
    private IFilterSettings filterSettings = new FilterSettings();
    private Table table;

    public FiltersTable(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public IFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public void moveSelectedDown() {
        List filters = this.filterSettings.getFilters();
        int i = this.table.getSelectionIndex();
        if (i > -1 && i < filters.size() - 1) {
            IFilter temp = (IFilter)filters.get(i);
            filters.set(i, (IFilter)filters.get(i + 1));
            filters.set(i + 1, temp);
            this.update();
        }
    }

    public void moveSelectedUp() {
        List filters = this.filterSettings.getFilters();
        int i = this.table.getSelectionIndex();
        if (i > 0) {
            IFilter temp = (IFilter)filters.get(i);
            filters.set(i, (IFilter)filters.get(i - 1));
            filters.set(i - 1, temp);
            this.update();
        }
    }

    public void createNewFilter() {
        IFilter filter;
        FiltersWizard filtersWizard = new FiltersWizard();
        BatchProcessWizardDialog wizardDialog = new BatchProcessWizardDialog(Display.getDefault().getActiveShell(), (IWizard)filtersWizard);
        if (wizardDialog.open() == 0 && (filter = filtersWizard.getFilterType()) != null) {
            FilterWizard filterWizard = new FilterWizard(filter);
            wizardDialog = new BatchProcessWizardDialog(Display.getDefault().getActiveShell(), (IWizard)filterWizard);
            wizardDialog.setMinimumPageSize(300, 600);
            if (wizardDialog.open() == 0) {
                this.filterSettings.getFilters().add(filter);
                this.update();
            }
        }
    }

    public void removeSelected() {
        Arrays.stream(this.table.getSelection()).forEach(i -> {
            boolean bl = this.filterSettings.getFilters().remove(i.getData());
        });
        this.update();
    }

    public void removeAll() {
        this.filterSettings.getFilters().clear();
        this.update();
    }

    public void setInput(IFilterSettings filterSettings) {
        this.filterSettings = filterSettings;
        this.update();
    }

    public void update() {
        this.table.removeAll();
        this.table.clearAll();
        if (this.filterSettings != null) {
            List filters = this.filterSettings.getFilters();
            int i = 0;
            while (i < filters.size()) {
                TableItem tableItem = new TableItem(this.table, 0);
                IFilter filter = (IFilter)filters.get(i);
                tableItem.setText(0, filter.getName());
                tableItem.setText(1, filter.getDataTypeProcessing().toString());
                tableItem.setText(2, filter.getDescription());
                tableItem.setText(3, filter.getSelectionResult());
                tableItem.setData((Object)filter);
                ++i;
            }
            i = 0;
            while (i < this.table.getColumns().length) {
                this.table.getColumn(i).pack();
                this.table.getColumn(i).setWidth(this.table.getColumn(i).getWidth() + 20);
                ++i;
            }
        }
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        this.table = this.createTable(this);
    }

    private Table createTable(Composite parent) {
        Table table = new Table(parent, 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(8, e -> {
            int i = table.getSelectionIndex();
            if (i >= 0) {
                IFilter filter = (IFilter)this.filterSettings.getFilters().get(i);
                FilterWizard filterWizard = new FilterWizard(filter);
                BatchProcessWizardDialog wizardDialog = new BatchProcessWizardDialog(Display.getCurrent().getActiveShell(), (IWizard)filterWizard);
                if (wizardDialog.open() == 0) {
                    this.update();
                }
            }
        });
        String[] columns = new String[]{"Name", "Use", "Description", "Number of selected variables or error"};
        int i = 0;
        while (i < columns.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(columns[i]);
            ++i;
        }
        return table;
    }
}

