/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.PeakSampleData;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Sample;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Samples;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.statistics.RetentionTime;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakExtractionSupport {
    private static final String DELIMITER = ",";
    private final int retentionTimeWindow;

    public PeakExtractionSupport(int retentionTimeWindow) {
        this.retentionTimeWindow = retentionTimeWindow;
    }

    private List<Integer> calculateCondensedRetentionTimes(Map<String, SortedMap<Integer, IPeak>> extractPeaks) {
        TreeSet<Integer> rententionTimes = new TreeSet<Integer>();
        for (Map.Entry<String, SortedMap<Integer, IPeak>> extractPeak : extractPeaks.entrySet()) {
            for (Integer retentionTime : extractPeak.getValue().keySet()) {
                rententionTimes.add(retentionTime);
            }
        }
        return new ArrayList<Integer>(rententionTimes);
    }

    private Map<String, SortedMap<Integer, IPeak>> exctractPcaPeakMap(Map<String, IPeaks<?>> peakMap, int retentionTimeWindow) {
        LinkedHashMap<String, TreeMap<Integer, IPeak>> pcaPeakRetentionTime = new LinkedHashMap<String, TreeMap<Integer, IPeak>>();
        LinkedHashMap<String, SortedMap<Integer, IPeak>> pcaPeakCondenseRetentionTime = new LinkedHashMap<String, SortedMap<Integer, IPeak>>();
        int totalCountPeak = 0;
        for (Map.Entry<String, IPeaks<?>> peakEnry : peakMap.entrySet()) {
            String name = peakEnry.getKey();
            IPeaks<?> peaks = peakEnry.getValue();
            TreeMap<Integer, IPeak> peakTree = new TreeMap<Integer, IPeak>();
            for (IPeak peak : peaks.getPeaks()) {
                int retentionTime = peak.getPeakModel().getRetentionTimeAtPeakMaximum();
                peakTree.put(retentionTime, peak);
            }
            totalCountPeak += peakTree.size();
            pcaPeakRetentionTime.put(name, peakTree);
        }
        while (totalCountPeak != 0) {
            SortedMap<Double, Collection<Integer>> weightRetentionTime = this.setWeightRetentionTimes(pcaPeakRetentionTime, retentionTimeWindow);
            Iterator<Map.Entry<Double, Collection<Integer>>> it = weightRetentionTime.entrySet().iterator();
            TreeSet<Integer> condenseRetentionTimes = new TreeSet<Integer>();
            while (it.hasNext() && totalCountPeak != 0) {
                Map.Entry<Double, Collection<Integer>> entry = it.next();
                Collection<Integer> retentionTimesMax = entry.getValue();
                for (Integer retentionTimeMax : retentionTimesMax) {
                    Integer closestCondenseRetentionTime = this.getClosestCondensedRetentionTime(condenseRetentionTimes, retentionTimeMax);
                    if (closestCondenseRetentionTime != null && Math.abs(closestCondenseRetentionTime - retentionTimeMax) < retentionTimeWindow) continue;
                    condenseRetentionTimes.add(retentionTimeMax);
                    for (Map.Entry pcaPeakRetetntionTime : pcaPeakRetentionTime.entrySet()) {
                        TreeMap peakTree = (TreeMap)pcaPeakRetetntionTime.getValue();
                        String name = (String)pcaPeakRetetntionTime.getKey();
                        IPeak closestPeak = this.getClosestPeak(peakTree, retentionTimeMax);
                        if (closestPeak == null) continue;
                        int peakRetentionTime = closestPeak.getPeakModel().getRetentionTimeAtPeakMaximum();
                        int dist = Math.abs(retentionTimeMax - peakRetentionTime);
                        if (dist > retentionTimeWindow) continue;
                        --totalCountPeak;
                        peakTree.remove(peakRetentionTime);
                        TreeMap<Integer, IPeak> extractPeaks = (TreeMap<Integer, IPeak>)pcaPeakCondenseRetentionTime.get(name);
                        if (extractPeaks == null) {
                            extractPeaks = new TreeMap<Integer, IPeak>();
                            extractPeaks.put(retentionTimeMax, closestPeak);
                            pcaPeakCondenseRetentionTime.put(name, extractPeaks);
                            continue;
                        }
                        extractPeaks.put(retentionTimeMax, closestPeak);
                    }
                }
            }
        }
        return pcaPeakCondenseRetentionTime;
    }

    public Samples extractPeakData(Map<IDataInputEntry, IPeaks<?>> peaks, IProgressMonitor monitor) {
        Samples samples = new Samples(peaks.keySet());
        LinkedHashMap peakMap = new LinkedHashMap();
        peaks.forEach((dataInputEntry, peaksInput) -> peakMap.put(dataInputEntry.getName(), (IPeaks<?>)peaksInput));
        Map<String, SortedMap<Integer, IPeak>> extractPeaks = this.exctractPcaPeakMap(peakMap, this.retentionTimeWindow);
        List<Integer> extractedRetentionTimes = this.calculateCondensedRetentionTimes(extractPeaks);
        samples.getVariables().addAll(RetentionTime.create(extractedRetentionTimes));
        this.setExtractData(extractPeaks, samples);
        this.setClassifierAndDescription(samples);
        return samples;
    }

    private Integer getClosestCondensedRetentionTime(TreeSet<Integer> condensedRetentionTimes, int retentionTime) {
        Integer peakRetentionTimeCeil = condensedRetentionTimes.ceiling(retentionTime);
        Integer peakRetentionTimeFlour = condensedRetentionTimes.floor(retentionTime);
        if (peakRetentionTimeCeil != null && peakRetentionTimeFlour != null) {
            if (peakRetentionTimeCeil - retentionTime < retentionTime - peakRetentionTimeFlour) {
                return peakRetentionTimeCeil;
            }
            return peakRetentionTimeFlour;
        }
        if (peakRetentionTimeCeil != null) {
            return peakRetentionTimeCeil;
        }
        if (peakRetentionTimeFlour != null) {
            return peakRetentionTimeFlour;
        }
        return null;
    }

    private IPeak getClosestPeak(TreeMap<Integer, IPeak> peakTree, int retentionTime) {
        Map.Entry<Integer, IPeak> peakRetentionTimeCeil = peakTree.ceilingEntry(retentionTime);
        Map.Entry<Integer, IPeak> peakRetentionTimeFlour = peakTree.floorEntry(retentionTime);
        if (peakRetentionTimeCeil != null && peakRetentionTimeFlour != null) {
            if (peakRetentionTimeCeil.getKey() - retentionTime < retentionTime - peakRetentionTimeFlour.getKey()) {
                return peakRetentionTimeCeil.getValue();
            }
            return peakRetentionTimeFlour.getValue();
        }
        if (peakRetentionTimeCeil != null) {
            return peakRetentionTimeCeil.getValue();
        }
        if (peakRetentionTimeFlour != null) {
            return peakRetentionTimeFlour.getValue();
        }
        return null;
    }

    private void setExtractData(Map<String, SortedMap<Integer, IPeak>> extractData, Samples samples) {
        List extractedRetentionTimes = samples.getVariables();
        for (Sample sample : samples.getSampleList()) {
            Iterator it = extractedRetentionTimes.iterator();
            SortedMap<Integer, IPeak> extractPeak = extractData.get(sample.getName());
            while (it.hasNext()) {
                PeakSampleData sampleData;
                int retentionTime = ((RetentionTime)it.next()).getRetentionTime();
                IPeak peak = (IPeak)extractPeak.get(retentionTime);
                if (peak != null) {
                    sampleData = new PeakSampleData(peak.getIntegratedArea(), peak);
                    sampleData.setPeak(peak);
                    sample.getSampleData().add(sampleData);
                    continue;
                }
                sampleData = new PeakSampleData();
                sample.getSampleData().add(sampleData);
            }
        }
    }

    private SortedMap<Double, Collection<Integer>> setWeightRetentionTimes(Map<String, TreeMap<Integer, IPeak>> pcaPeakRetetntionTimeMap, int retentionTimeWindow) {
        LinkedHashMap<Integer, Double> peakSum = new LinkedHashMap<Integer, Double>();
        int step = 1;
        if (retentionTimeWindow > 400) {
            step = retentionTimeWindow / 400;
            retentionTimeWindow = retentionTimeWindow / step / 2 * step * 2;
        }
        for (TreeMap<Integer, IPeak> peaks : pcaPeakRetetntionTimeMap.values()) {
            for (Integer retentionTime : peaks.keySet()) {
                retentionTime = retentionTime / step * step;
                int i = retentionTime - retentionTimeWindow / 2;
                while (i <= retentionTime + retentionTimeWindow / 2) {
                    int dis = Math.abs(i - retentionTime);
                    double value = 1.0 / (double)((dis + 1) * (dis + 1));
                    Double actualValue = (Double)peakSum.get(i);
                    if (actualValue == null) {
                        peakSum.put(i, value);
                    } else {
                        peakSum.put(i, value + actualValue);
                    }
                    i += step;
                }
            }
        }
        TreeMap<Double, Collection<Integer>> sortedWeightRetentionTimes = new TreeMap<Double, Collection<Integer>>((o1, o2) -> -Double.compare(o1, o2));
        peakSum.forEach((k, v) -> {
            if (!(v < 1.0)) {
                LinkedList<Integer> retentionTimes = (LinkedList<Integer>)sortedWeightRetentionTimes.get(v);
                if (retentionTimes == null) {
                    retentionTimes = new LinkedList<Integer>();
                    retentionTimes.add((Integer)k);
                    sortedWeightRetentionTimes.put((Double)v, (Collection<Integer>)retentionTimes);
                } else {
                    retentionTimes.add((Integer)k);
                }
            }
        });
        return sortedWeightRetentionTimes;
    }

    private void setClassifierAndDescription(Samples samples) {
        int i = 0;
        while (i < samples.getVariables().size()) {
            Iterator iterator;
            ArrayList list;
            StringBuilder stringBuilder;
            int j = i;
            HashSet descriptions = new HashSet();
            HashSet classifier = new HashSet();
            samples.getSampleList().stream().map(s -> s.getSampleData()).map(d -> ((PeakSampleData)((Object)((Object)d.get(j)))).getPeak()).forEach(peak -> {
                if (peak.isPresent()) {
                    classifier.addAll(((IPeak)peak.get()).getClassifier());
                    ILibraryInformation libraryInformation = IIdentificationTarget.getBestLibraryInformation((Set)((IPeak)peak.get()).getTargets());
                    if (libraryInformation != null) {
                        descriptions.add(libraryInformation.getName());
                    }
                }
            });
            if (!classifier.isEmpty()) {
                stringBuilder = new StringBuilder();
                list = new ArrayList(classifier);
                Collections.sort(list);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(DELIMITER);
                    stringBuilder.append(" ");
                }
                ((RetentionTime)samples.getVariables().get(i)).setClassification(stringBuilder.toString());
            }
            if (!descriptions.isEmpty()) {
                stringBuilder = new StringBuilder();
                list = new ArrayList(descriptions);
                Collections.sort(list);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(DELIMITER);
                    stringBuilder.append(" ");
                }
                ((RetentionTime)samples.getVariables().get(i)).setDescription(stringBuilder.toString());
            }
            ++i;
        }
    }
}

