/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IPreprocessingSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ICentering;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.INormalization;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.IReplacer;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.ITransformation;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.MeanValuesReplacer;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;
import org.eclipse.core.runtime.IProgressMonitor;

public class PreprocessingSettings
implements IPreprocessingSettings {
    private ICentering centering = null;
    private INormalization normalization = null;
    private ITransformation transformation = null;
    private IReplacer replacer = new MeanValuesReplacer();
    private boolean onlySelected = false;
    private boolean removeUselessVariables = true;
    private boolean modifyOnlySelectedVariable = false;

    public PreprocessingSettings() {
    }

    public PreprocessingSettings(IPreprocessingSettings preprocessingSettings) {
        this.setCentering(preprocessingSettings.getCentering());
        this.setNormalization(preprocessingSettings.getNormalization());
        this.setTransformation(preprocessingSettings.getTransformation());
        this.setReplacer(preprocessingSettings.getReplacer());
        this.onlySelected = preprocessingSettings.isOnlySelected();
        this.removeUselessVariables = preprocessingSettings.isRemoveUselessVariables();
        this.modifyOnlySelectedVariable = preprocessingSettings.isModifyOnlySelectedVariable();
    }

    @Override
    public boolean availableModification() {
        return this.normalization != null || this.transformation != null || this.centering != null;
    }

    @Override
    public ICentering getCentering() {
        return this.centering;
    }

    @Override
    public void setCentering(ICentering centering) {
        this.centering = centering;
    }

    @Override
    public INormalization getNormalization() {
        return this.normalization;
    }

    @Override
    public void setNormalization(INormalization normalization) {
        this.normalization = normalization;
    }

    @Override
    public ITransformation getTransformation() {
        return this.transformation;
    }

    @Override
    public void setTransformation(ITransformation transformation) {
        this.transformation = transformation;
    }

    @Override
    public IReplacer getReplacer() {
        return this.replacer;
    }

    @Override
    public void setReplacer(IReplacer replacer) {
        this.replacer = replacer != null ? replacer : new MeanValuesReplacer();
    }

    @Override
    public boolean isModifyOnlySelectedVariable() {
        return this.modifyOnlySelectedVariable;
    }

    @Override
    public void setModifyOnlySelectedVariable(boolean modifyOnlySelectedVariable) {
        this.modifyOnlySelectedVariable = modifyOnlySelectedVariable;
    }

    @Override
    public boolean isOnlySelected() {
        return this.onlySelected;
    }

    @Override
    public void setOnlySelected(boolean onlySelected) {
        this.onlySelected = onlySelected;
    }

    @Override
    public boolean isRemoveUselessVariables() {
        return this.removeUselessVariables;
    }

    @Override
    public void setRemoveUselessVariables(boolean removeUselessVariables) {
        this.removeUselessVariables = removeUselessVariables;
    }

    @Override
    public <V extends IVariable, S extends ISample> void process(ISamples<V, S> samples, IProgressMonitor monitor) {
        for (ISample sample : samples.getSampleList()) {
            sample.getSampleData().stream().forEach(sampleData -> {
                double data = sampleData.getData();
                sampleData.setModifiedData(data);
            });
        }
        this.normalize(samples);
        this.replaceEmptyValues(samples);
        this.transform(samples);
        this.centerAndScale(samples);
    }

    private <V extends IVariable, S extends ISample> void normalize(ISamples<V, S> samples) {
        if (this.normalization != null) {
            this.normalization.setOnlySelected(this.onlySelected);
            this.normalization.setRemoveUselessVariables(this.removeUselessVariables);
            this.normalization.setModifyOnlySelectedVariable(this.modifyOnlySelectedVariable);
            this.normalization.process(samples);
        }
    }

    private <V extends IVariable, S extends ISample> void replaceEmptyValues(ISamples<V, S> samples) {
        if (this.replacer != null) {
            this.replacer.setOnlySelected(this.onlySelected);
            this.replacer.setRemoveUselessVariables(this.removeUselessVariables);
            this.replacer.setModifyOnlySelectedVariable(this.modifyOnlySelectedVariable);
            this.replacer.process(samples);
        }
    }

    private <V extends IVariable, S extends ISample> void transform(ISamples<V, S> samples) {
        if (this.transformation != null) {
            this.transformation.setOnlySelected(this.onlySelected);
            this.transformation.setRemoveUselessVariables(this.removeUselessVariables);
            this.transformation.setModifyOnlySelectedVariable(this.modifyOnlySelectedVariable);
            this.transformation.process(samples);
        }
    }

    private <V extends IVariable, S extends ISample> void centerAndScale(ISamples<V, S> samples) {
        if (this.centering != null) {
            this.centering.setOnlySelected(this.onlySelected);
            this.centering.setRemoveUselessVariables(this.removeUselessVariables);
            this.centering.setModifyOnlySelectedVariable(this.modifyOnlySelectedVariable);
            this.centering.process(samples);
        }
    }
}

