/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalDouble;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.exception.MathIllegalArgumentException;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.AbstractMultivariateCalculator;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class CalculatorOPLS
extends AbstractMultivariateCalculator {
    public CalculatorOPLS(int numObs, int numVars, int numComps) throws MathIllegalArgumentException {
        super(numObs, numVars, numComps);
    }

    private DMatrixRMaj getYVector() {
        HashSet<String> groupNamesSet = new HashSet<String>();
        ArrayList<String> groupNames = this.getGroupNames();
        double[] vector = new double[groupNames.size()];
        groupNamesSet.addAll(groupNames);
        List<String> uniqueGroupNames = Arrays.asList(groupNamesSet.toArray(new String[groupNamesSet.size()]));
        int yIterator = 0;
        for (String myString : groupNames) {
            vector[yIterator] = uniqueGroupNames.indexOf(myString);
            ++yIterator;
        }
        DMatrixRMaj yVector = new DMatrixRMaj(groupNames.size(), 1, true, vector);
        return yVector;
    }

    private DMatrixRMaj getAvgYVector() {
        double[] yVector = this.getYVector().data;
        double[] avgYData = new double[yVector.length];
        OptionalDouble avgValue = Arrays.stream(yVector).average();
        if (avgValue.isPresent()) {
            Arrays.fill(avgYData, avgValue.getAsDouble());
        }
        DMatrixRMaj avgYVector = new DMatrixRMaj(yVector.length, 1, true, avgYData);
        return avgYVector;
    }

    private DMatrixRMaj getAvgXVector() {
        DMatrixRMaj X = this.getSampleData();
        DMatrixRMaj avgOfCols = new DMatrixRMaj(1, this.getSampleData().getNumCols());
        CommonOps_DDRM.sumCols((DMatrixRMaj)X, (DMatrixRMaj)avgOfCols);
        CommonOps_DDRM.divide((DMatrixD1)avgOfCols, (double)this.getSampleData().getNumRows());
        return avgOfCols;
    }

    private DMatrixRMaj getSDXVector() {
        DMatrixRMaj X = this.getSampleData().copy();
        DMatrixRMaj avgOfCols = this.getAvgXVector();
        DMatrixRMaj sdXVector = new DMatrixRMaj(1, this.getSampleData().getNumCols());
        int i = 0;
        while (i < this.getSampleData().getNumCols()) {
            int j = 0;
            while (j < this.getSampleData().getNumRows()) {
                X.set(j, i, X.get(j, i) - avgOfCols.get(0, i));
                X.set(j, i, X.get(j, i) * X.get(j, i));
                ++j;
            }
            ++i;
        }
        CommonOps_DDRM.sumCols((DMatrixRMaj)X, (DMatrixRMaj)sdXVector);
        i = 0;
        while (i < this.getSampleData().getNumCols()) {
            sdXVector.set(0, i, Math.sqrt(sdXVector.get(0, i)));
            ++i;
        }
        return sdXVector;
    }

    @Override
    public void compute() {
        int numberOfSamples = this.getSampleData().getNumRows();
        int numberOfVariables = this.getSampleData().getNumCols();
        DMatrixRMaj T_ortho = new DMatrixRMaj(numberOfSamples, this.getNumComps() - 1);
        DMatrixRMaj P_ortho = new DMatrixRMaj(this.getNumComps() - 1, numberOfVariables);
        DMatrixRMaj W_ortho = new DMatrixRMaj(this.getNumComps() - 1, numberOfVariables);
        DMatrixRMaj t_ortho = new DMatrixRMaj(numberOfSamples, 1);
        DMatrixRMaj p_ortho = new DMatrixRMaj(1, numberOfVariables);
        DMatrixRMaj w_ortho = new DMatrixRMaj(1, numberOfVariables);
        DMatrixRMaj X = new DMatrixRMaj(1, 1);
        X.set((DMatrixD1)this.getSampleData());
        DMatrixRMaj y = new DMatrixRMaj(1, 1);
        y.set((DMatrixD1)this.getYVector());
        DMatrixRMaj te = new DMatrixRMaj(numberOfSamples, 1);
        DMatrixRMaj p = new DMatrixRMaj(1, numberOfVariables);
        DMatrixRMaj w = new DMatrixRMaj(1, numberOfVariables);
        DMatrixRMaj u = new DMatrixRMaj(numberOfSamples, 1);
        DMatrixRMaj ce = new DMatrixRMaj(1, 1);
        DMatrixRMaj b = new DMatrixRMaj(numberOfVariables, 1);
        DMatrixRMaj yy = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.multInner((DMatrix1Row)y, (DMatrix1Row)yy);
        CommonOps_DDRM.multTransA((DMatrix1Row)y, (DMatrix1Row)X, (DMatrix1Row)w);
        CommonOps_DDRM.divide((DMatrixD1)w, (double)yy.get(0));
        DMatrixRMaj ww = new DMatrixRMaj(1, 1);
        CommonOps_DDRM.transpose((DMatrixRMaj)w);
        CommonOps_DDRM.multInner((DMatrix1Row)w, (DMatrix1Row)ww);
        double absW = Math.sqrt(ww.get(0));
        CommonOps_DDRM.divide((DMatrixD1)w, (double)absW);
        int i = 0;
        while (i < this.getNumComps()) {
            DMatrixRMaj wTemp = new DMatrixRMaj(1, 1);
            CommonOps_DDRM.multInner((DMatrix1Row)w, (DMatrix1Row)wTemp);
            CommonOps_DDRM.mult((DMatrix1Row)X, (DMatrix1Row)w, (DMatrix1Row)te);
            CommonOps_DDRM.divide((DMatrixD1)te, (double)wTemp.get(0));
            DMatrixRMaj tTemp = new DMatrixRMaj(1, 1);
            CommonOps_DDRM.multInner((DMatrix1Row)te, (DMatrix1Row)tTemp);
            CommonOps_DDRM.multTransA((DMatrix1Row)te, (DMatrix1Row)y, (DMatrix1Row)ce);
            CommonOps_DDRM.divide((DMatrixD1)ce, (double)tTemp.get(0));
            DMatrixRMaj cTemp = new DMatrixRMaj(1, 1);
            CommonOps_DDRM.multInner((DMatrix1Row)ce, (DMatrix1Row)cTemp);
            CommonOps_DDRM.mult((DMatrix1Row)y, (DMatrix1Row)ce, (DMatrix1Row)u);
            CommonOps_DDRM.divide((DMatrixD1)u, (double)cTemp.get(0));
            CommonOps_DDRM.multTransA((DMatrix1Row)te, (DMatrix1Row)X, (DMatrix1Row)p);
            CommonOps_DDRM.divide((DMatrixD1)p, (double)tTemp.get(0));
            if (i < this.getNumComps() - 1) {
                DMatrixRMaj wTemp2 = new DMatrixRMaj(1, 1);
                DMatrixRMaj w_ortho_temp = new DMatrixRMaj(numberOfVariables, 1);
                DMatrixRMaj wTemp3 = new DMatrixRMaj(1, numberOfVariables);
                CommonOps_DDRM.multTransAB((DMatrix1Row)w, (DMatrix1Row)p, (DMatrix1Row)wTemp2);
                CommonOps_DDRM.divide((DMatrixD1)wTemp2, (double)wTemp.get(0));
                CommonOps_DDRM.mult((DMatrix1Row)w, (DMatrix1Row)wTemp2, (DMatrix1Row)w_ortho_temp);
                CommonOps_DDRM.transpose((DMatrixRMaj)w_ortho_temp);
                CommonOps_DDRM.subtract((DMatrixD1)p, (DMatrixD1)w_ortho_temp, (DMatrixD1)w_ortho);
                DMatrixRMaj ww_ortho = new DMatrixRMaj(1, 1);
                CommonOps_DDRM.transpose((DMatrixRMaj)w_ortho);
                CommonOps_DDRM.multInner((DMatrix1Row)w_ortho, (DMatrix1Row)ww_ortho);
                double absW_ortho = Math.sqrt(ww_ortho.get(0));
                CommonOps_DDRM.divide((DMatrixD1)w_ortho, (double)absW_ortho);
                CommonOps_DDRM.transpose((DMatrixRMaj)w_ortho_temp);
                CommonOps_DDRM.multInner((DMatrix1Row)w_ortho_temp, (DMatrix1Row)ww_ortho);
                CommonOps_DDRM.mult((DMatrix1Row)X, (DMatrix1Row)w_ortho, (DMatrix1Row)t_ortho);
                CommonOps_DDRM.divide((DMatrixD1)t_ortho, (double)ww_ortho.get(0));
                DMatrixRMaj tt_temp = new DMatrixRMaj(1, 1);
                CommonOps_DDRM.multInner((DMatrix1Row)t_ortho, (DMatrix1Row)tt_temp);
                CommonOps_DDRM.multTransA((DMatrix1Row)t_ortho, (DMatrix1Row)X, (DMatrix1Row)p_ortho);
                CommonOps_DDRM.divide((DMatrixD1)p_ortho, (double)tt_temp.get(0));
                DMatrixRMaj X_temp = new DMatrixRMaj(numberOfSamples, numberOfVariables);
                CommonOps_DDRM.mult((DMatrix1Row)t_ortho, (DMatrix1Row)p_ortho, (DMatrix1Row)X_temp);
                CommonOps_DDRM.subtract((DMatrixD1)X, (DMatrixD1)X_temp, (DMatrixD1)X);
                int j = 0;
                while (j < numberOfSamples) {
                    T_ortho.set(j, i, t_ortho.get(j));
                    ++j;
                }
                int k = 0;
                while (k < numberOfVariables) {
                    P_ortho.set(i, k, p_ortho.get(k));
                    W_ortho.set(i, k, w_ortho.get(k));
                    ++k;
                }
                CommonOps_DDRM.transpose((DMatrixRMaj)w_ortho);
            }
            ++i;
        }
        CommonOps_DDRM.mult((DMatrix1Row)w, (DMatrix1Row)ce, (DMatrix1Row)b);
        double[] combinedScores = new double[numberOfSamples * this.getNumComps()];
        System.arraycopy(te.getData(), 0, combinedScores, 0, numberOfSamples);
        System.arraycopy(T_ortho.getData(), 0, combinedScores, numberOfSamples, numberOfSamples * (this.getNumComps() - 1));
        DMatrixRMaj scores = new DMatrixRMaj(numberOfSamples, this.getNumComps(), false, combinedScores);
        this.setScores(scores);
        double[] combinedLoadings = new double[this.getNumComps() * numberOfVariables];
        System.arraycopy(p.getData(), 0, combinedLoadings, 0, numberOfVariables);
        System.arraycopy(P_ortho.getData(), 0, combinedLoadings, numberOfVariables, (this.getNumComps() - 1) * numberOfVariables);
        DMatrixRMaj loadings = new DMatrixRMaj(this.getNumComps(), numberOfVariables, true, combinedLoadings);
        this.setLoadings(loadings);
        this.setComputeSuccess();
    }
}

