/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.AbstractFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.IFilter;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class AbundanceFilter
extends AbstractFilter
implements IFilter {
    public static final int ALL_VALUE = 0;
    public static final int ANY_VALUE = 1;
    public static final int LIMIT_GREATER_THAN = 0;
    public static final int LIMIT_LESS_THAN = 1;
    private Function<Double, Boolean> comparator;
    private int filterType = 0;
    private Function<Double, Boolean> gt = d -> d > this.limitValue;
    private int limitType = 0;
    private double limitValue = 0.0;
    private Function<Double, Boolean> lt = d -> d < this.limitValue;
    private final String name = "Abundance filter";
    private String selectionResult = "";

    public AbundanceFilter() {
        super(IFilter.DataTypeProcessing.RAW_DATA);
        this.comparator = this.gt;
    }

    @Override
    public <V extends IVariable, S extends ISample> List<Boolean> filter(ISamples<V, S> samples) {
        List<S> selectedSamples = this.selectSamples(samples);
        ArrayList<Boolean> selection = new ArrayList<Boolean>();
        int i = 0;
        while (i < ((ISample)selectedSamples.get(0)).getSampleData().size()) {
            int index = i;
            DoubleStream stream = selectedSamples.stream().mapToDouble(s -> this.getData((ISampleData)s.getSampleData().get(index)));
            boolean b = this.filterType == 0 ? stream.allMatch(d -> this.comparator.apply(d)) : stream.anyMatch(d -> this.comparator.apply(d));
            selection.add(b);
            ++i;
        }
        this.selectionResult = IFilter.getNumberSelectedRow(selection);
        return selection;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.filterType == 0) {
            sb.append("All values in row have to be");
        } else {
            sb.append("At least one value in row has to be");
        }
        if (this.limitType == 0) {
            sb.append(" greater than ");
        } else {
            sb.append(" less than ");
        }
        sb.append(this.limitValue);
        return sb.toString();
    }

    public int getFilterType() {
        return this.filterType;
    }

    public int getLimitType() {
        return this.limitType;
    }

    public double getLimitValue() {
        return this.limitValue;
    }

    @Override
    public String getName() {
        return "Abundance filter";
    }

    @Override
    public String getSelectionResult() {
        return this.selectionResult;
    }

    public void setFilterType(int filterType) {
        if (filterType == 0 || filterType == 1) {
            this.filterType = filterType;
        }
    }

    public void setlimitType(int limitType) {
        switch (limitType) {
            case 0: {
                this.comparator = this.gt;
                break;
            }
            case 1: {
                this.comparator = this.lt;
                break;
            }
            default: {
                return;
            }
        }
        this.limitType = limitType;
    }

    public void setLimitValue(double limitValue) {
        this.limitValue = limitValue;
    }
}

