/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.AbstractScaling;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class ScalingRange
extends AbstractScaling {
    public ScalingRange(int centeringType) {
        super(centeringType);
    }

    @Override
    public String getDescription() {
        return "Range scaling";
    }

    @Override
    public String getName() {
        return "Range scaling";
    }

    private <S extends ISample> double getMax(List<S> samples, int index) {
        boolean onlySelected = this.isOnlySelected();
        return samples.stream().filter(s -> s.isSelected() || !onlySelected).map(s -> (ISampleData)s.getSampleData().get(index)).mapToDouble(s -> this.getData((ISampleData)s)).summaryStatistics().getMax();
    }

    private <S extends ISample> double getMin(List<S> samples, int index) {
        boolean onlySelected = this.isOnlySelected();
        return samples.stream().filter(s -> s.isSelected() || !onlySelected).map(s -> (ISampleData)s.getSampleData().get(index)).mapToDouble(s -> this.getData((ISampleData)s)).summaryStatistics().getMin();
    }

    @Override
    public <V extends IVariable, S extends ISample> void process(ISamples<V, S> samples) {
        boolean onlySelected = this.isOnlySelected();
        int centeringType = this.getCenteringType();
        List variables = samples.getVariables();
        List samplesList = samples.getSampleList();
        int i = 0;
        while (i < variables.size()) {
            if (!this.skipVariable(samples, i)) {
                double mean = this.getCenteringValue(samplesList, i, centeringType);
                double max = this.getMax(samplesList, i);
                double min = this.getMin(samplesList, i);
                for (ISample sample : samplesList) {
                    ISampleData sampleData = (ISampleData)sample.getSampleData().get(i);
                    if (!sample.isSelected() && onlySelected) continue;
                    double data = this.getData(sampleData);
                    double scaleData = (data - mean) / (max - min);
                    sampleData.setModifiedData(scaleData);
                }
            }
            ++i;
        }
    }
}

