/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;

public abstract class AbstractQuantitationEntry
implements IQuantitationEntry {
    private static final long serialVersionUID = -6312658397485712262L;
    private static final String DESCRIPTION_DELIMITER = " | ";
    private double signal = 0.0;
    private String name = "";
    private String chemicalClass = "";
    private double concentration = 0.0;
    private String concentrationUnit = "";
    private double area = 0.0;
    private String calibrationMethod = "";
    private boolean usedCrossZero = true;
    private String description = "";

    public AbstractQuantitationEntry(String name, double concentration, String concentrationUnit, double area) {
        this.name = name;
        this.concentration = concentration;
        this.concentrationUnit = concentrationUnit;
        this.area = area;
    }

    @Override
    public double getSignal() {
        return this.signal;
    }

    @Override
    public void setSignal(double signal) {
        this.signal = signal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getChemicalClass() {
        return this.chemicalClass;
    }

    @Override
    public void setChemicalClass(String chemicalClass) {
        this.chemicalClass = chemicalClass;
    }

    @Override
    public double getConcentration() {
        return this.concentration;
    }

    @Override
    public String getConcentrationUnit() {
        return this.concentrationUnit;
    }

    @Override
    public double getArea() {
        return this.area;
    }

    @Override
    public String getCalibrationMethod() {
        return this.calibrationMethod;
    }

    @Override
    public void setCalibrationMethod(String calibrationMethod) {
        if (calibrationMethod != null) {
            this.calibrationMethod = calibrationMethod;
        }
    }

    @Override
    public boolean getUsedCrossZero() {
        return this.usedCrossZero;
    }

    @Override
    public void setUsedCrossZero(boolean usedCrossZero) {
        this.usedCrossZero = usedCrossZero;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void appendDescription(String description) {
        if (description != null && !this.description.contains(description)) {
            this.description = this.description.length() == 0 ? description : String.valueOf(this.description) + DESCRIPTION_DELIMITER + description;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.area);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.calibrationMethod == null ? 0 : this.calibrationMethod.hashCode());
        result = 31 * result + (this.chemicalClass == null ? 0 : this.chemicalClass.hashCode());
        temp = Double.doubleToLongBits(this.concentration);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.concentrationUnit == null ? 0 : this.concentrationUnit.hashCode());
        result = 31 * result + (this.usedCrossZero ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQuantitationEntry other = (AbstractQuantitationEntry)obj;
        if (Double.doubleToLongBits(this.area) != Double.doubleToLongBits(other.area)) {
            return false;
        }
        if (this.calibrationMethod == null ? other.calibrationMethod != null : !this.calibrationMethod.equals(other.calibrationMethod)) {
            return false;
        }
        if (this.chemicalClass == null ? other.chemicalClass != null : !this.chemicalClass.equals(other.chemicalClass)) {
            return false;
        }
        if (Double.doubleToLongBits(this.concentration) != Double.doubleToLongBits(other.concentration)) {
            return false;
        }
        if (this.concentrationUnit == null ? other.concentrationUnit != null : !this.concentrationUnit.equals(other.concentrationUnit)) {
            return false;
        }
        return this.usedCrossZero == other.usedCrossZero;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("name=" + this.name);
        builder.append(",");
        builder.append("chemicalClass=" + this.chemicalClass);
        builder.append(",");
        builder.append("concentration=" + this.concentration);
        builder.append(",");
        builder.append("concentrationUnit=" + this.concentrationUnit);
        builder.append(",");
        builder.append("area=" + this.area);
        builder.append(",");
        builder.append("calibrationMethod=" + this.calibrationMethod);
        builder.append(",");
        builder.append("usedCrossZero=" + this.usedCrossZero);
        builder.append(",");
        builder.append("description=" + this.description);
        builder.append("]");
        return builder.toString();
    }
}

