/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.selection;

import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.updates.IChromatogramUpdateListener;
import org.eclipse.chemclipse.numeric.core.Point;

public interface IChromatogramSelection<P extends IPeak, C extends IChromatogram<P>>
extends IChromatogramUpdateListener,
IRetentionTimeRange,
IScanRange {
    public C getChromatogram();

    public void reset();

    public void reset(boolean var1);

    @Override
    public int getStartRetentionTime();

    public void setStartRetentionTime(int var1);

    @Override
    public int getStopRetentionTime();

    public void setStopRetentionTime(int var1);

    public float getStartAbundance();

    public void setStartAbundance(float var1);

    public float getStopAbundance();

    public void setStopAbundance(float var1);

    public void setRanges(int var1, int var2, float var3, float var4);

    public void setRangeRetentionTime(int var1, int var2, boolean var3);

    public void setRangeRetentionTime(int var1, int var2);

    public void setRanges(int var1, int var2, float var3, float var4, boolean var5);

    public void fireUpdateChange(boolean var1);

    public IScan getSelectedScan();

    public void setSelectedScan(IScan var1);

    public void setSelectedScan(IScan var1, boolean var2);

    public P getSelectedPeak();

    public void setSelectedPeak(P var1);

    public void setSelectedPeak(P var1, boolean var2);

    public IScan getSelectedIdentifiedScan();

    public void removeSelectedIdentifiedScan();

    public void setSelectedIdentifiedScan(IScan var1);

    public boolean isOverlaySelected();

    public void setOverlaySelected(boolean var1);

    public boolean isLockOffset();

    public void setLockOffset(boolean var1);

    public Point getOffset();

    public void resetOffset();

    @Override
    default public int getStartScan() {
        int scanNumber = this.getChromatogram().getScanNumber(this.getStartRetentionTime());
        if (scanNumber > 0) {
            return scanNumber;
        }
        return -1;
    }

    @Override
    default public int getStopScan() {
        int scanNumber = this.getChromatogram().getScanNumber(this.getStopRetentionTime());
        if (scanNumber > 0) {
            return scanNumber;
        }
        return -1;
    }
}

