/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.chemclipse.model.comparator.PeakRetentionTimeComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.support.PeakQuantitation;
import org.eclipse.chemclipse.model.support.PeakQuantitations;
import org.eclipse.chemclipse.support.comparator.SortOrder;

public class PeakQuantitationsExtractor {
    private PeakRetentionTimeComparator chromatogramPeakRetentionTimeComparator = new PeakRetentionTimeComparator(SortOrder.ASC);

    public PeakQuantitations extract(List<? extends IPeak> peaks) {
        PeakQuantitations peakQuantitations = new PeakQuantitations();
        if (peaks != null) {
            peaks = new ArrayList<IPeak>(peaks);
            Collections.sort(peaks, this.chromatogramPeakRetentionTimeComparator);
            HashSet<String> quantitationColumns = new HashSet<String>();
            for (IPeak iPeak : peaks) {
                for (IQuantitationEntry quantitationEntry : iPeak.getQuantitationEntries()) {
                    quantitationColumns.add(this.getIdentifier(quantitationEntry.getName(), quantitationEntry.getConcentrationUnit()));
                }
            }
            peakQuantitations.getTitles().add("RT (Minutes)");
            peakQuantitations.getTitles().add("Area");
            for (String string : quantitationColumns) {
                peakQuantitations.getTitles().add(string);
            }
            for (IPeak iPeak : peaks) {
                PeakQuantitation peakQuantitationEntry = new PeakQuantitation();
                peakQuantitationEntry.setRetentionTime(iPeak.getPeakModel().getRetentionTimeAtPeakMaximum());
                peakQuantitationEntry.setIntegratedArea(iPeak.getIntegratedArea());
                for (String quantitationColumn : quantitationColumns) {
                    peakQuantitationEntry.getConcentrations().add(this.getConcentration(iPeak, quantitationColumn));
                }
                peakQuantitations.getQuantitationEntries().add(peakQuantitationEntry);
            }
        }
        return peakQuantitations;
    }

    private double getConcentration(IPeak peak, String quantitationColumn) {
        double concentration = 0.0;
        for (IQuantitationEntry quantitationEntry : peak.getQuantitationEntries()) {
            if (!quantitationColumn.equals(this.getIdentifier(quantitationEntry.getName(), quantitationEntry.getConcentrationUnit()))) continue;
            concentration = quantitationEntry.getConcentration();
            break;
        }
        return concentration;
    }

    private String getIdentifier(String name, String concentrationUnit) {
        return String.valueOf(name) + " [" + concentrationUnit + "]";
    }
}

