/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.classifier.supplier.molpeak.core;

import org.eclipse.chemclipse.chromatogram.msd.classifier.core.AbstractChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.IChromatogramClassifierResult;
import org.eclipse.chemclipse.chromatogram.msd.classifier.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.classifier.settings.IChromatogramClassifierSettings;
import org.eclipse.chemclipse.model.core.IMeasurementResult;
import org.eclipse.chemclipse.model.implementation.MeasurementResult;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.classifier.BasePeakClassifier;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.model.ILigninRatios;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.results.BasePeakClassifierResult;
import org.eclipse.chemclipse.msd.classifier.supplier.molpeak.settings.ClassifierSettings;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class Classifier
extends AbstractChromatogramClassifier {
    public Classifier() {
        super(new DataType[]{DataType.MSD});
    }

    public IProcessingInfo<IChromatogramClassifierResult> applyClassifier(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramClassifierSettings chromatogramClassifierSettings, IProgressMonitor monitor) {
        ClassifierSettings classifierSettings = chromatogramClassifierSettings instanceof ClassifierSettings ? (ClassifierSettings)chromatogramClassifierSettings : PreferenceSupplier.getChromatogramClassifierSettings();
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, (IChromatogramClassifierSettings)classifierSettings);
        if (!processingInfo.hasErrorMessages()) {
            ILigninRatios ligninRatios = BasePeakClassifier.calculateLigninRatios(chromatogramSelection);
            BasePeakClassifierResult chromatogramClassifierResult = new BasePeakClassifierResult(ResultStatus.OK, "The chromatogram has been classified.", ligninRatios);
            MeasurementResult measurementResult = new MeasurementResult("Base Peak Classifier", "org.eclipse.chemclipse.msd.classifier.supplier.basepeak", "This is ratio of lignins calculated by the base peak.", (Object)ligninRatios);
            chromatogramSelection.getChromatogram().addMeasurementResult((IMeasurementResult)measurementResult);
            processingInfo.setProcessingResult((Object)chromatogramClassifierResult);
        }
        return processingInfo;
    }
}

