/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.chromatogram;

import java.io.File;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.io.AMDISConverter;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.io.MassLibConverter;
import org.eclipse.chemclipse.converter.chromatogram.AbstractChromatogramConverter;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramConverter;
import org.eclipse.chemclipse.converter.model.SeparationColumnMapping;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.columns.SeparationColumnFactory;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.model.support.LibraryInformationSupport;
import org.eclipse.chemclipse.msd.converter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ChromatogramConverterMSD
extends AbstractChromatogramConverter<IChromatogramPeakMSD, IChromatogramMSD>
implements IChromatogramConverter<IChromatogramPeakMSD, IChromatogramMSD> {
    private static final Logger logger = Logger.getLogger(ChromatogramConverterMSD.class);
    private static IChromatogramConverter<IChromatogramPeakMSD, IChromatogramMSD> instance = null;

    public ChromatogramConverterMSD() {
        super("org.eclipse.chemclipse.msd.converter.chromatogramSupplier", IChromatogramMSD.class, DataCategory.MSD);
    }

    public static IChromatogramConverter<IChromatogramPeakMSD, IChromatogramMSD> getInstance() {
        if (instance == null) {
            instance = new ChromatogramConverterMSD();
        }
        return instance;
    }

    public void postProcessChromatogram(IProcessingInfo<IChromatogramMSD> processingInfo, IProgressMonitor monitor) {
        IChromatogramMSD chromatogramMSD;
        File file;
        File directory;
        if (processingInfo != null && processingInfo.getProcessingResult() instanceof IChromatogramMSD && (directory = this.getDirectory(file = (chromatogramMSD = (IChromatogramMSD)processingInfo.getProcessingResult()).getFile())) != null && directory.exists()) {
            this.parseCalibrationMassLib(chromatogramMSD, directory);
            this.parseTargetMassLib(chromatogramMSD, directory);
            this.parseCalibrationAMDIS(chromatogramMSD, directory);
            this.parseSeparationColumn(chromatogramMSD);
        }
    }

    private File getDirectory(File file) {
        File directory = null;
        if (file != null) {
            directory = file.isFile() ? file.getParentFile() : file;
        }
        return directory;
    }

    private File getFile(File directory, String fileName, String fileExtension) {
        if (directory.exists()) {
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                File file = fileArray[n2];
                if (file.isFile() && (name = file.getName().toLowerCase()).endsWith(fileExtension.toLowerCase()) && name.startsWith(fileName.toLowerCase())) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    private void parseCalibrationMassLib(IChromatogramMSD chromatogramMSD, File directory) {
        String fileName;
        File file;
        if (PreferenceSupplier.isParseRetentionIndexDataMassLib() && (file = this.getFile(directory, fileName = PreferenceSupplier.isUseChromatogramNameMassLib() ? chromatogramMSD.getName() : PreferenceSupplier.getDefaultNameMassLib(), ".inf")) != null) {
            MassLibConverter massLibConverter = new MassLibConverter();
            try {
                IProcessingInfo processingInfo = massLibConverter.parseRetentionIndices(file);
                ISeparationColumnIndices separationColumnIndices = (ISeparationColumnIndices)processingInfo.getProcessingResult();
                chromatogramMSD.getSeparationColumnIndices().putAll((Map)separationColumnIndices);
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
    }

    private void parseTargetMassLib(IChromatogramMSD chromatogramMSD, File directory) {
        String fileName;
        File file;
        if (PreferenceSupplier.isParseTargetDataMassLib() && (file = this.getFile(directory, fileName = PreferenceSupplier.isUseChromatogramNameMassLib() ? chromatogramMSD.getName() : PreferenceSupplier.getDefaultNameMassLib(), ".inf")) != null) {
            MassLibConverter massLibConverter = new MassLibConverter();
            LibraryInformationSupport libraryInformationSupport = new LibraryInformationSupport();
            String referenceIdentifierMarker = PreferenceSupplier.getReferenceIdentifierMarker();
            String referenceIdentifierPrefix = PreferenceSupplier.getReferenceIdentifierPrefix();
            try {
                IProcessingInfo processingInfo = massLibConverter.parseTargets(file);
                Map targets = (Map)processingInfo.getProcessingResult(Map.class);
                for (Map.Entry target : targets.entrySet()) {
                    IScan scan = chromatogramMSD.getScan(((Integer)target.getKey()).intValue());
                    if (scan == null || !(scan instanceof IScanMSD)) continue;
                    IScanMSD scanMSD = (IScanMSD)scan;
                    LibraryInformation libraryInformation = new LibraryInformation();
                    libraryInformationSupport.extractNameAndReferenceIdentifier((String)target.getValue(), (ILibraryInformation)libraryInformation, referenceIdentifierMarker, referenceIdentifierPrefix);
                    ComparisonResult comparisonResult = ComparisonResult.createBestMatchComparisonResult();
                    IdentificationTarget scanTargetMSD = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                    scanMSD.getTargets().add(scanTargetMSD);
                }
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
    }

    private void parseCalibrationAMDIS(IChromatogramMSD chromatogramMSD, File directory) {
        String fileName;
        File file;
        if (PreferenceSupplier.isParseRetentionIndexDataAMDIS() && (file = this.getFile(directory, fileName = PreferenceSupplier.isUseChromatogramNameAMDIS() ? chromatogramMSD.getName() : PreferenceSupplier.getDefaultNameAMDIS(), ".cal")) != null) {
            try {
                AMDISConverter amdisConverter = new AMDISConverter();
                IProcessingInfo processingInfo = amdisConverter.parseRetentionIndices(file);
                ISeparationColumnIndices separationColumnIndices = (ISeparationColumnIndices)processingInfo.getProcessingResult();
                chromatogramMSD.getSeparationColumnIndices().putAll((Map)separationColumnIndices);
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
    }

    private void parseSeparationColumn(IChromatogramMSD chromatogramMSD) {
        if (PreferenceSupplier.isParseSeparationColumnFromHeader()) {
            SeparationColumnMapping mapping = new SeparationColumnMapping();
            mapping.load(PreferenceSupplier.getSeparationColumnKeywords());
            String miscInfo = chromatogramMSD.getMiscInfo();
            for (Map.Entry column : mapping.entrySet()) {
                if (!miscInfo.contains((CharSequence)column.getKey())) continue;
                ISeparationColumn separationColumn = SeparationColumnFactory.getSeparationColumn((String)((String)column.getValue()));
                chromatogramMSD.getSeparationColumnIndices().setSeparationColumn(separationColumn);
            }
        }
    }
}

