/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.calibration;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.columns.SeparationColumnFactory;
import org.eclipse.chemclipse.msd.swt.ui.preferences.PreferencePage;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.swt.ui.preferences.PreferencePageSWT;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.IUpdateListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.RetentionIndexTableViewerUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.RetentionIndexUI;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExtendedRetentionIndexListUI
extends Composite {
    private Composite toolbarInfoTop;
    private RetentionIndexUI retentionIndexUI;
    private Composite toolbarInfoBottom;
    private Label labelInfoTop;
    private Label labelInfoBottom;
    private Button buttonAddLibrary;
    private Button buttonRemoveLibrary;
    private ComboViewer comboViewerSeparationColumn;
    private File retentionIndexFile;
    private ISeparationColumnIndices separationColumnIndices = null;

    public ExtendedRetentionIndexListUI(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void addRetentionIndexEntries(List<IRetentionIndexEntry> retentionIndexEntries) {
        this.retentionIndexUI.addRetentionIndexEntries(retentionIndexEntries);
    }

    public void setFile(File file) {
        this.retentionIndexFile = file;
        boolean enabled = file != null;
        this.buttonAddLibrary.setEnabled(enabled);
        this.buttonRemoveLibrary.setEnabled(enabled);
    }

    public void setInput(ISeparationColumnIndices separationColumnIndices) {
        this.separationColumnIndices = separationColumnIndices;
        this.retentionIndexUI.setInput(separationColumnIndices);
        ISeparationColumn separationColumn = null;
        if (this.separationColumnIndices != null) {
            separationColumn = separationColumnIndices.getSeparationColumn();
        }
        this.setSeparationColumnSelection(separationColumn);
        this.updateLabel();
    }

    public RetentionIndexTableViewerUI getRetentionIndexTableViewerUI() {
        return this.retentionIndexUI.getRetentionIndexTableViewerUI();
    }

    private void setSeparationColumnSelection(ISeparationColumn separationColumn) {
        if (separationColumn != null) {
            String name = separationColumn.getName();
            int index = -1;
            String[] stringArray = this.comboViewerSeparationColumn.getCombo().getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                ++index;
                if (item.equals(name)) break;
                ++n2;
            }
            if (index >= 0) {
                this.comboViewerSeparationColumn.getCombo().select(index);
            }
        } else {
            this.comboViewerSeparationColumn.getCombo().setItems(new String[0]);
        }
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createToolbarMain(composite);
        this.toolbarInfoTop = this.createToolbarInfoTop(composite);
        this.retentionIndexUI = this.createRetentionIndexUI(composite);
        this.toolbarInfoBottom = this.createToolbarInfoBottom(composite);
        this.comboViewerSeparationColumn.setInput((Object)SeparationColumnFactory.getSeparationColumns());
        this.buttonAddLibrary.setEnabled(false);
        this.buttonRemoveLibrary.setEnabled(false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoTop, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfoBottom, (boolean)true);
        this.retentionIndexUI.setSearchVisibility(false);
        this.retentionIndexUI.setEditVisibility(false);
        this.retentionIndexUI.enableTableEdit(false);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(Colors.WHITE);
        GridData gridDataStatus = new GridData(768);
        gridDataStatus.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridDataStatus);
        composite.setLayout((Layout)new GridLayout(8, false));
        this.createButtonToggleToolbarInfo(composite);
        this.comboViewerSeparationColumn = this.createComboViewerSeparationColumn(composite);
        this.createButtonToggleToolbarSearch(composite);
        this.createButtonToggleToolbarModify(composite);
        this.createButtonToggleToolbarEdit(composite);
        this.buttonAddLibrary = this.createButtonAddLibraryToProcess(composite);
        this.buttonRemoveLibrary = this.createButtonRemoveLibraryFromProcess(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartSupport.toggleCompositeVisibility((Composite)ExtendedRetentionIndexListUI.this.toolbarInfoTop);
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedRetentionIndexListUI.this.toolbarInfoBottom);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private ComboViewer createComboViewerSeparationColumn(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ISeparationColumn) {
                    ISeparationColumn separationColumn = (ISeparationColumn)element;
                    return separationColumn.getName();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a chromatogram column.");
        combo.setLayoutData((Object)new GridData(768));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof ISeparationColumn && ExtendedRetentionIndexListUI.this.separationColumnIndices != null) {
                    ISeparationColumn separationColumn = (ISeparationColumn)object;
                    ExtendedRetentionIndexListUI.this.separationColumnIndices.setSeparationColumn(separationColumn);
                    ExtendedRetentionIndexListUI.this.updateLabel();
                }
            }
        });
        return comboViewer;
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = ExtendedRetentionIndexListUI.this.retentionIndexUI.toggleSearchVisibility();
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarModify(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle modify toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = ExtendedRetentionIndexListUI.this.retentionIndexUI.toggleEditVisibility();
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarEdit(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editEntryDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedRetentionIndexListUI.this.retentionIndexUI.toggleTableEdit();
                button.setImage(ApplicationImageFactory.getInstance().getImage(ExtendedRetentionIndexListUI.this.retentionIndexUI.isEnabled() ? "org.eclipse.chemclipse.rcp.ui.icons/editEntryActive.gif" : "org.eclipse.chemclipse.rcp.ui.icons/edit_entry.gif", "16x16"));
                ExtendedRetentionIndexListUI.this.updateLabel();
            }
        });
        return button;
    }

    private Button createButtonAddLibraryToProcess(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Add the library to the list of searched databases.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
                eventBroker.post("ri/library/add/process", (Object)ExtendedRetentionIndexListUI.this.retentionIndexFile);
                MessageDialog.openConfirm((Shell)e.display.getActiveShell(), (String)"RI Calculator", (String)"The RI library has been added.");
            }
        });
        return button;
    }

    private Button createButtonRemoveLibraryFromProcess(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Remove the library from the list of searched databases.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/remove.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
                eventBroker.post("ri/library/remove/process", (Object)ExtendedRetentionIndexListUI.this.retentionIndexFile);
                MessageDialog.openConfirm((Shell)e.display.getActiveShell(), (String)"RI Calculator", (String)"The RI library has been removed.");
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageSWT preferencePageSWT = new PreferencePageSWT();
                preferencePageSWT.setTitle("Settings (SWT)");
                PreferencePage preferencePageMSD = new PreferencePage();
                preferencePageMSD.setTitle("Settings (MSD)");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePageSWT));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)preferencePageMSD));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedRetentionIndexListUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarInfoTop(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(Colors.WHITE);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfoTop = new Label(composite, 0);
        this.labelInfoTop.setBackground(Colors.WHITE);
        this.labelInfoTop.setText("");
        this.labelInfoTop.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private RetentionIndexUI createRetentionIndexUI(Composite parent) {
        RetentionIndexUI retentionIndexUI = new RetentionIndexUI(parent, 0);
        retentionIndexUI.setLayoutData(new GridData(1808));
        retentionIndexUI.setUpdateListener(new IUpdateListener(){

            @Override
            public void update() {
                ExtendedRetentionIndexListUI.this.updateLabel();
            }
        });
        return retentionIndexUI;
    }

    private Composite createToolbarInfoBottom(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(Colors.WHITE);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelInfoBottom = new Label(composite, 0);
        this.labelInfoBottom.setBackground(Colors.WHITE);
        this.labelInfoBottom.setText("");
        this.labelInfoBottom.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private void updateLabel() {
        Object object = this.comboViewerSeparationColumn.getStructuredSelection().getFirstElement();
        StringBuilder builder = new StringBuilder();
        if (object instanceof ISeparationColumn) {
            ISeparationColumn separationColumn = (ISeparationColumn)object;
            builder.append(separationColumn.getName());
            builder.append(" ");
            builder.append(separationColumn.getLength());
            builder.append(" ");
            builder.append(separationColumn.getDiameter());
            builder.append(" ");
            builder.append(separationColumn.getPhase());
        }
        RetentionIndexTableViewerUI tableViewer = this.getRetentionIndexTableViewerUI();
        this.labelInfoTop.setText("Separation Column: " + builder.toString());
        String editInformation = this.getRetentionIndexTableViewerUI().isEditEnabled() ? "Edit is enabled." : "Edit is disabled.";
        this.labelInfoBottom.setText("Retention Indices: " + tableViewer.getTable().getItemCount() + " [" + this.retentionIndexUI.getSearchText() + "] - " + editInformation);
    }

    private void applySettings() {
    }
}

