/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.fieldeditors;

import java.io.File;
import java.util.HashSet;
import org.eclipse.chemclipse.model.ranges.TimeRange;
import org.eclipse.chemclipse.model.ranges.TimeRanges;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.TimeRangeInputValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.TimeRangesListUI;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TimeRangesFieldEditor
extends FieldEditor {
    private static final int NUMBER_COLUMNS = 2;
    private static final String FILTER_EXTENSION = "*.txt";
    private static final String FILTER_NAME = "Time Ranges (*.txt)";
    private static final String FILE_NAME = "TimeRanges.txt";
    private Composite composite;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private TimeRanges timeRanges = new TimeRanges();
    private TimeRangesListUI timeRangesListUI;

    public TimeRangesFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.composite.setLayoutData((Object)gridData);
        this.createLabelSection(this.composite);
        this.createSearchSection(this.composite);
        this.createTableSection(this.composite);
        this.createButtonGroup(this.composite);
    }

    private void createSearchSection(Composite parent) {
        SearchSupportUI searchSupportUI = new SearchSupportUI(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        searchSupportUI.setLayoutData((Object)gridData);
        searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                TimeRangesFieldEditor.this.timeRangesListUI.setSearchText(searchText, caseSensitive);
            }
        });
    }

    private void createLabelSection(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText("");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createTableSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        this.timeRangesListUI = new TimeRangesListUI(composite, 68354);
        this.setTableViewerInput();
    }

    private void createButtonGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.setButtonLayoutData(this.createButtonAdd(composite));
        this.setButtonLayoutData(this.createButtonEdit(composite));
        this.setButtonLayoutData(this.createButtonRemove(composite));
        this.setButtonLayoutData(this.createButtonRemoveAll(composite));
        this.setButtonLayoutData(this.createButtonImport(composite));
        this.setButtonLayoutData(this.createButtonExport(composite));
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Add");
        button.setToolTipText("Add a time range.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(e.display.getActiveShell(), "Time Range", "Create a new time range.", "C10 | 10.2 | 10.4 | 10.6", (IInputValidator)new TimeRangeInputValidator(TimeRangesFieldEditor.this.timeRanges.keySet()));
                if (dialog.open() == 0) {
                    String item = dialog.getValue();
                    TimeRange timeRange = TimeRangesFieldEditor.this.timeRanges.extractTimeRange(item);
                    if (timeRange != null) {
                        TimeRangesFieldEditor.this.timeRanges.add(timeRange);
                        TimeRangesFieldEditor.this.setTableViewerInput();
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonEdit(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Edit");
        button.setToolTipText("Edit the selected time range.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = (IStructuredSelection)TimeRangesFieldEditor.this.timeRangesListUI.getSelection();
                Object object = structuredSelection.getFirstElement();
                if (object instanceof TimeRange) {
                    HashSet<String> keySetEdit = new HashSet<String>();
                    keySetEdit.addAll(TimeRangesFieldEditor.this.timeRanges.keySet());
                    TimeRange timeRange = (TimeRange)object;
                    keySetEdit.remove(timeRange.getIdentifier());
                    InputDialog dialog = new InputDialog(e.display.getActiveShell(), "Time Range", "Edit the selected time range.", TimeRangesFieldEditor.this.timeRanges.extractTimeRange(timeRange), (IInputValidator)new TimeRangeInputValidator(keySetEdit));
                    if (dialog.open() == 0) {
                        String item = dialog.getValue();
                        TimeRange timeRangeNew = TimeRangesFieldEditor.this.timeRanges.extractTimeRange(item);
                        if (timeRangeNew != null) {
                            TimeRangesFieldEditor.this.timeRanges.remove(timeRange);
                            TimeRangesFieldEditor.this.timeRanges.add(timeRangeNew);
                            TimeRangesFieldEditor.this.setTableViewerInput();
                        }
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonRemove(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove");
        button.setToolTipText("Remove the selected time range(s).");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Time Range(s)", (String)"Do you want to delete the selected time range(s)?")) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)TimeRangesFieldEditor.this.timeRangesListUI.getSelection();
                    Object[] objectArray = structuredSelection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof TimeRange) {
                            TimeRangesFieldEditor.this.timeRanges.remove(((TimeRange)object).getIdentifier());
                        }
                        ++n2;
                    }
                    TimeRangesFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonRemoveAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove All");
        button.setToolTipText("Remove all time ranges(s).");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Time Range(s)", (String)"Do you want to delete all time range(s)?")) {
                    TimeRangesFieldEditor.this.timeRanges.clear();
                    TimeRangesFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonImport(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Import");
        button.setToolTipText("Import a time range list.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 8);
                fileDialog.setText("Time Range List");
                fileDialog.setFilterExtensions(new String[]{TimeRangesFieldEditor.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{TimeRangesFieldEditor.FILTER_NAME});
                fileDialog.setFilterPath(TimeRangesFieldEditor.this.preferenceStore.getString("timeRangeTemplateFolder"));
                String pathname = fileDialog.open();
                if (pathname != null) {
                    File file = new File(pathname);
                    String path = file.getParentFile().getAbsolutePath();
                    TimeRangesFieldEditor.this.preferenceStore.putValue("timeRangeTemplateFolder", path);
                    TimeRangesFieldEditor.this.timeRanges.importItems(file);
                    TimeRangesFieldEditor.this.setTableViewerInput();
                }
            }
        });
        return button;
    }

    private Button createButtonExport(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setText("Export");
        button.setToolTipText("Export the time range list.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.widget.getDisplay().getActiveShell(), 8192);
                fileDialog.setOverwrite(true);
                fileDialog.setText("Time Range List");
                fileDialog.setFilterExtensions(new String[]{TimeRangesFieldEditor.FILTER_EXTENSION});
                fileDialog.setFilterNames(new String[]{TimeRangesFieldEditor.FILTER_NAME});
                fileDialog.setFileName(TimeRangesFieldEditor.FILE_NAME);
                fileDialog.setFilterPath(TimeRangesFieldEditor.this.preferenceStore.getString("timeRangeTemplateFolder"));
                String pathname = fileDialog.open();
                if (pathname != null) {
                    File file = new File(pathname);
                    String path = file.getParentFile().getAbsolutePath();
                    TimeRangesFieldEditor.this.preferenceStore.putValue("timeRangeTemplateFolder", path);
                    if (TimeRangesFieldEditor.this.timeRanges.exportItems(file)) {
                        MessageDialog.openInformation((Shell)button.getShell(), (String)"Time Range List", (String)"The time range list has been exported successfully.");
                    } else {
                        MessageDialog.openWarning((Shell)button.getShell(), (String)"Time Range List", (String)"Something went wrong to export the time range list.");
                    }
                }
            }
        });
        return button;
    }

    private void setTableViewerInput() {
        this.timeRangesListUI.setInput(this.timeRanges.values());
    }

    protected void doLoad() {
        String entries = this.getPreferenceStore().getString(this.getPreferenceName());
        this.timeRanges.load(entries);
        this.setTableViewerInput();
    }

    protected void doLoadDefault() {
        String entries = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.timeRanges.loadDefault(entries);
        this.setTableViewerInput();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.timeRanges.save());
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns >= 2) {
            GridData gridData = (GridData)this.composite.getLayoutData();
            gridData.horizontalSpan = numColumns - 1;
            gridData.grabExcessHorizontalSpace = true;
        }
    }
}

