/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.util.Collection;
import java.util.Set;
import org.eclipse.chemclipse.model.core.AbstractPeak;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.ClassifierCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class PeakScanListEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private final ExtendedTableViewer tableViewer;
    private final String column;

    public PeakScanListEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = "Classifier".equals(column) ? new ClassifierCellEditor((TableViewer)tableViewer) : ("Active for Analysis".equals(column) ? new CheckboxCellEditor((Composite)tableViewer.getTable()) : new TextCellEditor((Composite)tableViewer.getTable()));
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        if (this.column == "Active for Analysis") {
            return element instanceof IPeak;
        }
        if ("Name".equals(this.column)) {
            return element instanceof AbstractPeak && this.tableViewer.isEditEnabled();
        }
        return this.tableViewer.isEditEnabled();
    }

    protected Object getValue(Object element) {
        block14: {
            if (!(element instanceof IPeak)) break block14;
            IPeak peak = (IPeak)element;
            switch (this.column) {
                case "Active for Analysis": {
                    return peak.isActiveForAnalysis();
                }
                case "Classifier": {
                    return peak;
                }
                case "Name": {
                    String name = peak.getName();
                    if (name == null) {
                        return "";
                    }
                    return name;
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block17: {
            if (!(element instanceof IPeak)) break block17;
            IPeak peak = (IPeak)element;
            switch (this.column) {
                case "Active for Analysis": {
                    peak.setActiveForAnalysis(((Boolean)value).booleanValue());
                    break;
                }
                case "Name": {
                    if (!(peak instanceof AbstractPeak)) break;
                    AbstractPeak abstractPeak = (AbstractPeak)peak;
                    String name = (String)value;
                    if (name != null && name.equals(abstractPeak.getName())) {
                        return;
                    }
                    abstractPeak.setName(name);
                    break;
                }
                case "Classifier": {
                    if (!(value instanceof Set)) break;
                    Set set = (Set)value;
                    Collection classifier = peak.getClassifier();
                    String[] stringArray = classifier.toArray(new String[0]);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String oldCLassifier = stringArray[n2];
                        if (!set.contains(oldCLassifier)) {
                            peak.removeClassifier(oldCLassifier);
                        }
                        ++n2;
                    }
                    for (Object object : set) {
                        if (classifier.contains(object)) continue;
                        peak.addClassifier(object.toString());
                    }
                    break;
                }
            }
            this.tableViewer.refresh(element);
        }
    }
}

