/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.quantitation.IResponseSignal;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class QuantResponseLabelProvider
extends AbstractChemClipseLabelProvider {
    public static final String SIGNAL = "Signal";
    public static final String CONCENTRATION = "Concentration";
    public static final String RESPONSE = "Response";
    public static final String[] TITLES = new String[]{"Signal", "Concentration", "Response"};
    public static final int[] BOUNDS = new int[]{100, 100, 100};

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IResponseSignal) {
            IResponseSignal entry = (IResponseSignal)element;
            switch (columnIndex) {
                case 0: {
                    double signal = entry.getSignal();
                    if (signal == 0.0) {
                        text = "TIC";
                        break;
                    }
                    text = decimalFormat.format(signal);
                    break;
                }
                case 1: {
                    text = decimalFormat.format(entry.getConcentration());
                    break;
                }
                case 2: {
                    text = decimalFormat.format(entry.getResponse());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/quantifySelectedPeak.gif", "16x16");
    }
}

