/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ScanLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    public static final String NO_VALUE = "n.a.";
    public static final String INTENSITY = Activator.getDefault().getPreferenceStore().getString("titleYAxisIntensity");
    public static final String RELATIVE_INTENSITY = Activator.getDefault().getPreferenceStore().getString("titleYAxisRelativeIntensity");
    public static final String ION = Activator.getDefault().getPreferenceStore().getString("titleXAxisMZ");
    public static final String WAVELENGTH = Activator.getDefault().getPreferenceStore().getString("titleXAxisWavelength");
    public static final String MINUTES = Activator.getDefault().getPreferenceStore().getString("titleXAxisMinutes");
    public static final String PARENT_ION = Activator.getDefault().getPreferenceStore().getString("titleXAxisParentMZ");
    public static final String PARENT_RESOLUTION = Activator.getDefault().getPreferenceStore().getString("titleXAxisParentResolution");
    public static final String DAUGHTER_ION = Activator.getDefault().getPreferenceStore().getString("titleXAxisDaughterMZ");
    public static final String DAUGHTER_RESOLUTION = Activator.getDefault().getPreferenceStore().getString("titleXAxisDaughterResolution");
    public static final String COLLISION_ENERGY = Activator.getDefault().getPreferenceStore().getString("titleXAxisCollisionEnergy");
    public static final String[] TITLES_MSD_NOMINAL = new String[]{ION, INTENSITY, RELATIVE_INTENSITY};
    public static final int[] BOUNDS_MSD_NOMINAL = new int[]{150, 150, 150};
    public static final String[] TITLES_MSD_TANDEM = new String[]{ION, INTENSITY, RELATIVE_INTENSITY, PARENT_ION, PARENT_RESOLUTION, DAUGHTER_ION, DAUGHTER_RESOLUTION, COLLISION_ENERGY};
    public static final int[] BOUNDS_MSD_TANDEM = new int[]{100, 100, 100, 120, 120, 120, 120, 120};
    public static final String[] TITLES_MSD_HIGHRES = new String[]{ION, INTENSITY, RELATIVE_INTENSITY};
    public static final int[] BOUNDS_MSD_HIGHRES = new int[]{150, 150, 150};
    public static final String[] TITLES_CSD = new String[]{MINUTES, INTENSITY, RELATIVE_INTENSITY};
    public static final int[] BOUNDS_CSD = new int[]{150, 150, 150};
    public static final String[] TITLES_WSD = new String[]{WAVELENGTH, INTENSITY, RELATIVE_INTENSITY};
    public static final int[] BOUNDS_WSD = new int[]{150, 150, 150};
    public static final String[] TITLES_EMPTY = new String[]{"n.a."};
    public static final int[] BOUNDS_EMPTY = new int[]{150};
    private DataType dataType;
    private DecimalFormat dfNominalMSD;
    private DecimalFormat dfTandemMSD;
    private DecimalFormat dfHighResMSD;
    private DecimalFormat dfCSD;
    private DecimalFormat dfWSD;
    private DecimalFormat dfIntensity;
    private DecimalFormat dfRelativeIntensity;
    private double relativeIntensityFactor = 0.0;

    public ScanLabelProvider(DataType dataType) {
        this.dataType = dataType;
        this.dfNominalMSD = ValueFormat.getDecimalFormatEnglish((String)"0.0");
        this.dfTandemMSD = ValueFormat.getDecimalFormatEnglish((String)"0.0");
        this.dfHighResMSD = ValueFormat.getDecimalFormatEnglish((String)"0.000###");
        this.dfCSD = ValueFormat.getDecimalFormatEnglish((String)"0.0000");
        this.dfWSD = ValueFormat.getDecimalFormatEnglish((String)"0.0");
        this.dfIntensity = ValueFormat.getDecimalFormatEnglish((String)"0.0###");
        this.dfRelativeIntensity = ValueFormat.getDecimalFormatEnglish((String)"0.0000");
    }

    public void setTotalIntensity(float totalIntensity) {
        this.relativeIntensityFactor = totalIntensity != 0.0f ? 100.0 / (double)totalIntensity : 0.0;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/ion.gif", "16x16");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        switch (this.dataType) {
            case MSD_NOMINAL: {
                text = this.getNominalMSD(element, columnIndex);
                break;
            }
            case MSD_TANDEM: {
                text = this.getTandemMSD(element, columnIndex);
                break;
            }
            case MSD_HIGHRES: {
                text = this.getHighResolutionMSD(element, columnIndex);
                break;
            }
            case CSD: {
                text = this.getCSD(element, columnIndex);
                break;
            }
            case WSD: {
                text = this.getWSD(element, columnIndex);
                break;
            }
            default: {
                text = NO_VALUE;
            }
        }
        return text;
    }

    private String getNominalMSD(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IIon) {
            IIon ion = (IIon)element;
            switch (columnIndex) {
                case 0: {
                    text = this.dfNominalMSD.format(ion.getIon());
                    break;
                }
                case 1: {
                    text = this.dfIntensity.format(ion.getAbundance());
                    break;
                }
                case 2: {
                    text = this.dfRelativeIntensity.format(this.relativeIntensityFactor * (double)ion.getAbundance());
                    break;
                }
                default: {
                    text = NO_VALUE;
                }
            }
        }
        return text;
    }

    private String getTandemMSD(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IIon) {
            IIon ion = (IIon)element;
            IIonTransition ionTransition = ion.getIonTransition();
            switch (columnIndex) {
                case 0: {
                    String mz = this.dfTandemMSD.format(ion.getIon());
                    text = ionTransition == null ? mz : String.valueOf(Integer.toString((int)ionTransition.getQ1StartIon())) + " > " + mz;
                    break;
                }
                case 1: {
                    text = this.dfIntensity.format(ion.getAbundance());
                    break;
                }
                case 2: {
                    text = this.dfRelativeIntensity.format(this.relativeIntensityFactor * (double)ion.getAbundance());
                    break;
                }
                case 3: {
                    text = ionTransition == null ? "" : this.dfTandemMSD.format(ionTransition.getQ1Ion());
                    break;
                }
                case 4: {
                    text = ionTransition == null ? "" : this.dfTandemMSD.format(ionTransition.getQ1Resolution());
                    break;
                }
                case 5: {
                    text = ionTransition == null ? "" : this.dfTandemMSD.format(ionTransition.getQ3Ion());
                    break;
                }
                case 6: {
                    text = ionTransition == null ? "" : this.dfTandemMSD.format(ionTransition.getQ3Resolution());
                    break;
                }
                case 7: {
                    text = ionTransition == null ? "" : this.dfTandemMSD.format(ionTransition.getCollisionEnergy());
                    break;
                }
                default: {
                    text = NO_VALUE;
                }
            }
        }
        return text;
    }

    private String getHighResolutionMSD(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IIon) {
            IIon ion = (IIon)element;
            switch (columnIndex) {
                case 0: {
                    text = this.dfHighResMSD.format(ion.getIon());
                    break;
                }
                case 1: {
                    text = this.dfIntensity.format(ion.getAbundance());
                    break;
                }
                case 2: {
                    text = this.dfRelativeIntensity.format(this.relativeIntensityFactor * (double)ion.getAbundance());
                    break;
                }
                default: {
                    text = NO_VALUE;
                }
            }
        }
        return text;
    }

    private String getCSD(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IScanCSD) {
            IScanCSD scanCSD = (IScanCSD)element;
            switch (columnIndex) {
                case 0: {
                    text = this.dfCSD.format((double)scanCSD.getRetentionTime() / 60000.0);
                    break;
                }
                case 1: {
                    text = this.dfIntensity.format(scanCSD.getTotalSignal());
                    break;
                }
                case 2: {
                    text = this.dfRelativeIntensity.format(this.relativeIntensityFactor * (double)scanCSD.getTotalSignal());
                    break;
                }
                default: {
                    text = NO_VALUE;
                }
            }
        }
        return text;
    }

    private String getWSD(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IScanSignalWSD) {
            IScanSignalWSD scanSignal = (IScanSignalWSD)element;
            switch (columnIndex) {
                case 0: {
                    text = this.dfWSD.format(scanSignal.getWavelength());
                    break;
                }
                case 1: {
                    text = this.dfIntensity.format(scanSignal.getAbundance());
                    break;
                }
                case 2: {
                    text = this.dfRelativeIntensity.format(this.relativeIntensityFactor * (double)scanSignal.getAbundance());
                    break;
                }
                default: {
                    text = NO_VALUE;
                }
            }
        }
        return text;
    }
}

