/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.identifier.ITargetTemplate;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TargetTemplateFilter
extends ViewerFilter {
    private String searchText;
    private boolean caseSensitive;

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = searchText;
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (element instanceof ITargetTemplate) {
            ITargetTemplate targetTemplate = (ITargetTemplate)element;
            String name = targetTemplate.getName();
            String casNumber = targetTemplate.getCasNumber();
            String comment = targetTemplate.getComments();
            String contributor = targetTemplate.getContributor();
            String referenceId = targetTemplate.getReferenceId();
            if (!this.caseSensitive) {
                this.searchText = this.searchText.toLowerCase();
                name = name.toLowerCase();
                casNumber = casNumber.toLowerCase();
                comment = comment.toLowerCase();
                contributor = contributor.toLowerCase();
                referenceId = referenceId.toLowerCase();
            }
            if (name.contains(this.searchText)) {
                return true;
            }
            if (casNumber.contains(this.searchText)) {
                return true;
            }
            if (comment.contains(this.searchText)) {
                return true;
            }
            if (contributor.contains(this.searchText)) {
                return true;
            }
            if (referenceId.contains(this.searchText)) {
                return true;
            }
        }
        return false;
    }
}

