/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.ranges.TimeRange;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class TimeRangesEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private ExtendedTableViewer tableViewer;
    private String column;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");

    public TimeRangesEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.tableViewer.isEditEnabled();
    }

    protected Object getValue(Object element) {
        block13: {
            if (!(element instanceof TimeRange)) break block13;
            TimeRange timeRange = (TimeRange)element;
            switch (this.column) {
                case "Start Time [min]": {
                    return this.formatValue(timeRange.getStart());
                }
                case "Center Time [min]": {
                    return this.formatValue(timeRange.getCenter());
                }
                case "Stop Time [min]": {
                    return this.formatValue(timeRange.getStop());
                }
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        block13: {
            if (!(element instanceof TimeRange)) break block13;
            TimeRange timeRange = (TimeRange)element;
            switch (this.column) {
                case "Start Time [min]": {
                    timeRange.updateStart(this.parseValue(value));
                    break;
                }
                case "Center Time [min]": {
                    timeRange.updateCenter(this.parseValue(value));
                    break;
                }
                case "Stop Time [min]": {
                    timeRange.updateStop(this.parseValue(value));
                }
            }
            this.tableViewer.refresh();
        }
    }

    private String formatValue(int retentionTime) {
        return this.decimalFormat.format((float)retentionTime / 60000.0f);
    }

    private int parseValue(Object value) {
        try {
            double retentionTimeMinutes = Double.parseDouble(value.toString());
            return (int)(retentionTimeMinutes * 60000.0);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

