/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramImportRunnable.class);
    private File file;
    private DataType dataType;
    private IChromatogramSelection<?, ?> chromatogramSelection;

    public ChromatogramImportRunnable(File file, DataType dataType) {
        this.file = file;
        this.dataType = dataType;
    }

    public IChromatogramSelection getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Chromatogram", -1);
                boolean fireUpdate = false;
                switch (this.dataType) {
                    case MSD_NOMINAL: 
                    case MSD_TANDEM: 
                    case MSD_HIGHRES: 
                    case MSD: {
                        IProcessingInfo processingInfoMSD = ChromatogramConverterMSD.getInstance().convert(this.file, monitor);
                        IChromatogramMSD chromatogramMSD = (IChromatogramMSD)processingInfoMSD.getProcessingResult();
                        this.chromatogramSelection = new ChromatogramSelectionMSD(chromatogramMSD, fireUpdate);
                        break;
                    }
                    case CSD: {
                        IProcessingInfo processingInfoCSD = ChromatogramConverterCSD.getInstance().convert(this.file, monitor);
                        IChromatogramCSD chromatogramCSD = (IChromatogramCSD)processingInfoCSD.getProcessingResult();
                        this.chromatogramSelection = new ChromatogramSelectionCSD(chromatogramCSD, fireUpdate);
                        break;
                    }
                    case WSD: {
                        IProcessingInfo processingInfoWSD = ChromatogramConverterWSD.getInstance().convert(this.file, monitor);
                        IChromatogramWSD chromatogramWSD = (IChromatogramWSD)processingInfoWSD.getProcessingResult();
                        this.chromatogramSelection = new ChromatogramSelectionWSD(chromatogramWSD, fireUpdate);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

