/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.methods;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.chemclipse.model.methods.ProcessEntry;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.xxd.process.comparators.NameComparator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProcessingWizardPage
extends WizardPage {
    private ComboViewer comboViewerCategory;
    private ComboViewer comboViewerProcessor;
    private final Map<ProcessSupplierContext, String> processSupplierContextMap;
    private final Set<DataCategory> selectedDataTypes = new HashSet<DataCategory>();
    private final List<Button> dataTypeSelections = new ArrayList<Button>();
    private ProcessEntry processEntry;
    private ProcessSupplierContext processContext;
    private final DataCategory[] dataCategories;

    protected ProcessingWizardPage(Map<ProcessSupplierContext, String> contexts, DataCategory[] dataCategories) {
        super("ProcessingWizardPage");
        this.processSupplierContextMap = contexts;
        this.dataCategories = dataCategories;
        this.processContext = contexts.entrySet().iterator().next().getKey();
        this.setTitle("Process Entry");
        this.setDescription("Select a chromatogram filter, integrator, identifier ... .");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        if (this.dataCategories.length > 1) {
            this.createLabel(composite, "Select the desired data types");
            DataCategory[] dataCategoryArray = this.dataCategories;
            int n = this.dataCategories.length;
            int n2 = 0;
            while (n2 < n) {
                DataCategory dataType = dataCategoryArray[n2];
                Button button = ProcessingWizardPage.createDataTypeCheckbox(composite, dataType);
                this.dataTypeSelections.add(button);
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ProcessingWizardPage.this.updateComboCategoryItems();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                ++n2;
            }
        }
        if (this.processSupplierContextMap.size() > 1) {
            this.createLabel(composite, "Context");
            this.createComboContext(composite);
        }
        this.createLabel(composite, "Category");
        this.comboViewerCategory = this.createComboCategory(composite);
        this.createLabel(composite, "Processor");
        this.comboViewerProcessor = this.createComboProcessor(composite);
        this.updateComboCategoryItems();
        this.setControl((Control)composite);
        this.validate();
    }

    private void createComboContext(Composite parent) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.getControl().setLayoutData((Object)new GridData(768));
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)ProcessingWizardPage.this.processSupplierContextMap.get(element);
            }
        });
        comboViewer.setInput(this.processSupplierContextMap.keySet());
        comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getProcessSupplierContext()));
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProcessingWizardPage.this.processContext = (ProcessSupplierContext)comboViewer.getStructuredSelection().getFirstElement();
                ProcessingWizardPage.this.updateComboCategoryItems();
            }
        });
    }

    private static Button createDataTypeCheckbox(final Composite parent, DataCategory dataType) {
        final Button button = new Button(parent, 32);
        button.setData((Object)dataType);
        button.setText(dataType.getLabel());
        button.setToolTipText("Select the " + dataType.name() + " processor items");
        button.setSelection(true);
        final Color enabledColor = button.getForeground();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = button.getSelection();
                if (selection) {
                    button.setForeground(enabledColor);
                } else {
                    button.setForeground(parent.getDisplay().getSystemColor(16));
                }
            }
        });
        if (!button.getSelection()) {
            button.setForeground(parent.getDisplay().getSystemColor(16));
        }
        return button;
    }

    public IProcessEntry getProcessEntry() {
        return this.processEntry;
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    private void updateComboCategoryItems() {
        if (this.dataTypeSelections == null) {
            return;
        }
        this.selectedDataTypes.clear();
        if (this.dataCategories.length == 1) {
            this.selectedDataTypes.add(this.dataCategories[0]);
        } else {
            for (Button button : this.dataTypeSelections) {
                button.setEnabled(true);
                if (!button.getSelection()) continue;
                this.selectedDataTypes.add((DataCategory)button.getData());
            }
        }
        final LinkedHashSet processTypeSuppliers = new LinkedHashSet();
        this.getProcessSupplierContext().visitSupplier(new Consumer<IProcessSupplier<?>>(){

            @Override
            public void accept(IProcessSupplier<?> supplier) {
                for (DataCategory category : supplier.getSupportedDataTypes()) {
                    if (!ProcessingWizardPage.this.selectedDataTypes.contains(category)) continue;
                    processTypeSuppliers.add(supplier);
                    return;
                }
            }
        });
        TreeMap<String, ProcessCategory> categories = new TreeMap<String, ProcessCategory>();
        for (IProcessSupplier supplier : processTypeSuppliers) {
            String category = supplier.getCategory();
            ProcessCategory processCategory = (ProcessCategory)categories.get(category);
            if (processCategory == null) {
                processCategory = new ProcessCategory(category);
                categories.put(category, processCategory);
            }
            processCategory.addSupplier(supplier, this.selectedDataTypes);
        }
        Object[] objects = categories.values().toArray();
        this.comboViewerCategory.setInput((Object)objects);
        if (objects.length == 1) {
            this.comboViewerCategory.setSelection((ISelection)new StructuredSelection(objects[0]));
        }
        this.comboViewerCategory.getControl().setEnabled(objects.length > 1);
        this.updateCategory();
    }

    private ComboViewer createComboCategory(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProcessCategory) {
                    return ((ProcessCategory)element).name;
                }
                return "-";
            }
        });
        combo.setToolTipText("Select a process category.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingWizardPage.this.updateCategory();
            }
        });
        return comboViewer;
    }

    private void updateCategory() {
        Object object = this.comboViewerCategory.getStructuredSelection().getFirstElement();
        if (object instanceof ProcessCategory) {
            ProcessCategory category = (ProcessCategory)object;
            List<IProcessSupplier<?>> suppliers = category.processorSuppliers;
            this.comboViewerProcessor.setInput(suppliers);
            if (suppliers.size() == 1) {
                this.comboViewerProcessor.setSelection((ISelection)new StructuredSelection(suppliers.get(0)));
            }
            this.comboViewerProcessor.getCombo().setEnabled(suppliers.size() > 1);
        } else {
            this.comboViewerProcessor.setInput((Object)new Object[0]);
        }
        this.validate();
    }

    private ComboViewer createComboProcessor(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IProcessSupplier) {
                    IProcessSupplier supplier = (IProcessSupplier)element;
                    StringBuilder sb = new StringBuilder();
                    sb.append(supplier.getName());
                    if (ProcessingWizardPage.this.selectedDataTypes.size() > 1 && !supplier.getSupportedDataTypes().containsAll(ProcessingWizardPage.this.selectedDataTypes)) {
                        sb.append(" ");
                        sb.append(Arrays.toString(supplier.getSupportedDataTypes().toArray()));
                    }
                    return sb.toString();
                }
                return "-";
            }
        });
        combo.setToolTipText("Select a processor.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingWizardPage.this.validate();
            }
        });
        return comboViewer;
    }

    private void updateEntry() {
        Object object = this.comboViewerProcessor.getStructuredSelection().getFirstElement();
        if (object instanceof IProcessSupplier) {
            IProcessSupplier processorSupplier = (IProcessSupplier)object;
            this.processEntry = new ProcessEntry(null);
            this.processEntry.setProcessorId(processorSupplier.getId());
            this.processEntry.setName(processorSupplier.getName());
            this.processEntry.setDescription(processorSupplier.getDescription());
            processorSupplier.getSupportedDataTypes().forEach(arg_0 -> ((ProcessEntry)this.processEntry).addDataCategory(arg_0));
            this.setMessage(processorSupplier.getDescription());
        } else {
            this.processEntry = null;
        }
    }

    private void validate() {
        if (!this.dataTypeSelections.isEmpty()) {
            int selected = 0;
            for (Button button : this.dataTypeSelections) {
                if (!button.getSelection()) continue;
                ++selected;
            }
            if (selected < 1) {
                this.setPageComplete(false);
                this.setErrorMessage("Please select at least one data type");
                return;
            }
        }
        if (this.comboViewerCategory.getSelection().isEmpty()) {
            this.setPageComplete(false);
            this.setErrorMessage("Please select a category");
            return;
        }
        if (this.comboViewerProcessor.getSelection().isEmpty()) {
            this.setPageComplete(false);
            this.setErrorMessage("Please select a processor");
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
        this.updateEntry();
    }

    public ProcessSupplierContext getProcessSupplierContext() {
        return this.processContext;
    }

    private static final class ProcessCategory {
        private static final NameComparator COMPARATOR = new NameComparator();
        private final String name;
        List<IProcessSupplier<?>> processorSuppliers = new ArrayList();

        public ProcessCategory(String name) {
            this.name = name;
        }

        public void addSupplier(IProcessSupplier<?> supplier, Set<DataCategory> selectedDataTypes) {
            for (DataCategory dataType : selectedDataTypes) {
                if (!supplier.getSupportedDataTypes().contains(dataType)) continue;
                this.processorSuppliers.add(supplier);
                Collections.sort(this.processorSuppliers, COMPARATOR);
                return;
            }
        }
    }
}

