/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.Multiplicity;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.component.component.CONNECTION_QUANTIFIER;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ConstraintState;
import org.eclipse.comma.behavior.component.component.EventReception;
import org.eclipse.comma.behavior.component.component.ExpressionConnectionState;
import org.eclipse.comma.behavior.component.component.ExpressionInterfaceState;
import org.eclipse.comma.behavior.component.component.FunctionalConstraint;
import org.eclipse.comma.behavior.component.component.PortAwareEvent;
import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.component.component.TraceFragment;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAddition;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionBulkData;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionDivision;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionEqual;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionGeq;
import org.eclipse.comma.expressions.expression.ExpressionGreater;
import org.eclipse.comma.expressions.expression.ExpressionLeq;
import org.eclipse.comma.expressions.expression.ExpressionLess;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionMaximum;
import org.eclipse.comma.expressions.expression.ExpressionMinimum;
import org.eclipse.comma.expressions.expression.ExpressionMinus;
import org.eclipse.comma.expressions.expression.ExpressionModulo;
import org.eclipse.comma.expressions.expression.ExpressionMultiply;
import org.eclipse.comma.expressions.expression.ExpressionNEqual;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;
import org.eclipse.comma.expressions.expression.ExpressionPlus;
import org.eclipse.comma.expressions.expression.ExpressionPower;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionSubtraction;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.monitoring.generator.EventPatternMixin;
import org.eclipse.comma.monitoring.generator.TypesJavaGenerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class FunctionalConstraintGenerator
extends EventPatternMixin {
    private static final String PORTS_STATES_VAR = "portsStates";
    private List<Interface> interfaces;
    private boolean inEventReception = false;
    private String eventReceptionPort = "";

    public FunctionalConstraintGenerator(List<Interface> interfaces, boolean recordsPresent, IFileSystemAccess fsa) {
        super(null, recordsPresent, fsa);
        this.interfaces = interfaces;
    }

    public void generateUtilityClass(Component c, FunctionalConstraint fc) {
        ArrayList _arrayList;
        this.quantifiersInMachines = _arrayList = new ArrayList();
        this.quantifiersInMachines.addAll(this.getQuantifiersInContainer((EObject)fc));
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(this.utilityClassName(c, fc).toString()), this.utilityClassContent(fc, c));
    }

    public void generateConstraintClass(Component c, FunctionalConstraint fc) {
        ArrayList _arrayList;
        this.quantifiersInMachines = _arrayList = new ArrayList();
        this.quantifiersInMachines.addAll(this.getQuantifiersInContainer((EObject)fc));
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(this.constraintClassName(c, fc).toString()), this.constraintClassContent(fc, c));
    }

    protected CharSequence _constraintClassContent(PredicateFunctionalConstraint fc, Component c) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".utils.Utils;");
        _builder.newLineIfNotEmpty();
        if (this.recordsPresent) {
            _builder.append("import ");
            String _join = IterableExtensions.join(TypesJavaGenerator.recordPackageFragments, (CharSequence)".");
            _builder.append(_join);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("public class ");
        String _constraintClassName = this.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName);
        _builder.append(" extends CFunctionalConstraint {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _utilityClassName = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName, "\t");
        _builder.append(" stateOfDecisionClass;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _constraintClassName_1 = this.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName_1, "\t");
        _builder.append("(String name, String componentInstanceName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(name, componentInstanceName);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = new ");
        String _utilityClassName_1 = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(CFunctionalConstraintState state) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = (");
        String _utilityClassName_2 = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_2, "\t\t");
        _builder.append(") state;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintState getInitialStates() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return stateOfDecisionClass;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintResult consume(CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t\t");
        String _xblockexpression = null;
        this.inEventReception = true;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("componentInstanceName.equals(message.getSource()) ? message.getSourcePort() : message.getDestinationPort()");
        this.eventReceptionPort = _builder_1.toString();
        _xblockexpression = "";
        _builder.append(_xblockexpression, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if((");
        CharSequence _generateExpression = this.generateExpression(fc.getExpression());
        _builder.append((Object)_generateExpression, "\t\t");
        _builder.append(") &&");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        String _xblockexpression_1 = null;
        this.inEventReception = false;
        _xblockexpression_1 = "";
        _builder.append(_xblockexpression_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t  ");
        _builder.append("(");
        CharSequence _generateExpression_1 = this.generateExpression(fc.getExpression());
        _builder.append((Object)_generateExpression_1, "\t\t\t  ");
        _builder.append(")) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t  \t");
        _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
        _builder.newLine();
        _builder.append("\t\t\t  \t");
        _builder.append("result.newState = stateOfDecisionClass;");
        _builder.newLine();
        _builder.append("\t\t\t  \t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("result.isError = true;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _constraintClassContent(StateBasedFunctionalConstraint fc, Component c) {
        StringConcatenation _xblockexpression = null;
        ArrayList<String> states = this.getStateNames(fc);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".utils.Utils;");
        _builder.newLineIfNotEmpty();
        if (this.recordsPresent) {
            _builder.append("import ");
            String _join = IterableExtensions.join(TypesJavaGenerator.recordPackageFragments, (CharSequence)".");
            _builder.append(_join);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("public class ");
        String _constraintClassName = this.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName);
        _builder.append(" extends CFunctionalConstraint {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        String _utilityClassName = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName, "\t");
        _builder.append(" stateOfDecisionClass;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        String _constraintClassName_1 = this.constraintClassName(c, (FunctionalConstraint)fc);
        _builder.append(_constraintClassName_1, "\t");
        _builder.append("(String name, String componentInstanceName) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(name, componentInstanceName);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = new ");
        String _utilityClassName_1 = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(CFunctionalConstraintState state) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = (");
        String _utilityClassName_2 = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_2, "\t\t");
        _builder.append(") state;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintState getInitialStates() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return stateOfDecisionClass;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CFunctionalConstraintResult consume(CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch(stateOfDecisionClass.getState()) {");
        _builder.newLine();
        for (String s : states) {
            _builder.append("\t\t");
            _builder.append("case \"");
            _builder.append(s, "\t\t");
            _builder.append("\" : return state");
            _builder.append(s, "\t\t");
            _builder.append("(message);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("default: return null;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        EList _states = fc.getStates();
        for (State s_1 : _states) {
            _builder.append("\t");
            CharSequence _generateStateMethod = this.generateStateMethod((ConstraintState)s_1);
            _builder.append((Object)_generateStateMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generateFragmentMethods = this.generateFragmentMethods((ConstraintState)s_1);
            _builder.append((Object)_generateFragmentMethods, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateFragmentMethods(ConstraintState s) {
        StringConcatenation _builder = new StringConcatenation();
        EList _traceFragments = s.getTraceFragments();
        for (TraceFragment fragment : _traceFragments) {
            ArrayList<List<Action>> _splitFragmentByAction = this.splitFragmentByAction((List<Action>)fragment.getActions());
            for (List<Action> actionFragment : _splitFragmentByAction) {
                Action _get_3;
                Expression _condition;
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                _builder.append("private CFunctionalConstraintResult state");
                String _name = s.getName();
                _builder.append(_name);
                _builder.append("_");
                int _indexOf = s.getTraceFragments().indexOf((Object)fragment);
                int _plus = _indexOf + 1;
                _builder.append((Object)_plus);
                _builder.append("_");
                int _indexOf_1 = this.splitFragmentByAction((List<Action>)fragment.getActions()).indexOf(actionFragment);
                int _plus_1 = _indexOf_1 + 1;
                _builder.append((Object)_plus_1);
                _builder.append("(CObservedMessage message) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("CMessagePattern e;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("e = ");
                Action _get = actionFragment.get(0);
                CharSequence _generateEvent = this.generateEvent(((EventReception)_get).getEvent());
                _builder.append((Object)_generateEvent, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if(e.match(message)) {");
                _builder.newLine();
                _builder.append("\t\t");
                Action _get_1 = actionFragment.get(0);
                List parameters = ComponentUtilities.getParameters((EventPattern)((EventReception)_get_1).getEvent());
                _builder.newLineIfNotEmpty();
                int _size = parameters.size();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                for (Integer i : _doubleDotLessThan) {
                    _builder.append("\t\t");
                    Expression p = (Expression)parameters.get(i);
                    _builder.newLineIfNotEmpty();
                    if (!(p instanceof ExpressionVariable)) continue;
                    _builder.append("\t\t");
                    _builder.append("stateOfDecisionClass.set_");
                    _builder.append("commaVar_", "\t\t");
                    String _name_1 = ((ExpressionVariable)p).getVariable().getName();
                    _builder.append(_name_1, "\t\t");
                    _builder.append("(message.getParameters().get(");
                    _builder.append((Object)i, "\t\t");
                    _builder.append("));");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t");
                Action _get_2 = actionFragment.get(0);
                EventPattern event = ((EventReception)_get_2).getEvent();
                _builder.newLineIfNotEmpty();
                ExpressionVariable _idVar = ((PortAwareEvent)event).getIdVar();
                boolean bl = _tripleNotEquals = _idVar != null;
                if (_tripleNotEquals) {
                    _builder.append("\t\t");
                    _builder.append("stateOfDecisionClass.set_");
                    _builder.append("commaVar_", "\t\t");
                    String _name_2 = ((PortAwareEvent)event).getIdVar().getVariable().getName();
                    _builder.append(_name_2, "\t\t");
                    _builder.append("(message.getDestination().equals(componentInstanceName) ? message.getSource() : message.getDestination());");
                    _builder.newLineIfNotEmpty();
                }
                boolean bl2 = _tripleNotEquals_1 = (_condition = ((EventReception)(_get_3 = actionFragment.get(0))).getCondition()) != null;
                if (_tripleNotEquals_1) {
                    _builder.append("\t\t");
                    String _xblockexpression = null;
                    this.inEventReception = true;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("\"");
                    Action _get_4 = actionFragment.get(0);
                    EventPattern _event = ((EventReception)_get_4).getEvent();
                    String _name_3 = ((PortAwareEvent)_event).getPort().getName();
                    _builder_1.append(_name_3);
                    _builder_1.append("\"");
                    this.eventReceptionPort = _builder_1.toString();
                    _xblockexpression = "";
                    _builder.append(_xblockexpression, "\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("if(");
                    Action _get_42 = actionFragment.get(0);
                    CharSequence _generateExpression = this.generateExpression(((EventReception)_get_42).getCondition());
                    _builder.append((Object)_generateExpression, "\t\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    String _xblockexpression_1 = null;
                    this.inEventReception = false;
                    _xblockexpression_1 = "";
                    _builder.append(_xblockexpression_1, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    int _size_1 = actionFragment.size();
                    ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(1, _size_1, true);
                    for (Integer i_1 : _doubleDotLessThan_1) {
                        _builder.append("\t\t");
                        _builder.append("\t");
                        CharSequence _generateAction = this.generateAction(actionFragment.get(i_1));
                        _builder.append((Object)_generateAction, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    List _last = (List)IterableExtensions.last(this.splitFragmentByAction((List<Action>)fragment.getActions()));
                    boolean _equals = Objects.equal(actionFragment, (Object)_last);
                    if (_equals) {
                        String _name_32 = fragment.getTarget().getName();
                        _builder.append(_name_32, "\t\t\t");
                    } else {
                        String _name_4 = s.getName();
                        _builder.append(_name_4, "\t\t\t");
                        _builder.append("_");
                        int _indexOf_2 = s.getTraceFragments().indexOf((Object)fragment);
                        int _plus_2 = _indexOf_2 + 1;
                        _builder.append((Object)_plus_2, "\t\t\t");
                        _builder.append("_");
                        int _indexOf_3 = this.splitFragmentByAction((List<Action>)fragment.getActions()).indexOf(actionFragment);
                        int _plus_3 = _indexOf_3 + 2;
                        _builder.append((Object)_plus_3, "\t\t\t");
                    }
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("result.newState = stateOfDecisionClass;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("return result;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("} else {");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("result.isError = true;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("return result;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    int _size_2 = actionFragment.size();
                    ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(1, _size_2, true);
                    for (Integer i_2 : _doubleDotLessThan_2) {
                        _builder.append("\t\t");
                        CharSequence _generateAction_1 = this.generateAction(actionFragment.get(i_2));
                        _builder.append((Object)_generateAction_1, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    List _last_1 = (List)IterableExtensions.last(this.splitFragmentByAction((List<Action>)fragment.getActions()));
                    boolean _equals_1 = Objects.equal(actionFragment, (Object)_last_1);
                    if (_equals_1) {
                        String _name_5 = fragment.getTarget().getName();
                        _builder.append(_name_5, "\t\t");
                    } else {
                        String _name_6 = s.getName();
                        _builder.append(_name_6, "\t\t");
                        _builder.append("_");
                        int _indexOf_4 = s.getTraceFragments().indexOf((Object)fragment);
                        int _plus_4 = _indexOf_4 + 1;
                        _builder.append((Object)_plus_4, "\t\t");
                        _builder.append("_");
                        int _indexOf_5 = this.splitFragmentByAction((List<Action>)fragment.getActions()).indexOf(actionFragment);
                        int _plus_5 = _indexOf_5 + 2;
                        _builder.append((Object)_plus_5, "\t\t");
                    }
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("result.newState = stateOfDecisionClass;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("return result;");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("} else {");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("result.isError = true;");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("return result;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}\t");
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence generateStateMethod(ConstraintState s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CFunctionalConstraintResult state");
        String _name = s.getName();
        _builder.append(_name);
        _builder.append("(CObservedMessage message) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("CMessagePattern e;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("CFunctionalConstraintResult result = new CFunctionalConstraintResult();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("List<Object> tempParameters;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        EList _traceFragments = s.getTraceFragments();
        for (TraceFragment fragment : _traceFragments) {
            Expression _condition;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            _builder.append("\t");
            Action _firstAction = fragment.getFirstAction();
            EventReception first = (EventReception)_firstAction;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("e = ");
            CharSequence _generateEvent = this.generateEvent(first.getEvent());
            _builder.append((Object)_generateEvent, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("//expectedMessages append(e);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (e.match(message)) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            List parameters = ComponentUtilities.getParameters((EventPattern)first.getEvent());
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            boolean revertParamsNeeded = !IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)parameters, (Functions.Function1)new Functions.Function1<Expression, Boolean>(){

                public Boolean apply(Expression p) {
                    return p instanceof ExpressionVariable;
                }
            })) && first.getCondition() != null;
            _builder.newLineIfNotEmpty();
            if (revertParamsNeeded) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("tempParameters = new ArrayList<Object>();");
                _builder.newLine();
            }
            int _size = parameters.size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
            for (Integer i : _doubleDotLessThan) {
                _builder.append("\t");
                _builder.append("\t");
                Expression p = (Expression)parameters.get(i);
                _builder.newLineIfNotEmpty();
                if (!(p instanceof ExpressionVariable)) continue;
                if (revertParamsNeeded) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("tempParameters.add(stateOfDecisionClass.get_");
                    _builder.append("commaVar_", "\t\t");
                    String _name_1 = ((ExpressionVariable)p).getVariable().getName();
                    _builder.append(_name_1, "\t\t");
                    _builder.append("());");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("stateOfDecisionClass.set_");
                _builder.append("commaVar_", "\t\t");
                String _name_2 = ((ExpressionVariable)p).getVariable().getName();
                _builder.append(_name_2, "\t\t");
                _builder.append("(message.getParameters().get(");
                _builder.append((Object)i, "\t\t");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
            EventPattern _event = first.getEvent();
            ExpressionVariable _idVar = ((PortAwareEvent)_event).getIdVar();
            boolean bl = _tripleNotEquals = _idVar != null;
            if (_tripleNotEquals) {
                if (revertParamsNeeded) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("tempParameters.add(stateOfDecisionClass get_");
                    _builder.append("commaVar_", "\t\t");
                    EventPattern _event_1 = first.getEvent();
                    String _name_3 = ((PortAwareEvent)_event_1).getIdVar().getVariable().getName();
                    _builder.append(_name_3, "\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("stateOfDecisionClass.set_");
                _builder.append("commaVar_", "\t\t");
                EventPattern _event_2 = first.getEvent();
                String _name_4 = ((PortAwareEvent)_event_2).getIdVar().getVariable().getName();
                _builder.append(_name_4, "\t\t");
                _builder.append("(message.getDestination().equals(componentInstanceName) ? message.getSource() : message.getDestination());");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _tripleNotEquals_1 = (_condition = first.getCondition()) != null;
            if (_tripleNotEquals_1) {
                int _size_1;
                boolean _equals;
                _builder.append("\t");
                _builder.append("\t");
                String _xblockexpression = null;
                this.inEventReception = true;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("\"");
                EventPattern _event_3 = first.getEvent();
                String _name_5 = ((PortAwareEvent)_event_3).getPort().getName();
                _builder_1.append(_name_5);
                _builder_1.append("\"");
                this.eventReceptionPort = _builder_1.toString();
                _xblockexpression = "";
                _builder.append(_xblockexpression, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if(");
                CharSequence _generateExpression = this.generateExpression(first.getCondition());
                _builder.append((Object)_generateExpression, "\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                String _xblockexpression_1 = null;
                this.inEventReception = false;
                _xblockexpression_1 = "";
                _builder.append(_xblockexpression_1, "\t\t\t");
                _builder.newLineIfNotEmpty();
                int _actionPrefixLength = this.getActionPrefixLength((List<Action>)fragment.getActions());
                ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _actionPrefixLength, true);
                for (Integer i_1 : _doubleDotLessThan_1) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _generateAction = this.generateAction((Action)fragment.getActions().get(i_1.intValue()));
                    _builder.append((Object)_generateAction, "\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                int _actionPrefixLength_1 = this.getActionPrefixLength((List<Action>)fragment.getActions());
                boolean bl3 = _equals = _actionPrefixLength_1 == (_size_1 = fragment.getActions().size());
                if (_equals) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    String _name_52 = fragment.getTarget().getName();
                    _builder.append(_name_52, "\t\t\t");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    String _name_6 = s.getName();
                    _builder.append(_name_6, "\t\t\t");
                    _builder.append("_");
                    int _indexOf = s.getTraceFragments().indexOf((Object)fragment);
                    int _plus = _indexOf + 1;
                    _builder.append((Object)_plus, "\t\t\t");
                    _builder.append("_1\");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("result.newState = stateOfDecisionClass;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return result;");
                _builder.newLine();
                if (revertParamsNeeded) {
                    boolean _tripleNotEquals_2;
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("} else {");
                    _builder.newLine();
                    EventPattern _event_32 = first.getEvent();
                    ExpressionVariable _idVar_1 = ((PortAwareEvent)_event_32).getIdVar();
                    boolean bl4 = _tripleNotEquals_2 = _idVar_1 != null;
                    if (_tripleNotEquals_2) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("stateOfDecisionClass.set_");
                        _builder.append("commaVar_", "\t\t\t");
                        EventPattern _event_4 = first.getEvent();
                        String _name_7 = ((PortAwareEvent)_event_4).getIdVar().getVariable().getName();
                        _builder.append(_name_7, "\t\t\t");
                        _builder.append("(tempParameters.get(tempParameters.size()-1));");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    int counter = 0;
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    Iterable varParams = Iterables.filter((Iterable)parameters, ExpressionVariable.class);
                    _builder.newLineIfNotEmpty();
                    for (ExpressionVariable p_1 : varParams) {
                        if (!(p_1 instanceof ExpressionVariable)) continue;
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("stateOfDecisionClass.set_");
                        _builder.append("commaVar_", "\t\t\t");
                        String _name_8 = p_1.getVariable().getName();
                        _builder.append(_name_8, "\t\t\t");
                        _builder.append("(tempParameters.get(");
                        int _plusPlus = counter++;
                        _builder.append((Object)_plusPlus, "\t\t\t");
                        _builder.append("));");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            } else {
                int _size_2;
                boolean _equals_1;
                int _actionPrefixLength_2 = this.getActionPrefixLength((List<Action>)fragment.getActions());
                ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, _actionPrefixLength_2, true);
                for (Integer i_2 : _doubleDotLessThan_2) {
                    _builder.append("\t");
                    _builder.append("\t");
                    CharSequence _generateAction_1 = this.generateAction((Action)fragment.getActions().get(i_2.intValue()));
                    _builder.append((Object)_generateAction_1, "\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                int _actionPrefixLength_3 = this.getActionPrefixLength((List<Action>)fragment.getActions());
                boolean bl5 = _equals_1 = _actionPrefixLength_3 == (_size_2 = fragment.getActions().size());
                if (_equals_1) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    String _name_9 = fragment.getTarget().getName();
                    _builder.append(_name_9, "\t\t");
                    _builder.append("\");");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("stateOfDecisionClass.setState(\"");
                    String _name_10 = s.getName();
                    _builder.append(_name_10, "\t\t");
                    _builder.append("_");
                    int _indexOf_1 = s.getTraceFragments().indexOf((Object)fragment);
                    int _plus_1 = _indexOf_1 + 1;
                    _builder.append((Object)_plus_1, "\t\t");
                    _builder.append("_1\");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("result.newState = stateOfDecisionClass;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return result;");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("//guard operation if there is no match");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("result.isError = true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _utilityClassContent(StateBasedFunctionalConstraint fc, Component c) {
        boolean _not;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.Set;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CFunctionalConstraintState;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CPathDescription;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        if (this.recordsPresent) {
            _builder.append("import ");
            String _join = IterableExtensions.join(TypesJavaGenerator.recordPackageFragments, (CharSequence)".");
            _builder.append(_join);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("public class ");
        String _utilityClassName = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName);
        _builder.append(" extends CFunctionalConstraintState {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* current state */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private String state;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* variables */");
        _builder.newLine();
        EList _vars = fc.getVars();
        for (Variable v : _vars) {
            _builder.append("\t");
            _builder.append("private ");
            CharSequence _javaType = this.toJavaType((EObject)v.getType());
            _builder.append((Object)_javaType, "\t");
            _builder.append(" ");
            _builder.append("commaVar_", "\t");
            String _name = v.getName();
            _builder.append(_name, "\t");
            _builder.append(" = ");
            CharSequence _defaultValue = this.defaultValue((EObject)v.getType());
            _builder.append((Object)_defaultValue, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* getter and setter for current state */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String getState() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return state;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(String s) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("state = s;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* getters and setters for global variables */");
        _builder.newLine();
        EList _vars_1 = fc.getVars();
        for (Variable v_1 : _vars_1) {
            _builder.append("\t");
            _builder.append("public ");
            CharSequence _javaType_1 = this.toJavaType((EObject)v_1.getType());
            _builder.append((Object)_javaType_1, "\t");
            _builder.append(" get_");
            _builder.append("commaVar_", "\t");
            String _name_1 = v_1.getName();
            _builder.append(_name_1, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            _builder.append("commaVar_", "\t\t");
            String _name_2 = v_1.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set_");
            _builder.append("commaVar_", "\t");
            String _name_3 = v_1.getName();
            _builder.append(_name_3, "\t");
            _builder.append("(Object i) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("commaVar_", "\t\t");
            String _name_4 = v_1.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append(" = (");
            CharSequence _javaType_2 = this.toJavaType((EObject)v_1.getType());
            _builder.append((Object)_javaType_2, "\t\t");
            _builder.append(") i;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
        }
        int _size = this.quantifiersInMachines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("/* methods that implement quantifiers */");
            _builder.newLine();
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("public ");
        String _utilityClassName_1 = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("/* initialization of ports states */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(PORTS_STATES_VAR, "\t\t");
        _builder.append(" = new HashMap<String, Map<String, CPathDescription>>();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of current state */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("state = \"");
        String _name_5 = ComponentUtilities.getInitialState((StateBasedFunctionalConstraint)fc).getName();
        _builder.append(_name_5, "\t\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = fc.getInitActions().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("/* initialization of variables in init section */");
            _builder.newLine();
            EList _initActions = fc.getInitActions();
            for (Action a : _initActions) {
                _builder.append("\t\t");
                CharSequence _generateAction = this.generateAction(a);
                _builder.append((Object)_generateAction, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of initial port states */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("initialPortStates = new HashMap<String, Set<String>>();");
        _builder.newLine();
        EList _ports = c.getPorts();
        for (Port p : _ports) {
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name_6 = p.getName();
            _builder.append(_name_6, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort = this.initialStatesForPort(p);
            boolean _hasElements = false;
            for (State s : _initialStatesForPort) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_7 = s.getName();
                _builder.append(_name_7, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _utilityClassContent(PredicateFunctionalConstraint fc, Component c) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("import java.util.Arrays;");
        _builder.newLine();
        _builder.append("import java.util.HashMap;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.Set;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CFunctionalConstraintState;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CPathDescription;");
        _builder.newLineIfNotEmpty();
        if (this.recordsPresent) {
            _builder.append("import ");
            String _join = IterableExtensions.join(TypesJavaGenerator.recordPackageFragments, (CharSequence)".");
            _builder.append(_join);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("public class ");
        String _utilityClassName = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName);
        _builder.append(" extends CFunctionalConstraintState {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        int _size = this.quantifiersInMachines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("/* methods that implement quantifiers */");
            _builder.newLine();
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("public ");
        String _utilityClassName_1 = this.utilityClassName(c, (FunctionalConstraint)fc);
        _builder.append(_utilityClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("/* initialization of ports states */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(PORTS_STATES_VAR, "\t\t");
        _builder.append(" = new HashMap<String, Map<String, CPathDescription>>();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of initial port states */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("initialPortStates = new HashMap<String, Set<String>>();");
        _builder.newLine();
        EList _ports = c.getPorts();
        for (Port p : _ports) {
            _builder.append("\t\t");
            _builder.append("initialPortStates.put(\"");
            String _name = p.getName();
            _builder.append(_name, "\t\t");
            _builder.append("\", new HashSet<>(Arrays.asList(");
            Iterable<State> _initialStatesForPort = this.initialStatesForPort(p);
            boolean _hasElements = false;
            for (State s : _initialStatesForPort) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t");
                }
                _builder.append("\"");
                String _name_1 = s.getName();
                _builder.append(_name_1, "\t\t");
                _builder.append("\"");
            }
            _builder.append(")));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String utilityClassName(Component c, FunctionalConstraint fc) {
        String _name = c.getName();
        String _name_1 = fc.getName();
        String _plus = String.valueOf(_name) + _name_1;
        return String.valueOf(_plus) + "State";
    }

    public String constraintClassName(Component c, FunctionalConstraint fc) {
        String _name = c.getName();
        String _name_1 = fc.getName();
        String _plus = String.valueOf(_name) + _name_1;
        return String.valueOf(_plus) + "FunctionalConstraint";
    }

    public Iterable<State> initialStatesForPort(final Port port) {
        Functions.Function1<Interface, Boolean> _function = new Functions.Function1<Interface, Boolean>(){

            public Boolean apply(Interface it) {
                return it.getName().equals(port.getInterface().getName());
            }
        };
        Functions.Function1<StateMachine, Iterable<State>> _function_1 = new Functions.Function1<StateMachine, Iterable<State>>(){

            public Iterable<State> apply(StateMachine it) {
                Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return it.isInitial();
                    }
                };
                return IterableExtensions.filter((Iterable)it.getStates(), (Functions.Function1)_function);
            }
        };
        return Iterables.concat((Iterable)ListExtensions.map((List)((Interface)IterableExtensions.findFirst(this.interfaces, (Functions.Function1)_function)).getMachines(), (Functions.Function1)_function_1));
    }

    public ArrayList<String> getStateNames(StateBasedFunctionalConstraint fc) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> result = new ArrayList<String>();
        EList _states = fc.getStates();
        for (State s : _states) {
            EList fragments = ((ConstraintState)s).getTraceFragments();
            result.add(s.getName());
            for (TraceFragment fragment : fragments) {
                Functions.Function1<Action, Boolean> _function = new Functions.Function1<Action, Boolean>(){

                    public Boolean apply(Action it) {
                        return it instanceof EventReception;
                    }
                };
                List eventReceptions = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)fragment.getActions(), (Functions.Function1)_function));
                for (Action event : eventReceptions) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _name = s.getName();
                    _builder.append(_name);
                    _builder.append("_");
                    int _indexOf = fragments.indexOf((Object)fragment);
                    int _plus = _indexOf + 1;
                    _builder.append((Object)_plus);
                    _builder.append("_");
                    int _indexOf_1 = eventReceptions.indexOf(event);
                    int _plus_1 = _indexOf_1 + 1;
                    _builder.append((Object)_plus_1);
                    result.add(_builder.toString());
                }
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public int getActionPrefixLength(List<Action> actions) {
        Functions.Function1<Action, Boolean> _function = new Functions.Function1<Action, Boolean>(){

            public Boolean apply(Action it) {
                return it instanceof EventReception;
            }
        };
        Action reception = (Action)IterableExtensions.findFirst(actions, (Functions.Function1)_function);
        if (reception != null) {
            return actions.indexOf(reception);
        }
        return actions.size();
    }

    public ArrayList<List<Action>> splitFragmentByAction(List<Action> actions) {
        ArrayList<List<Action>> _xblockexpression = null;
        ArrayList<List<Action>> result = new ArrayList<List<Action>>();
        ArrayList<Action> fragment = null;
        boolean skipAction = true;
        for (Action action : actions) {
            if (action instanceof EventReception) {
                ArrayList<Action> _arrayList;
                skipAction = false;
                fragment = _arrayList = new ArrayList<Action>();
                fragment.add(action);
                result.add(fragment);
                continue;
            }
            if (skipAction) continue;
            fragment.add(action);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    @Override
    public boolean isVariableScope(EObject o) {
        return o instanceof ConstraintState || super.isVariableScope(o);
    }

    protected CharSequence _generateExpression(ExpressionInterfaceState expr) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(stateOfDecisionClass.portInState(\"");
        String _name = expr.getPort().getName();
        _builder.append(_name);
        _builder.append("\", \"");
        String _name_1 = expr.getState().getName();
        _builder.append(_name_1);
        _builder.append("\", ");
        if (this.inEventReception) {
            _builder.append(this.eventReceptionPort);
            _builder.append(", componentInstanceName.equals(message.getSource()) ? message.getDestination() : message.getSource()");
        } else {
            _builder.append("null, null");
        }
        _builder.append("))");
        return _builder;
    }

    protected CharSequence _generateExpression(ExpressionConnectionState expr) {
        boolean _tripleNotEquals;
        StringConcatenation _xifexpression = null;
        ExpressionVariable _idVar = expr.getIdVar();
        boolean bl = _tripleNotEquals = _idVar != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(stateOfDecisionClass.connectionAtPortInState(stateOfDecisionClass.get_");
            _builder.append("commaVar_");
            String _name = expr.getIdVar().getVariable().getName();
            _builder.append(_name);
            _builder.append("(), \"");
            String _name_1 = expr.getPort().getName();
            _builder.append(_name_1);
            _builder.append("\", new HashSet<>(Arrays.asList(");
            EList _states = expr.getStates();
            boolean _hasElements = false;
            for (State s : _states) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                _builder.append("\"");
                String _name_2 = s.getName();
                _builder.append(_name_2);
                _builder.append("\"");
            }
            _builder.append(")), ");
            if (this.inEventReception) {
                _builder.append(this.eventReceptionPort);
                _builder.append(", componentInstanceName.equals(message.getSource()) ? message.getDestination() : message.getSource()");
            } else {
                _builder.append("null, null");
            }
            _builder.append("))");
            _xifexpression = _builder;
        } else {
            boolean _tripleNotEquals_1;
            StringConcatenation _xifexpression_1 = null;
            Multiplicity _multiplicity = expr.getMultiplicity();
            boolean bl2 = _tripleNotEquals_1 = _multiplicity != null;
            if (_tripleNotEquals_1) {
                boolean _tripleNotEquals_2;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("(stateOfDecisionClass.someAtPortInState(\"");
                String _name_3 = expr.getPort().getName();
                _builder_1.append(_name_3);
                _builder_1.append("\", new HashSet<>(Arrays.asList(");
                EList _states_1 = expr.getStates();
                boolean _hasElements_1 = false;
                for (State s_1 : _states_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder_1.appendImmediate((Object)", ", "");
                    }
                    _builder_1.append("\"");
                    String _name_4 = s_1.getName();
                    _builder_1.append(_name_4);
                    _builder_1.append("\"");
                }
                _builder_1.append(")), ");
                if (this.inEventReception) {
                    _builder_1.append(this.eventReceptionPort);
                    _builder_1.append(", componentInstanceName.equals(message.getSource()) ? message.getDestination() : message.getSource()");
                } else {
                    _builder_1.append("null, null");
                }
                _builder_1.append(", ");
                long _lower = expr.getMultiplicity().getLower();
                _builder_1.append((Object)_lower);
                _builder_1.append(", ");
                String _upperInf = expr.getMultiplicity().getUpperInf();
                boolean bl3 = _tripleNotEquals_2 = _upperInf != null;
                if (_tripleNotEquals_2) {
                    _builder_1.append("-1");
                } else {
                    long _upper = expr.getMultiplicity().getUpper();
                    _builder_1.append((Object)_upper);
                }
                _builder_1.append("))");
                _xifexpression_1 = _builder_1;
            } else {
                CONNECTION_QUANTIFIER _quantifier_2;
                boolean _equals_2;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("(stateOfDecisionClass.");
                CONNECTION_QUANTIFIER _quantifier = expr.getQuantifier();
                boolean _equals = Objects.equal((Object)_quantifier, (Object)CONNECTION_QUANTIFIER.ALL);
                if (_equals) {
                    _builder_2.append("allAtPortInState");
                } else {
                    _builder_2.append("someAtPortInState");
                }
                _builder_2.append("(\"");
                String _name_5 = expr.getPort().getName();
                _builder_2.append(_name_5);
                _builder_2.append("\", new HashSet<>(Arrays.asList(");
                EList _states_2 = expr.getStates();
                boolean _hasElements_2 = false;
                for (State s_2 : _states_2) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder_2.appendImmediate((Object)", ", "");
                    }
                    _builder_2.append("\"");
                    String _name_6 = s_2.getName();
                    _builder_2.append(_name_6);
                    _builder_2.append("\"");
                }
                _builder_2.append(")), ");
                if (this.inEventReception) {
                    _builder_2.append(this.eventReceptionPort);
                    _builder_2.append(", componentInstanceName.equals(message.getSource()) ? message.getDestination() : message.getSource()");
                } else {
                    _builder_2.append("null, null");
                }
                CONNECTION_QUANTIFIER _quantifier_1 = expr.getQuantifier();
                boolean _equals_1 = Objects.equal((Object)_quantifier_1, (Object)CONNECTION_QUANTIFIER.ONE);
                if (_equals_1) {
                    _builder_2.append(", 1, 1");
                }
                if (_equals_2 = Objects.equal((Object)(_quantifier_2 = expr.getQuantifier()), (Object)CONNECTION_QUANTIFIER.SOME)) {
                    _builder_2.append(", 1, -1");
                }
                _builder_2.append("))");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public CharSequence constraintClassContent(FunctionalConstraint fc, Component c) {
        if (fc instanceof PredicateFunctionalConstraint) {
            return this._constraintClassContent((PredicateFunctionalConstraint)fc, c);
        }
        if (fc instanceof StateBasedFunctionalConstraint) {
            return this._constraintClassContent((StateBasedFunctionalConstraint)fc, c);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fc, c).toString());
    }

    public CharSequence utilityClassContent(FunctionalConstraint fc, Component c) {
        if (fc instanceof PredicateFunctionalConstraint) {
            return this._utilityClassContent((PredicateFunctionalConstraint)fc, c);
        }
        if (fc instanceof StateBasedFunctionalConstraint) {
            return this._utilityClassContent((StateBasedFunctionalConstraint)fc, c);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(fc, c).toString());
    }

    @Override
    public CharSequence generateExpression(Expression expr) {
        if (expr instanceof ExpressionAddition) {
            return this._generateExpression((ExpressionAddition)expr);
        }
        if (expr instanceof ExpressionAnd) {
            return this._generateExpression((ExpressionAnd)expr);
        }
        if (expr instanceof ExpressionBracket) {
            return this._generateExpression((ExpressionBracket)expr);
        }
        if (expr instanceof ExpressionDivision) {
            return this._generateExpression((ExpressionDivision)expr);
        }
        if (expr instanceof ExpressionEqual) {
            return this._generateExpression((ExpressionEqual)expr);
        }
        if (expr instanceof ExpressionGeq) {
            return this._generateExpression((ExpressionGeq)expr);
        }
        if (expr instanceof ExpressionGreater) {
            return this._generateExpression((ExpressionGreater)expr);
        }
        if (expr instanceof ExpressionLeq) {
            return this._generateExpression((ExpressionLeq)expr);
        }
        if (expr instanceof ExpressionLess) {
            return this._generateExpression((ExpressionLess)expr);
        }
        if (expr instanceof ExpressionMaximum) {
            return this._generateExpression((ExpressionMaximum)expr);
        }
        if (expr instanceof ExpressionMinimum) {
            return this._generateExpression((ExpressionMinimum)expr);
        }
        if (expr instanceof ExpressionMinus) {
            return this._generateExpression((ExpressionMinus)expr);
        }
        if (expr instanceof ExpressionModulo) {
            return this._generateExpression((ExpressionModulo)expr);
        }
        if (expr instanceof ExpressionMultiply) {
            return this._generateExpression((ExpressionMultiply)expr);
        }
        if (expr instanceof ExpressionNEqual) {
            return this._generateExpression((ExpressionNEqual)expr);
        }
        if (expr instanceof ExpressionNot) {
            return this._generateExpression((ExpressionNot)expr);
        }
        if (expr instanceof ExpressionOr) {
            return this._generateExpression((ExpressionOr)expr);
        }
        if (expr instanceof ExpressionPlus) {
            return this._generateExpression((ExpressionPlus)expr);
        }
        if (expr instanceof ExpressionPower) {
            return this._generateExpression((ExpressionPower)expr);
        }
        if (expr instanceof ExpressionSubtraction) {
            return this._generateExpression((ExpressionSubtraction)expr);
        }
        if (expr instanceof ExpressionConnectionState) {
            return this._generateExpression((ExpressionConnectionState)expr);
        }
        if (expr instanceof ExpressionInterfaceState) {
            return this._generateExpression((ExpressionInterfaceState)expr);
        }
        if (expr instanceof ExpressionAny) {
            return this._generateExpression((ExpressionAny)expr);
        }
        if (expr instanceof ExpressionBulkData) {
            return this._generateExpression((ExpressionBulkData)expr);
        }
        if (expr instanceof ExpressionConstantBool) {
            return this._generateExpression((ExpressionConstantBool)expr);
        }
        if (expr instanceof ExpressionConstantInt) {
            return this._generateExpression((ExpressionConstantInt)expr);
        }
        if (expr instanceof ExpressionConstantReal) {
            return this._generateExpression((ExpressionConstantReal)expr);
        }
        if (expr instanceof ExpressionConstantString) {
            return this._generateExpression((ExpressionConstantString)expr);
        }
        if (expr instanceof ExpressionEnumLiteral) {
            return this._generateExpression((ExpressionEnumLiteral)expr);
        }
        if (expr instanceof ExpressionFunctionCall) {
            return this._generateExpression((ExpressionFunctionCall)expr);
        }
        if (expr instanceof ExpressionMap) {
            return this._generateExpression((ExpressionMap)expr);
        }
        if (expr instanceof ExpressionMapRW) {
            return this._generateExpression((ExpressionMapRW)expr);
        }
        if (expr instanceof ExpressionQuantifier) {
            return this._generateExpression((ExpressionQuantifier)expr);
        }
        if (expr instanceof ExpressionRecord) {
            return this._generateExpression((ExpressionRecord)expr);
        }
        if (expr instanceof ExpressionRecordAccess) {
            return this._generateExpression((ExpressionRecordAccess)expr);
        }
        if (expr instanceof ExpressionVariable) {
            return this._generateExpression((ExpressionVariable)expr);
        }
        if (expr instanceof ExpressionVector) {
            return this._generateExpression((ExpressionVector)expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }
}

