/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.javasupport.SimpleProjectDependencyGraph;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.CoarseGrainedChangeEvent;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.util.JavaProjectClasspathChangeAnalyzer;

@Singleton
public class ProjectClasspathChangeListener
implements IElementChangedListener {
    private static final Logger log = Logger.getLogger(ProjectClasspathChangeListener.class);
    @Inject
    private IWorkspace workspace;
    @Inject
    @Deprecated
    private BuildScheduler buildManager;
    @Inject
    private IDirtyStateManager dirtyStateManager;
    @Inject
    private JavaProjectClasspathChangeAnalyzer javaProjectClasspathChangeAnalyzer;
    @Inject
    private SimpleProjectDependencyGraph projectDependencyGraph;

    public void elementChanged(ElementChangedEvent event) {
        if (this.workspace != null && this.workspace.isAutoBuilding()) {
            try {
                Set<IJavaProject> javaProjects;
                if (event.getDelta() != null && !(javaProjects = this.getJavaProjectsWithClasspathChange(event.getDelta())).isEmpty()) {
                    ImmutableSet projects = FluentIterable.from(javaProjects).filter(Predicates.notNull()).transform(IJavaProject::getProject).toSet();
                    this.dirtyStateManager.notifyListeners((IResourceDescription.Event)new CoarseGrainedChangeEvent());
                    LinkedHashSet mutableProjects = Sets.newLinkedHashSet((Iterable)projects);
                    for (IProject project : projects) {
                        mutableProjects.addAll(this.projectDependencyGraph.getDependentXtextProjects(project));
                    }
                    this.scheduleBuildIfNecessary(mutableProjects);
                }
            }
            catch (WrappedException e) {
                log.error((Object)e.getCause().getMessage(), e.getCause());
            }
            catch (RuntimeException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Deprecated
    private void scheduleBuildIfNecessary(Set<IProject> projects) {
        this.buildManager.scheduleBuildIfNecessary(projects, IBuildFlag.FORGET_BUILD_STATE_ONLY);
    }

    protected Set<IJavaProject> getJavaProjectsWithClasspathChange(IJavaElementDelta delta) {
        return this.javaProjectClasspathChangeAnalyzer.getJavaProjectsWithClasspathChange(delta);
    }

    protected SimpleProjectDependencyGraph getProjectDependencyGraph() {
        return this.projectDependencyGraph;
    }
}

