/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.parameters.ui.contentassist;

import com.google.common.base.Objects;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinition;
import org.eclipse.comma.behavior.ui.contentassist.HtmlConfigurableCompletionProposal;
import org.eclipse.comma.parameters.ParametersUtils;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.parameters.ui.contentassist.AbstractParametersProposalProvider;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.types.types.Import;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ParametersProposalProvider
extends AbstractParametersProposalProvider {
    protected Image templateIcon = ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.comma.icons").getResource("icons/template.png")).createImage();
    private final int TEMPLATE_DEFAULT_PRIORITY = 600;

    @Override
    public void complete_TriggerParams(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _tripleNotEquals;
        super.complete_Parameters(model, ruleCall, context, acceptor);
        Parameters parameters = (Parameters)model;
        boolean _isEmpty = parameters.getImports().isEmpty();
        if (_isEmpty) {
            return;
        }
        Import import_ = (Import)parameters.getImports().get(0);
        EObject _head = (EObject)IteratorExtensions.head((Iterator)EcoreUtil2.getResource((Resource)import_.eResource(), (String)import_.getImportURI()).getAllContents());
        InterfaceDefinition itf = (InterfaceDefinition)_head;
        Object[] existingTriggerParams = new String[]{};
        EList _triggerParams = parameters.getTriggerParams();
        boolean bl = _tripleNotEquals = _triggerParams != null;
        if (_tripleNotEquals) {
            Functions.Function1<TriggerParams, String> _function = new Functions.Function1<TriggerParams, String>(){

                public String apply(TriggerParams t) {
                    return t.getEvent().getName();
                }
            };
            existingTriggerParams = (String[])Conversions.unwrapArray((Object)ListExtensions.map((List)parameters.getTriggerParams(), (Functions.Function1)_function), String.class);
        }
        String proposal = "";
        Map transitionStates = ParametersUtils.getTransitionStates((InterfaceDefinition)itf);
        Set _entrySet = transitionStates.entrySet();
        for (Map.Entry entry : _entrySet) {
            Functions.Function1<Parameter, Boolean> _function_1 = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter p) {
                    DIRECTION _direction = p.getDirection();
                    return !Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
                }
            };
            Iterable params = IterableExtensions.filter((Iterable)((InterfaceEvent)entry.getKey()).getParameters(), (Functions.Function1)_function_1);
            if (ArrayExtensions.contains((Object[])existingTriggerParams, (Object)((InterfaceEvent)entry.getKey()).getName()) || IterableExtensions.isEmpty((Iterable)params)) continue;
            String _proposal = proposal;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("trigger: ");
            String _name = ((InterfaceEvent)entry.getKey()).getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            Set _value = (Set)entry.getValue();
            for (String state : _value) {
                _builder.append("state: ");
                _builder.append(state);
                _builder.append(" params: ( ");
                Functions.Function1<Parameter, String> _function_2 = new Functions.Function1<Parameter, String>(){

                    public String apply(Parameter p) {
                        return p.getName().toUpperCase();
                    }
                };
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)params, (Functions.Function1)_function_2), (CharSequence)", ");
                _builder.append(_join);
                _builder.append(" )");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            proposal = String.valueOf(_proposal) + _builder;
        }
        acceptor.accept((ICompletionProposal)this.createProposal("Autocomplete missing triggers", proposal, "", context, 600, -1, -1));
    }

    private HtmlConfigurableCompletionProposal createProposal(String name, String content, String additionalInfo, ContentAssistContext context, int priority, int selection, int length) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        String finalAdditionalInfo = content;
        StyledString _styledString = new StyledString(name);
        HtmlConfigurableCompletionProposal proposal = this.createHtmlCompletionProposal(content, _styledString, this.templateIcon, 600, context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            while (finalAdditionalInfo.startsWith("\n") || finalAdditionalInfo.startsWith("\r")) {
                finalAdditionalInfo = finalAdditionalInfo.substring(1);
            }
            finalAdditionalInfo = "<html><body bgcolor=\"#FFFFE1\"><style> body { font-size:9pt; font-family:'Segoe UI' }</style><pre>" + finalAdditionalInfo + "</pre>";
            if (additionalInfo != null) {
                finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "<p>" + additionalInfo + "</p>";
            }
            finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "</body></html>";
            proposal.setAdditionalProposalInfo((Object)finalAdditionalInfo);
            proposal.setProposalContextResource((Resource)context.getResource());
            proposal.setPriority(priority);
            int _offset = context.getOffset();
            int _plus = _offset + selection;
            proposal.setSelectionStart(_plus);
            proposal.setSelectionLength(length);
        }
        _xblockexpression = proposal;
        return _xblockexpression;
    }

    private HtmlConfigurableCompletionProposal createHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        boolean _isValidProposal = this.isValidProposal(proposal, context.getPrefix(), context);
        if (_isValidProposal) {
            return this.doCreateHtmlCompletionProposal(proposal, displayString, image, priority, context);
        }
        return null;
    }

    private HtmlConfigurableCompletionProposal doCreateHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        int _length = proposal.length();
        HtmlConfigurableCompletionProposal result = new HtmlConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, _length, image, displayString, null, null);
        result.setPriority(priority);
        result.setMatcher(context.getMatcher());
        result.setReplaceContextLength(context.getReplaceContextLength());
        _xblockexpression = result;
        return _xblockexpression;
    }
}

