/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.validation;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.types.scoping.TypesImportUriGlobalScopeProvider;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.Import;
import org.eclipse.comma.types.types.IntExp;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.ModelContainer;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypesModel;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.comma.types.validation.AbstractTypesValidator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class TypesValidator
extends AbstractTypesValidator {
    @Inject
    private ResourceDescriptionsProvider rdp;

    protected void checkForNameDuplications(Iterable<? extends NamedElement> elements, String desc, String code, String ... issueData) {
        HashMultimap multiMap = HashMultimap.create();
        for (NamedElement namedElement : elements) {
            multiMap.put((Object)namedElement.getName(), (Object)namedElement);
        }
        Set set = multiMap.asMap().entrySet();
        for (Map.Entry entry : set) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (NamedElement d : duplicates) {
                this.error("Duplicate " + desc + " name", d, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME, code, issueData);
            }
        }
    }

    protected boolean placePredefinedTypes(HashMultimap<String, Object> multiMap) {
        boolean _xblockexpression = false;
        multiMap.put((Object)"int", null);
        multiMap.put((Object)"bool", null);
        multiMap.put((Object)"real", null);
        multiMap.put((Object)"string", null);
        multiMap.put((Object)"void", null);
        multiMap.put((Object)"any", null);
        multiMap.put((Object)"bulkdata", null);
        _xblockexpression = multiMap.put((Object)"id", null);
        return _xblockexpression;
    }

    public HashMultimap<String, Object> checkDuplicationsInImportedTypes(ModelContainer decl) {
        HashMultimap _xblockexpression = null;
        LinkedHashSet<URI> knownURIs = new LinkedHashSet<URI>(5);
        knownURIs.add(decl.eResource().getURI());
        LinkedHashSet<URI> importedURIs = TypesImportUriGlobalScopeProvider.traverseImportedURIs(decl.eResource(), knownURIs);
        HashMultimap multiMap = HashMultimap.create();
        IResourceDescriptions index = this.rdp.getResourceDescriptions(decl.eResource());
        for (URI uri : importedURIs) {
            Iterable _exportedObjectsByType = index.getResourceDescription(uri).getExportedObjectsByType(TypesPackage.Literals.TYPE_DECL);
            for (IEObjectDescription ed : _exportedObjectsByType) {
                multiMap.put((Object)ed.getName().toString(), (Object)ed);
            }
        }
        this.placePredefinedTypes((HashMultimap<String, Object>)multiMap);
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _key = (String)entry.getKey();
            String _plus = "Imports contain duplicate type with name " + _key;
            this.error(_plus, decl, (EStructuralFeature)TypesPackage.Literals.MODEL_CONTAINER__IMPORTS, 0);
        }
        _xblockexpression = multiMap;
        return _xblockexpression;
    }

    @Check
    public void checkLocalTypesForDuplications(TypesModel decl) {
        HashMultimap<String, Object> multiMap = this.checkDuplicationsInImportedTypes(decl);
        EList<TypeDecl> _types = decl.getTypes();
        for (TypeDecl tDecl : _types) {
            boolean _containsKey = multiMap.containsKey((Object)tDecl.getName());
            if (!_containsKey) continue;
            this.error("Type with the same name is already imported", tDecl, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkDuplicatedRecordFields(RecordTypeDecl type) {
        this.checkForNameDuplications((Iterable<? extends NamedElement>)type.getFields(), "record field", null, new String[0]);
    }

    @Check
    public void checkCircularHierarchy(RecordTypeDecl type) {
        boolean _contains = TypeUtilities.getAllParents(type).contains(type);
        if (_contains) {
            this.error("Cycle in the extension hierarchy", (EStructuralFeature)TypesPackage.Literals.RECORD_TYPE_DECL__PARENT);
        }
    }

    @Check
    public void checkOverridenRecordFields(RecordTypeDecl type) {
        boolean _tripleNotEquals;
        RecordTypeDecl _parent = type.getParent();
        boolean bl = _tripleNotEquals = _parent != null;
        if (_tripleNotEquals) {
            List<RecordField> inheritedFields = TypeUtilities.getAllFields(type.getParent());
            EList<RecordField> _fields = type.getFields();
            for (final RecordField f : _fields) {
                boolean _not;
                Functions.Function1<RecordField, Boolean> _function = new Functions.Function1<RecordField, Boolean>(){

                    public Boolean apply(RecordField ff) {
                        return ff.getName().equals(f.getName());
                    }
                };
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(inheritedFields, (Functions.Function1)_function));
                boolean bl2 = _not = !_isEmpty;
                if (!_not) continue;
                this.error("Local field overrides inherited field", f, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
            }
        }
    }

    @Check
    public void checkDuplicatedEnumElements(EnumTypeDecl type) {
        this.checkForNameDuplications((Iterable<? extends NamedElement>)type.getLiterals(), "enumeration literal", null, new String[0]);
    }

    @Check
    public void checkEnumLiteralValues(EnumTypeDecl type) {
        int currentValue = -1;
        EList<EnumElement> _literals = type.getLiterals();
        for (EnumElement l : _literals) {
            boolean _lessEqualsThan;
            boolean _tripleEquals;
            IntExp _value = l.getValue();
            boolean bl = _tripleEquals = _value == null;
            if (_tripleEquals) {
                ++currentValue;
                continue;
            }
            int _value_1 = l.getValue().getValue();
            boolean bl2 = _lessEqualsThan = _value_1 <= currentValue;
            if (_lessEqualsThan) {
                this.error("Enum value has to be greater than the previous value", l, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
                return;
            }
            currentValue = l.getValue().getValue();
        }
    }

    @Check
    public void checkDuplicatedTypeDeclarations(TypesModel typedecl) {
        this.checkForNameDuplications((Iterable<? extends NamedElement>)typedecl.getTypes(), "type declaration", null, new String[0]);
    }

    @Check
    public void checkImportForValidity(Import imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", imp, (EStructuralFeature)TypesPackage.Literals.IMPORT__IMPORT_URI);
        } else {
            boolean _not_1;
            EClass _typesModel;
            Resource r = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            EClass _eClass = ((EObject)IteratorExtensions.head((Iterator)r.getAllContents())).eClass();
            boolean _equals = Objects.equal((Object)_eClass, (Object)(_typesModel = TypesPackage.eINSTANCE.getTypesModel()));
            boolean bl2 = _not_1 = !_equals;
            if (_not_1) {
                this.error("Only imports for type definitions are allowed", imp, (EStructuralFeature)TypesPackage.Literals.IMPORT__IMPORT_URI);
            }
        }
    }

    @Check
    public void checkForAnyType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("any")) {
            this.error("Usage of type any is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
        }
    }

    @Check
    public void checkForVoidType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("void")) {
            this.error("Usage of type void is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
        }
    }

    @Check
    public void checkForIdType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("id")) {
            this.error("Usage of type id is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
        }
    }

    @Check
    public void checkKeyType(MapTypeConstructor mtc) {
        if (!(TypeUtilities.getKeyType(mtc) instanceof EnumTypeDecl) && !(TypeUtilities.getKeyType(mtc) instanceof SimpleTypeDecl)) {
            this.error("The type of map keys has to be enumeration or simple type", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
        }
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
        try {
            super.register(registrar);
            String VALIDATOR_ID = "org.eclipse.comma.types.commaValidator";
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            if (reg != null) {
                IConfigurationElement[] extensions;
                IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor("org.eclipse.comma.types.commaValidator");
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object o = e.createExecutableExtension("class");
                    boolean _startsWith = ((Object)((Object)this)).getClass().getSimpleName().startsWith(e.getAttribute("language"));
                    if (_startsWith) {
                        List<EPackage> _ePackages = this.getEPackages();
                        for (EPackage ePackage : _ePackages) {
                            registrar.register(ePackage, (EValidator)o);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

