/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.quickaccess;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class LaunchQuickAccessElement
extends QuickAccessElement {
    private ILaunchConfiguration launch;
    private ILaunchMode launchMode;

    public LaunchQuickAccessElement(ILaunchConfiguration launch, ILaunchMode launchMode) {
        this.launch = launch;
        this.launchMode = launchMode;
    }

    public String getLabel() {
        return this.launch.getName();
    }

    public String getMatchLabel() {
        return String.valueOf(this.getLabel()) + ' ' + this.launchMode.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        try {
            return DebugPluginImages.getImageDescriptor(this.launch.getType().getIdentifier());
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
            return null;
        }
    }

    public String getId() {
        return String.valueOf(this.launch.getName()) + '/' + this.launchMode.getIdentifier();
    }

    public void execute() {
        DebugUITools.launch(this.launch, this.launchMode.getIdentifier());
    }
}

