/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.p2.ui.MessageDialogWithLink;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ISizingPhaseSet;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleException;

public class ProvUI {
    public static final String INSTALL_COMMAND_LABEL = ProvUIMessages.InstallIUCommandLabel;
    public static final String INSTALL_COMMAND_TOOLTIP = ProvUIMessages.InstallIUCommandTooltip;
    public static final String UNINSTALL_COMMAND_LABEL = ProvUIMessages.UninstallIUCommandLabel;
    public static final String UNINSTALL_COMMAND_TOOLTIP = ProvUIMessages.UninstallIUCommandTooltip;
    public static final String UPDATE_COMMAND_LABEL = ProvUIMessages.UpdateIUCommandLabel;
    public static final String UPDATE_COMMAND_TOOLTIP = ProvUIMessages.UpdateIUCommandTooltip;
    public static final String REVERT_COMMAND_LABEL = ProvUIMessages.RevertIUCommandLabel;
    public static final String REVERT_COMMAND_TOOLTIP = ProvUIMessages.RevertIUCommandTooltip;
    public static final long SIZE_NOTAPPLICABLE = -3L;
    public static final long SIZE_UNAVAILABLE = -2L;
    public static final long SIZE_UNKNOWN = -1L;
    private static IUColumnConfig[] columnConfig;
    private static final String UPDATE_MANAGER_FIND_AND_INSTALL = "org.eclipse.ui.update.findAndInstallUpdates";
    private static final String INSTALLATION_DIALOG = "org.eclipse.ui.help.installationDialog";

    public static IStatus handleException(Throwable t, String message, int style) {
        if (message == null && t != null) {
            message = t.getMessage();
        }
        Status status = new Status(4, "org.eclipse.equinox.p2.ui", 0, message, t);
        StatusManager.getManager().handle((IStatus)status, style);
        return status;
    }

    public static void reportStatus(IStatus status, int style) {
        if ((style & 4) == 4 || (style & 2) == 2) {
            if (status.getSeverity() == 1) {
                MessageDialogWithLink dialog = new MessageDialogWithLink(ProvUI.getDefaultParentShell(), ProvUIMessages.ProvUI_InformationTitle, null, status.getMessage(), 2, 0, IDialogConstants.OK_LABEL);
                if (status.getCode() == 10000) {
                    dialog.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> ProvisioningUI.getDefaultUI().manipulateRepositories(dialog.getShell())));
                }
                dialog.open();
                style &= 0xFFFFFFFB;
                style &= 0xFFFFFFFD;
                if (status.getCode() == 10000) {
                    style = 0;
                }
            } else if (status.getSeverity() == 2) {
                MessageDialog.openWarning((Shell)ProvUI.getDefaultParentShell(), (String)ProvUIMessages.ProvUI_WarningTitle, (String)status.getMessage());
                style &= 0xFFFFFFFB;
                style &= 0xFFFFFFFD;
            }
        }
        if (style != 0) {
            StatusManager.getManager().handle(status, style);
        }
    }

    public static IUColumnConfig[] getIUColumnConfig() {
        if (columnConfig == null) {
            columnConfig = new IUColumnConfig[]{new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 60), new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 40)};
        }
        return columnConfig;
    }

    public static IUViewQueryContext getQueryContext(Policy policy) {
        IUViewQueryContext queryContext = new IUViewQueryContext(policy.getGroupByCategory() ? 1 : 3);
        queryContext.setShowInstallChildren(policy.getShowDrilldownRequirements());
        queryContext.setShowProvisioningPlanChildren(policy.getShowDrilldownRequirements());
        queryContext.setShowLatestVersionsOnly(policy.getShowLatestVersionsOnly());
        queryContext.setHideAlreadyInstalled(policy.getHideAlreadyInstalled());
        queryContext.setUseCategories(policy.getGroupByCategory());
        queryContext.setFilterOnEnv(policy.getFilterOnEnv());
        return queryContext;
    }

    public static <T> T getAdapter(Object object, Class<T> adapterType) {
        if (object == null) {
            return null;
        }
        if (adapterType.isInstance(object)) {
            return (T)object;
        }
        if (object instanceof IAdaptable) {
            return (T)((IAdaptable)object).getAdapter(adapterType);
        }
        return null;
    }

    public static Shell getDefaultParentShell() {
        return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
    }

    public static void openUpdateManagerInstaller(Event event) {
        ProvUI.runCommand(UPDATE_MANAGER_FIND_AND_INSTALL, ProvUIMessages.UpdateManagerCompatibility_UnableToOpenFindAndInstall, event);
    }

    public static void openInstallationDialog(Event event) {
        ProvUI.runCommand(INSTALLATION_DIALOG, ProvUIMessages.ProvUI_InstallDialogError, event);
    }

    public static boolean isUpdateManagerInstallerPresent() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(UPDATE_MANAGER_FIND_AND_INSTALL);
        return command.isDefined();
    }

    private static void runCommand(String commandId, String errorMessage, Event event) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(commandId);
        if (!command.isDefined()) {
            return;
        }
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand(commandId, event);
        }
        catch (ExecutionException e) {
            ProvUI.reportFail(errorMessage, e);
        }
        catch (NotDefinedException e) {
            ProvUI.reportFail(errorMessage, e);
        }
        catch (NotEnabledException e) {
            ProvUI.reportFail(errorMessage, e);
        }
        catch (NotHandledException e) {
            ProvUI.reportFail(errorMessage, e);
        }
    }

    public static boolean isCategory(IInstallableUnit iu) {
        return QueryUtil.isCategory((IInstallableUnit)iu);
    }

    private static void reportFail(String message, Throwable t) {
        Status failStatus = new Status(4, "org.eclipse.equinox.p2.ui", message, t);
        ProvUI.reportStatus((IStatus)failStatus, 5);
    }

    public static long getSize(IEngine engine, IProvisioningPlan plan, ProvisioningContext context, IProgressMonitor monitor) {
        IStatus status;
        ISizingPhaseSet sizingPhaseSet;
        if (plan == null) {
            return -3L;
        }
        if (ProvUI.countPlanElements(plan) == 0) {
            return 0L;
        }
        long installPlanSize = 0L;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        if (plan.getInstallerPlan() != null) {
            sizingPhaseSet = PhaseSetFactory.createSizingPhaseSet();
            status = engine.perform(plan.getInstallerPlan(), (IPhaseSet)sizingPhaseSet, (IProgressMonitor)mon.newChild(100));
            if (status.isOK()) {
                installPlanSize = sizingPhaseSet.getDiskSize();
            }
        } else {
            mon.worked(100);
        }
        if ((status = engine.perform(plan, (IPhaseSet)(sizingPhaseSet = PhaseSetFactory.createSizingPhaseSet()), (IProgressMonitor)mon.newChild(200))).isOK()) {
            return installPlanSize + sizingPhaseSet.getDiskSize();
        }
        return -2L;
    }

    private static int countPlanElements(IProvisioningPlan plan) {
        return QueryUtil.compoundQueryable((IQueryable)plan.getAdditions(), (IQueryable)plan.getRemovals()).query(QueryUtil.createIUAnyQuery(), null).toUnmodifiableSet().size();
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager(ProvisioningSession session) {
        return (IArtifactRepositoryManager)session.getProvisioningAgent().getService(IArtifactRepositoryManager.class);
    }

    public static IMetadataRepositoryManager getMetadataRepositoryManager(ProvisioningSession session) {
        return (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.class);
    }

    public static IProfileRegistry getProfileRegistry(ProvisioningSession session) {
        return (IProfileRegistry)session.getProvisioningAgent().getService(IProfileRegistry.class);
    }

    public static IEngine getEngine(ProvisioningSession session) {
        return (IEngine)session.getProvisioningAgent().getService(IEngine.class);
    }

    public static IProvisioningEventBus getProvisioningEventBus(ProvisioningSession session) {
        return (IProvisioningEventBus)session.getProvisioningAgent().getService(IProvisioningEventBus.class);
    }

    public static IProvisioningPlan toCompabilityWithCurrentJREProvisioningPlan(ProfileChangeOperation referenceOperation, IProgressMonitor monitor) {
        IInstallableUnit currentJREUnit = ProvUI.createCurrentJavaSEUnit();
        IProfileChangeRequest compatibilityWithCurrentRequest = ProvUI.toCurrentJREOperation(referenceOperation, currentJREUnit);
        IPlanner planner = (IPlanner)referenceOperation.getProvisioningPlan().getProfile().getProvisioningAgent().getService(IPlanner.class);
        IProvisioningPlan res = planner.getProvisioningPlan(compatibilityWithCurrentRequest, referenceOperation.getProvisioningContext(), monitor);
        return res;
    }

    private static IProfileChangeRequest toCurrentJREOperation(ProfileChangeOperation operation, IInstallableUnit currnetJREUnit) {
        IProfileChangeRequest initialRequest = operation.getProfileChangeRequest();
        if (initialRequest == null) {
            throw new IllegalStateException("operation plan must be resolved");
        }
        ProfileChangeRequest res = ((ProfileChangeRequest)initialRequest).clone();
        res.addExtraRequirements(Collections.singleton(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"a.jre.javase", null, null, (int)0, (int)0, (boolean)false)));
        operation.getProvisioningPlan().getProfile().query(QueryUtil.createIUQuery((String)"a.jre.javase"), null).forEach(arg_0 -> ((IProfileChangeRequest)res).remove(arg_0));
        res.add(currnetJREUnit);
        return res;
    }

    private static IInstallableUnit createCurrentJavaSEUnit() {
        MetadataFactory.InstallableUnitDescription desc = new MetadataFactory.InstallableUnitDescription();
        desc.setId("currently-running-execution-environement-do-not-actually-install");
        Version eeVersion = ProvUI.getCurrentJavaSEVersion();
        desc.setVersion(eeVersion);
        desc.addProvidedCapabilities(Collections.singletonList(new ProvidedCapability("org.eclipse.equinox.p2.iu", desc.getId(), eeVersion)));
        desc.addProvidedCapabilities(ProvUI.parseSystemCapabilities("org.osgi.framework.system.capabilities"));
        desc.addProvidedCapabilities(ProvUI.parseSystemCapabilities("org.osgi.framework.system.capabilities.extra"));
        desc.addProvidedCapabilities(ProvUI.toJavaPackageCapabilities("org.osgi.framework.system.packages"));
        desc.addProvidedCapabilities(ProvUI.toJavaPackageCapabilities("org.osgi.framework.system.packages.extra"));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc);
    }

    private static List<IProvidedCapability> toJavaPackageCapabilities(String systemPropertyName) {
        String packages = System.getProperty(systemPropertyName);
        if (packages != null && !packages.trim().isEmpty()) {
            try {
                return Arrays.stream(ManifestElement.parseHeader((String)systemPropertyName, (String)packages)).map(jrePackage -> {
                    String packageName = jrePackage.getValue();
                    Version packageVersion = Version.create((String)jrePackage.getAttribute("version"));
                    return MetadataFactory.createProvidedCapability((String)"java.package", (String)packageName, (Version)packageVersion);
                }).collect(Collectors.toList());
            }
            catch (BundleException e) {
                ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    private static Version getCurrentJavaSEVersion() {
        String[] segments = System.getProperty("java.version").split("\\.");
        if ("1".equals(segments[0])) {
            return Version.create((String)(String.valueOf(segments[0]) + '.' + segments[1] + ".0"));
        }
        return Version.create((String)(String.valueOf(segments[0].split("-")[0]) + ".0.0"));
    }

    static Collection<IProvidedCapability> parseSystemCapabilities(String systemProperty) {
        String systemCapabilities = System.getProperty(systemProperty);
        if (systemCapabilities == null || systemCapabilities.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return Arrays.stream(ManifestElement.parseHeader((String)systemProperty, (String)systemCapabilities)).flatMap(eeCapability -> {
                String eeName = eeCapability.getAttribute("osgi.ee");
                if (eeName == null) {
                    return Stream.empty();
                }
                return ProvUI.parseEECapabilityVersion(eeCapability).map(version -> MetadataFactory.createProvidedCapability((String)"osgi.ee", (String)eeName, (Version)version));
            }).collect(Collectors.toList());
        }
        catch (BundleException e) {
            ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e));
            return Collections.emptyList();
        }
    }

    private static Stream<Version> parseEECapabilityVersion(ManifestElement eeCapability) {
        String singleVersion = eeCapability.getAttribute("version:Version");
        String[] multipleVersions = ManifestElement.getArrayFromList((String)eeCapability.getAttribute("version:List<Version>"));
        if (singleVersion == null && multipleVersions == null) {
            return Stream.empty();
        }
        if (singleVersion == null) {
            return Arrays.stream(multipleVersions).map(Version::parseVersion);
        }
        if (multipleVersions == null) {
            return Stream.of(singleVersion).map(Version::parseVersion);
        }
        return Stream.empty();
    }
}

