/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.actions.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.ActionsPackage;
import org.eclipse.comma.actions.actions.AnyEvent;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.CommandReplyWithVars;
import org.eclipse.comma.actions.actions.EVENT_KIND;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventPattern;
import org.eclipse.comma.actions.actions.EventWithVars;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.InterfaceEventInstance;
import org.eclipse.comma.actions.actions.Multiplicity;
import org.eclipse.comma.actions.actions.PCElement;
import org.eclipse.comma.actions.actions.PCFragment;
import org.eclipse.comma.actions.actions.PCFragmentDefinition;
import org.eclipse.comma.actions.actions.ParameterizedEvent;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.actions.actions.Reply;
import org.eclipse.comma.actions.actions.VariableDeclBlock;
import org.eclipse.comma.actions.utilities.ActionsUtilities;
import org.eclipse.comma.actions.validation.AbstractActionsValidator;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Field;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ActionsValidator
extends AbstractActionsValidator {
    public static final String REPLY_WRONG_NUMBER_PARAMS = "trigger_remove_param";
    public static final String REPLY_INVALID_TYPE = "trigger_invalid_type";
    public static final String STATEMACHINE_DUPLICATE_VAR = "statemachine_duplicate_var";

    @Check
    public void checkTypingAssignment(AssignmentAction act) {
        boolean _subTypeOf;
        boolean _not;
        Expression _exp = null;
        if (act != null) {
            _exp = act.getExp();
        }
        TypeObject _typeOf = null;
        if (_exp != null) {
            _typeOf = this.typeOf(_exp);
        }
        TypeObject t = _typeOf;
        Variable _assignment = act.getAssignment();
        Type _type = null;
        if (_assignment != null) {
            _type = _assignment.getType();
        }
        boolean bl = _not = !(_subTypeOf = this.subTypeOf(t, TypeUtilities.getTypeObject((Type)_type)));
        if (_not) {
            this.error("Type mismatch: actual type does not match the expected type", (EStructuralFeature)ActionsPackage.Literals.ASSIGNMENT_ACTION__EXP);
        }
    }

    @Check
    public void checkTypingFieldAssignment(RecordFieldAssignmentAction act) {
        boolean _subTypeOf;
        boolean _not;
        Expression _exp = act.getExp();
        TypeObject _typeOf = null;
        if (_exp != null) {
            _typeOf = this.typeOf(_exp);
        }
        TypeObject t = _typeOf;
        Expression _fieldAccess = act.getFieldAccess();
        TypeObject _typeOf_1 = null;
        if (_fieldAccess != null) {
            _typeOf_1 = this.typeOf(_fieldAccess);
        }
        boolean bl = _not = !(_subTypeOf = this.subTypeOf(t, _typeOf_1));
        if (_not) {
            this.error("Type mismatch: actual type does not match the expected type", (EStructuralFeature)ActionsPackage.Literals.RECORD_FIELD_ASSIGNMENT_ACTION__EXP);
        }
    }

    @Check
    public void checkTypingIfAction(IfAction act) {
        TypeObject t;
        boolean _subTypeOf;
        boolean _not;
        Expression _guard = act.getGuard();
        TypeObject _typeOf = null;
        if (_guard != null) {
            _typeOf = this.typeOf(_guard);
        }
        boolean bl = _not = !(_subTypeOf = this.subTypeOf(t = _typeOf, (TypeObject)this.boolType));
        if (_not) {
            this.error("Type mismatch: the type of the condition must be boolean", (EStructuralFeature)ActionsPackage.Literals.IF_ACTION__GUARD);
        }
    }

    @Check
    public void checkTypingActionWithVars(ActionWithVars act) {
        boolean _not;
        boolean _tripleEquals;
        Expression _condition = act.getCondition();
        boolean bl = _tripleEquals = _condition == null;
        if (_tripleEquals) {
            return;
        }
        TypeObject t = this.typeOf(act.getCondition());
        boolean _subTypeOf = this.subTypeOf(t, (TypeObject)this.boolType);
        boolean bl2 = _not = !_subTypeOf;
        if (_not) {
            this.error("Type mismatch: the type of the condition must be boolean", (EStructuralFeature)ActionsPackage.Literals.ACTION_WITH_VARS__CONDITION);
        }
    }

    @Check
    public void checkDuplicatesActionWithVars(ActionWithVars act) {
        this.checkForNameDuplications((Iterable)act.getParameters(), "variable", null, new String[0]);
    }

    @Check
    public void checkUsageAnyValue(ExpressionAny exp) {
        EObject parent = exp.eContainer();
        boolean problemFound = false;
        while (parent != null && !(parent instanceof ParameterizedEvent) && !problemFound) {
            if (!(parent instanceof Field) && !(parent instanceof ExpressionRecord)) {
                problemFound = true;
            }
            parent = parent.eContainer();
        }
        if (problemFound || parent == null) {
            this.error("Expression * cannot be used in this context", exp.eContainer(), exp.eContainingFeature());
        }
    }

    @Check
    public void checkEventInstanceParameters(InterfaceEventInstance ev) {
        if (!(ev instanceof EventPattern) || !ev.getParameters().isEmpty()) {
            boolean _notEquals;
            Object _xifexpression = null;
            InterfaceEvent _event = ev.getEvent();
            if (_event instanceof Command) {
                Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter p) {
                        DIRECTION _direction = p.getDirection();
                        return _direction != DIRECTION.OUT;
                    }
                };
                _xifexpression = IterableExtensions.filter((Iterable)ev.getEvent().getParameters(), (Functions.Function1)_function);
            } else {
                _xifexpression = ev.getEvent().getParameters();
            }
            EList parameters = _xifexpression;
            int _size = ev.getParameters().size();
            int _size_1 = IterableExtensions.size((Iterable)parameters);
            boolean bl = _notEquals = _size != _size_1;
            if (_notEquals) {
                this.error("The number of parameters does not match.", ev, (EStructuralFeature)ActionsPackage.Literals.PARAMETERIZED_EVENT__PARAMETERS);
                return;
            }
            int _size_2 = ev.getParameters().size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_2, true);
            for (Integer i : _doubleDotLessThan) {
                boolean _not;
                TypeObject t = this.typeOf((Expression)ev.getParameters().get(i.intValue()));
                boolean _subTypeOf = this.subTypeOf(t, TypeUtilities.getTypeObject((Type)((Parameter[])Conversions.unwrapArray((Object)parameters, Parameter.class))[i].getType()));
                boolean bl2 = _not = !_subTypeOf;
                if (!_not) continue;
                this.error("The type of the expression must match the type in the signature.", ev, (EStructuralFeature)ActionsPackage.Literals.PARAMETERIZED_EVENT__PARAMETERS, i);
            }
        }
    }

    @Check
    public void checkEventWithVarsParameters(EventWithVars ev) {
        boolean _notEquals;
        Object _xifexpression = null;
        InterfaceEvent _event = ev.getEvent();
        if (_event instanceof Command) {
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter p) {
                    DIRECTION _direction = p.getDirection();
                    return _direction != DIRECTION.OUT;
                }
            };
            _xifexpression = IterableExtensions.filter((Iterable)ev.getEvent().getParameters(), (Functions.Function1)_function);
        } else {
            _xifexpression = ev.getEvent().getParameters();
        }
        EList parameters = _xifexpression;
        int _size = ev.getParameters().size();
        int _size_1 = IterableExtensions.size((Iterable)parameters);
        boolean bl = _notEquals = _size != _size_1;
        if (_notEquals) {
            int _size_2 = IterableExtensions.size((Iterable)parameters);
            String _plus = "Wrong number of parameters. Expected " + Integer.valueOf(_size_2);
            String _plus_1 = String.valueOf(_plus) + " parameters.";
            this.error(_plus_1, ev, (EStructuralFeature)ActionsPackage.Literals.ACTION_WITH_VARS__PARAMETERS);
            return;
        }
        int _size_3 = ev.getParameters().size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_3, true);
        for (Integer i : _doubleDotLessThan) {
            boolean _not;
            TypeObject t = TypeUtilities.getTypeObject((Type)((Variable)ev.getParameters().get(i.intValue())).getType());
            boolean _identical = this.identical(t, TypeUtilities.getTypeObject((Type)((Parameter[])Conversions.unwrapArray((Object)parameters, Parameter.class))[i].getType()));
            boolean bl2 = _not = !_identical;
            if (!_not) continue;
            this.error("The type of the variable must be the same as the type in the signature.", ev, (EStructuralFeature)ActionsPackage.Literals.ACTION_WITH_VARS__PARAMETERS, i);
        }
    }

    public void checkReplyAgainstCommand(Command c, Reply r) {
        boolean _notEquals;
        boolean _not;
        ArrayList<TypeObject> expectedTypes = new ArrayList<TypeObject>();
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter p) {
                DIRECTION _direction = p.getDirection();
                return !Objects.equal((Object)_direction, (Object)DIRECTION.IN);
            }
        };
        Iterable outParams = IterableExtensions.filter((Iterable)c.getParameters(), (Functions.Function1)_function);
        for (Parameter p : outParams) {
            expectedTypes.add(TypeUtilities.getTypeObject((Type)p.getType()));
        }
        boolean _isVoid = TypeUtilities.isVoid((Type)c.getType());
        boolean bl = _not = !_isVoid;
        if (_not) {
            expectedTypes.add(TypeUtilities.getTypeObject((Type)c.getType()));
        }
        List _xifexpression = null;
        if (r instanceof CommandReply) {
            Functions.Function1<Expression, TypeObject> _function_1 = new Functions.Function1<Expression, TypeObject>(){

                public TypeObject apply(Expression it) {
                    return ActionsValidator.this.typeOf(it);
                }
            };
            _xifexpression = ListExtensions.map((List)((CommandReply)r).getParameters(), (Functions.Function1)_function_1);
        } else {
            Functions.Function1<Variable, TypeObject> _function_2 = new Functions.Function1<Variable, TypeObject>(){

                public TypeObject apply(Variable it) {
                    return TypeUtilities.getTypeObject((Type)it.getType());
                }
            };
            _xifexpression = ListExtensions.map((List)((CommandReplyWithVars)r).getParameters(), (Functions.Function1)_function_2);
        }
        List actualTypes = _xifexpression;
        int _size = expectedTypes.size();
        int _size_1 = actualTypes.size();
        boolean bl2 = _notEquals = _size != _size_1;
        if (_notEquals) {
            if (r instanceof CommandReply) {
                this.error("Wrong number of values in reply.", r, (EStructuralFeature)ActionsPackage.Literals.PARAMETERIZED_EVENT__PARAMETERS, REPLY_WRONG_NUMBER_PARAMS, null);
            } else {
                this.error("Wrong number of values in reply.", r, (EStructuralFeature)ActionsPackage.Literals.ACTION_WITH_VARS__PARAMETERS);
            }
            return;
        }
        int _size_2 = expectedTypes.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_2, true);
        for (Integer i : _doubleDotLessThan) {
            boolean _not_1;
            boolean _subTypeOf = this.subTypeOf((TypeObject)actualTypes.get(i), (TypeObject)expectedTypes.get(i));
            boolean bl3 = _not_1 = !_subTypeOf;
            if (!_not_1) continue;
            if (r instanceof CommandReply) {
                this.error("The type of the value must match the return type of the command or inout/out parameter type.", r, (EStructuralFeature)ActionsPackage.Literals.PARAMETERIZED_EVENT__PARAMETERS, i, REPLY_INVALID_TYPE, null);
                continue;
            }
            this.error("The type of the variable must be the same as the return type of the command or inout/out parameter type.", r, (EStructuralFeature)ActionsPackage.Literals.ACTION_WITH_VARS__PARAMETERS, i);
        }
    }

    @Check
    public void checkDuplicateVariables(VariableDeclBlock db) {
        this.checkForNameDuplications((Iterable)db.getVars(), "variable", STATEMACHINE_DUPLICATE_VAR, null);
    }

    @Check
    public void checkNotInitializedVariables(VariableDeclBlock db) {
        boolean _greaterThan;
        int _size = db.getVars().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            ArrayList<Variable> variables = new ArrayList<Variable>();
            variables.addAll((Collection<Variable>)db.getVars());
            Functions.Function1<AssignmentAction, Variable> _function = new Functions.Function1<AssignmentAction, Variable>(){

                public Variable apply(AssignmentAction it) {
                    return it.getAssignment();
                }
            };
            Iterable usedVariables = IterableExtensions.map((Iterable)Iterables.filter(db.getInitActions(), AssignmentAction.class), (Functions.Function1)_function);
            CollectionExtensions.removeAll(variables, (Iterable)usedVariables);
            Consumer<Variable> _function_1 = new Consumer<Variable>(){

                @Override
                public void accept(Variable it) {
                    ActionsValidator.this.warning("Uninitialized variable.", (EObject)it, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
                }
            };
            variables.forEach(_function_1);
        }
    }

    @Check
    public void checkMultiplicity(Multiplicity m) {
        boolean _equals;
        boolean _tripleNotEquals;
        String _upperInf = m.getUpperInf();
        boolean bl = _tripleNotEquals = _upperInf != null;
        if (_tripleNotEquals) {
            return;
        }
        long _upper = m.getUpper();
        boolean bl2 = _equals = _upper == 0L;
        if (_equals) {
            this.error("Upper bound cannot be 0", (EStructuralFeature)ActionsPackage.Literals.MULTIPLICITY__UPPER);
        } else {
            long _upper_1;
            boolean _greaterThan;
            long _lower = m.getLower();
            boolean bl3 = _greaterThan = _lower > (_upper_1 = m.getUpper());
            if (_greaterThan) {
                this.error("Lower bound cannot be greater than the upper bound", (EStructuralFeature)ActionsPackage.Literals.MULTIPLICITY__LOWER);
            }
        }
    }

    @Check
    public void checkFragmentRefCircularity(final PCFragmentDefinition fd) {
        HashSet<PCFragmentDefinition> _hashSet = new HashSet<PCFragmentDefinition>();
        HashSet<PCFragmentDefinition> referencedFragments = ActionsUtilities.allReferencedFragments(fd, _hashSet);
        boolean _contains = referencedFragments.contains(fd);
        if (_contains) {
            this.error("Circular reference chain", (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
        Consumer<CommandReply> _function = new Consumer<CommandReply>(){

            @Override
            public void accept(CommandReply it) {
                ActionsValidator.this.error("Fragment definition cannot contain replies", (EStructuralFeature)ActionsPackage.Literals.PC_FRAGMENT__COMPONENTS, fd.getComponents().indexOf((Object)it));
            }
        };
        Iterables.filter(fd.getComponents(), CommandReply.class).forEach(_function);
    }

    @Check
    public void checkParallelComposition(PCFragment pc) {
        boolean _greaterThan;
        List<Action> actions = ActionsUtilities.flatten(pc);
        EObject parent = pc.eContainer();
        Object _eGet = parent.eGet(pc.eContainingFeature());
        int index = ((List)_eGet).indexOf(pc);
        int _size = actions.size();
        int _minus = _size - 1;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus, true);
        for (Integer i : _doubleDotLessThan) {
            int _size_1 = actions.size();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(i + 1, _size_1, true);
            for (Integer j : _doubleDotLessThan_1) {
                Action _get;
                boolean _overlaps;
                Action current = actions.get(i);
                if (!(current instanceof EventCall) || !(_overlaps = ActionsUtilities.overlaps((EventCall)current, (PCElement)((Object)(_get = actions.get(j)))))) continue;
                this.error("Parallel composition contains overlapping events", parent, pc.eContainingFeature(), index);
            }
        }
        int _size_2 = IterableExtensions.size((Iterable)Iterables.filter(actions, CommandReply.class));
        boolean bl = _greaterThan = _size_2 > 1;
        if (_greaterThan) {
            this.error("Parallel composition contains more than one reply", parent, pc.eContainingFeature(), index);
        }
    }

    @Check
    public void checkAnyEvent(AnyEvent ev) {
        boolean _tripleNotEquals;
        ExpressionVariable _nameVar = ev.getNameVar();
        boolean bl = _tripleNotEquals = _nameVar != null;
        if (_tripleNotEquals) {
            boolean _subTypeOf;
            boolean _not;
            EVENT_KIND _kind = ev.getKind();
            boolean _equals = Objects.equal((Object)((Object)_kind), (Object)((Object)EVENT_KIND.EVENT));
            if (_equals) {
                this.error("Event name variable cannot be used in 'any event' construct", ev, (EStructuralFeature)ActionsPackage.Literals.ANY_EVENT__NAME_VAR);
            }
            boolean bl2 = _not = !(_subTypeOf = this.subTypeOf(TypeUtilities.getTypeObject((Type)ev.getNameVar().getVariable().getType()), (TypeObject)this.stringType));
            if (_not) {
                this.error("Event name variable must be of type string", ev, (EStructuralFeature)ActionsPackage.Literals.ANY_EVENT__NAME_VAR);
            }
        }
    }
}

