/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.propertytester;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.util.StatusUtil;

public class IsDartProjectPropertyTester
extends PropertyTester {
    private static final ILog LOG = Platform.getLog(IsDartProjectPropertyTester.class);
    private static final String IS_DART_PROJECT_PROPERTY = "isDartProject";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!IS_DART_PROJECT_PROPERTY.equals(property)) return false;
        IResource resource = (IResource)Adapters.adapt((Object)receiver, IResource.class);
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        if (project.findMember("pubspec.yaml") != null) {
            return true;
        }
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource res = iResourceArray[n2];
                if ("dart".equals(res.getFileExtension())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LOG.log(StatusUtil.createError("Couldn't list members of project " + project.getName(), e));
        }
        return false;
    }
}

