/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.Messages;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseRoutine;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.core.DataTypeProvider;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.IDatabaseSetting;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.routineeditor.ui.ProcEditorInput;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLDataType;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.datatools.sqltools.sql.reference.DBObject;
import org.eclipse.datatools.sqltools.sql.reference.IDatatype;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;

public class SQLUtil {
    public static final int TYPE_MUTIL_RECORDS = 0;
    public static final int TYPE_XML_RESULT = 1;
    public static final int NO_QUOTES = 0;
    public static final int MATCHING_SINGLE_QUOTES = 1;
    public static final int MATCHING_DOUBLE_QUOTES = 2;
    public static final int NO_MATCHING_QUOTES = 3;
    private static String _sql;
    private static String[] _allCurrencySymbols;
    private static Pattern ID_PATTERN;
    private static Pattern STRING_PATTERN;
    public static int MAX_NAME_LENGTH_FOR_MESSAGE_DIALOGS;
    private static ILog _log;

    static {
        ID_PATTERN = Pattern.compile("((\\Q[\\E([^\"]|(\"\"))+\\Q]\\E|[^\\s\"\\Q.\\E]+|\"([^\"]|(\"\"))+\")\\Q.\\E?)");
        STRING_PATTERN = Pattern.compile("(([^\\s']+)|('([^']|(''))+'))");
        MAX_NAME_LENGTH_FOR_MESSAGE_DIALOGS = 30;
        _log = ExamplePlugin.getDefault().getLog();
    }

    public static String[] parseDatabaseObject(String objstr) {
        ArrayList<String> ids = new ArrayList<String>();
        Matcher m = ID_PATTERN.matcher(objstr);
        while (m.find()) {
            ids.add(0, SQLUtil.unquote(m.group(2)));
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static boolean equals(int parserType, int procType, String objstr, String defDB, String defOwner, ProcIdentifier proc, boolean caseSensitive) {
        String objname;
        if (!SQLUtil.isSameType(parserType, procType)) {
            return false;
        }
        String[] tokens = SQLUtil.parseDatabaseObject(objstr);
        int count = tokens.length;
        if (count == 0 || count > 3) {
            return false;
        }
        if (parserType == 160 || parserType == 60) {
            defOwner = proc.getOwnerName();
        }
        String db = count == 3 ? tokens[2] : defDB;
        String owner = count >= 2 ? tokens[1] : proc.getOwnerName();
        String string = objname = count >= 1 ? tokens[0] : objstr;
        return SQLUtil.equalsIgnoreQuote(proc.getDatabaseIdentifier().getDBname(), db, caseSensitive) && SQLUtil.equalsIgnoreQuote(proc.getOwnerName(), owner, caseSensitive) && SQLUtil.equalsIgnoreQuote(proc.getProcName(), objname, caseSensitive);
    }

    public static boolean equalsIgnoreQuote(String s1, String s2, boolean caseSensitive) {
        if (caseSensitive) {
            boolean e = s1.equals(s2);
            if (!e) {
                s1 = SQLUtil.unquote(s1);
                s2 = SQLUtil.unquote(s2);
                e = s1.equals(s2);
            }
            return e;
        }
        boolean e = s1.equalsIgnoreCase(s2);
        if (!e) {
            if (s1.equals(SQLUtil.unquote(s2)) || s2.equals(SQLUtil.unquote(s1))) {
                return true;
            }
            s1 = SQLUtil.unquote(s1);
            s2 = SQLUtil.unquote(s2);
            e = s1.equalsIgnoreCase(s2);
        }
        return e;
    }

    public static boolean isSameType(int parserType, int procType) {
        boolean same = (parserType == 158 || parserType == 58) && procType == 0;
        same = same || (parserType == 159 || parserType == 59) && procType == 1;
        same = same || (parserType == 160 || parserType == 60) && procType == 2;
        same = same || (parserType == 161 || parserType == 61) && procType == 3;
        return same;
    }

    public static ParameterDescriptor[] getParameterDescriptors(DatabaseIdentifier databaseIdentifier, Connection connection, int type, ProcIdentifier proc) throws SQLException {
        ParameterDescriptor[] parameterDescriptorArray;
        block30: {
            ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
            SQLObject sqlObj = ModelUtil.findProceduralObject((ProcIdentifier)proc);
            if (sqlObj instanceof SybaseRoutine) {
                SybaseRoutine routine = (SybaseRoutine)sqlObj;
                Database db = ModelUtil.getDatabase((Schema)routine.getSchema());
                ModelUtil.getSchemas((Database)db, (String)databaseIdentifier.getDBname());
                DatabaseDefinition dbdef = ModelUtil.getDatabaseDefinition((SQLObject)sqlObj);
                routine.getParameters();
                routine.parseParameterDefaultValues();
                ParameterDescriptor returnColumn = new ParameterDescriptor(databaseIdentifier, "RETURN_VALUE", 5, 4, 0, 0, "INT", 0, "procedureColumnReturn");
                parameters.add(returnColumn);
                for (SybaseParameter param : routine.getParameters()) {
                    String dft;
                    DataTypeProvider provider = SQLToolsFacade.getConfiguration((DatabaseIdentifier)databaseIdentifier, (DatabaseVendorDefinitionId)new DatabaseVendorDefinitionId(dbdef.getProduct(), dbdef.getVersion())).getSQLDataService().getDataTypeProvider();
                    String typeName = provider.getDataTypeString(param.getDataType(), false);
                    int paramType = param.getJDBCParameterType().getValue();
                    int precision = 0;
                    short scale = 0;
                    int jdbcType = 0;
                    SQLDataType dataType = param.getContainedType();
                    if (dataType != null) {
                        Object l;
                        EStructuralFeature feature;
                        PredefinedDataTypeDefinition typeDefinition = dbdef.getPredefinedDataTypeDefinition(dataType.getName());
                        jdbcType = typeDefinition.getJdbcEnumType();
                        if (typeDefinition.isLengthSupported()) {
                            feature = dataType.eClass().getEStructuralFeature("length");
                            l = dataType.eGet(feature);
                            if (l instanceof Integer) {
                                precision = (Integer)l;
                            }
                        } else if (typeDefinition.isPrecisionSupported() && (l = dataType.eGet(feature = dataType.eClass().getEStructuralFeature("precision"))) instanceof Integer) {
                            precision = (Integer)l;
                        }
                        if (typeDefinition.isScaleSupported() && (l = dataType.eGet(feature = dataType.eClass().getEStructuralFeature("scale"))) instanceof Integer) {
                            scale = (short)((Integer)l).intValue();
                        }
                    } else {
                        UserDefinedType udt = param.getReferencedType();
                        if (udt != null && udt instanceof DistinctUserDefinedType) {
                            PredefinedDataType predefinedRepresentation = ((DistinctUserDefinedType)udt).getPredefinedRepresentation();
                            PredefinedDataTypeDefinition typeDefinition = dbdef.getPredefinedDataTypeDefinition(predefinedRepresentation.getName());
                            jdbcType = typeDefinition.getJdbcEnumType();
                        }
                    }
                    if ((dft = param.getDefaultValue()) != null) {
                        dft = SQLUtil.unquote(dft);
                    }
                    ParameterDescriptor p = new ParameterDescriptor(databaseIdentifier, param.getName(), paramType, jdbcType, precision, scale, typeName, (short)(param.isNullable() ? 1 : 0), param.getDescription());
                    p.setDefaultValue(dft);
                    parameters.add(p);
                }
                return parameters.toArray(new ParameterDescriptor[0]);
            }
            DatabaseMetaData md = null;
            ResultSet rs = null;
            try {
                md = connection.getMetaData();
                String dbname = proc.getDatabaseIdentifier().getDBname();
                if (dbname != null && dbname.length() == 0) {
                    dbname = null;
                }
                rs = md.getProcedureColumns(dbname, proc.getOwnerName(), proc.getProcName(), "%");
                while (rs.next()) {
                    String name = rs.getString(4);
                    short parmType = rs.getShort(5);
                    int sqlDataType = rs.getShort(6);
                    String dataTypeName = rs.getString(7);
                    if (dataTypeName.equalsIgnoreCase("double") && sqlDataType == 0) {
                        sqlDataType = 8;
                    }
                    int precision = rs.getInt(8);
                    rs.getInt(9);
                    short scale = rs.getShort(10);
                    rs.getShort(11);
                    short nullable = rs.getShort(12);
                    String comment = rs.getString(13);
                    switch (sqlDataType) {
                        case 2: 
                        case 3: {
                            if ("money".equalsIgnoreCase(dataTypeName) || "smallmoney".equalsIgnoreCase(dataTypeName)) break;
                            dataTypeName = String.valueOf(dataTypeName) + "(" + precision + "," + scale + ")";
                            break;
                        }
                        case -3: 
                        case -2: 
                        case 1: 
                        case 6: 
                        case 12: {
                            dataTypeName = String.valueOf(dataTypeName) + "(" + precision + ")";
                        }
                    }
                    ParameterDescriptor p = new ParameterDescriptor(databaseIdentifier, name, (int)parmType, sqlDataType, precision, scale, dataTypeName, nullable, comment);
                    parameters.add(p);
                }
                parameterDescriptorArray = parameters.toArray(new ParameterDescriptor[0]);
                if (rs == null) break block30;
            }
            catch (Throwable throwable) {
                block32: {
                    if (rs != null) {
                        try {
                            try {
                                rs.close();
                            }
                            catch (SQLException sQLException) {
                                rs = null;
                                break block32;
                            }
                        }
                        catch (Throwable throwable2) {
                            rs = null;
                            throw throwable2;
                        }
                        rs = null;
                    }
                }
                throw throwable;
            }
            try {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    rs = null;
                }
            }
            finally {
                rs = null;
            }
        }
        return parameterDescriptorArray;
    }

    public static String[] getEventParameters(ProcIdentifier proc) throws SQLException, NoSuchProfileException {
        String[] ps = new String[]{};
        if (proc == null || proc.getProcName() == null || proc.getProcName().trim().length() == 0) {
            return ps;
        }
        String eventName = proc.getProcName();
        if (eventName.indexOf(46) >= 0) {
            eventName = eventName.substring(eventName.lastIndexOf(46) + 1);
        }
        String text = null;
        IControlConnection controlconnection = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(proc.getDatabaseIdentifier());
        text = controlconnection.getProcSource(proc);
        if (text == null) {
            return ps;
        }
        SQLParser parser = SQLToolsFacade.getSQLParser((String)proc.getDatabaseIdentifier().getProfileName(), (String)"");
        ParsingResult result = parser.parse(text, new ParserParameters(false));
        ps = result.getEntries("__eventparameters");
        if (ps != null) {
            int i = 0;
            while (i < ps.length) {
                if (ps[i] != null && ps[i].length() > 1 && ps[i].charAt(0) == '\'' && ps[i].charAt(ps[i].length() - 1) == '\'') {
                    ps[i] = ps[i].substring(1, ps[i].length() - 1);
                }
                ++i;
            }
            return ps;
        }
        return ps;
    }

    public static String getCallablePrefix(int type) {
        String prefix = "";
        switch (type) {
            case 0: {
                prefix = "exec ";
                break;
            }
            case 1: {
                prefix = "select ";
                break;
            }
            case 2: {
                prefix = "TRIGGER EVENT ";
            }
        }
        return prefix;
    }

    public static String getCallableStatementPrefix(int type) {
        String prefix = "";
        switch (type) {
            case 0: {
                prefix = "call ";
                break;
            }
            case 1: {
                prefix = "select ";
                break;
            }
            case 2: {
                prefix = "TRIGGER EVENT ";
            }
        }
        return prefix;
    }

    public static String constructDetailCALLSPUDFString(ProcIdentifier proc, List values, ParameterDescriptor[] pds, boolean quoted_id) {
        StringBuffer buffer;
        block10: {
            buffer = new StringBuffer(20);
            int type = proc == null ? 0 : proc.getType();
            buffer.append(SQLUtil.getCallableStatementPrefix(type));
            String LINESEPARATOR = System.getProperty("line.separator");
            String procName = null;
            if (proc != null) {
                buffer.append(proc.getCallableString(quoted_id));
                procName = proc.getProcName();
            }
            if (pds == null || pds.length <= 0) break block10;
            if (type == 1 || type == 0) {
                buffer.append("(");
            }
            int j = 0;
            int k = 0;
            int i = 0;
            while (i < pds.length) {
                block12: {
                    String prefix;
                    String name;
                    block11: {
                        name = pds[i].getName();
                        prefix = "";
                        if (pds[i].getParmType() != 1 && pds[i].getParmType() != 2) break block11;
                        String value = null;
                        if (values != null && values.size() >= k + 1) {
                            value = (String)values.get(k++);
                        }
                        if (name.equals(procName)) break block12;
                        if (value != null && pds[i].isStringType()) {
                            value = SQLUtil.quote(value, "'");
                        }
                        prefix = j != 0 ? "," : "";
                        buffer.append(String.valueOf(prefix) + LINESEPARATOR + "     " + pds[i].getName() + "=" + value + " " + pds[i].getTypeName() + " " + pds[i].getParamTypeAsString());
                        ++j;
                    }
                    if (!(pds[i].getParmType() != 4 && pds[i].getParmType() != 0 || name.equals(procName))) {
                        String paramType = "OUT";
                        prefix = j != 0 ? "," : "";
                        buffer.append(String.valueOf(prefix) + LINESEPARATOR + "     " + pds[i].getName() + " " + pds[i].getTypeName() + " " + paramType);
                        ++j;
                    }
                }
                ++i;
            }
            if (type == 1 || type == 0) {
                buffer.append(")");
            }
        }
        return buffer.toString();
    }

    public static String constructSPUDFString(ProcIdentifier proc, List values, ParameterDescriptor[] pds, boolean quoted_id) {
        StringBuffer buffer = new StringBuffer(20);
        int type = proc == null ? 0 : proc.getType();
        buffer.append(SQLUtil.getCallablePrefix(type));
        if (proc != null) {
            buffer.append(proc.getCallableString(quoted_id));
        }
        buffer.append(" ");
        if (type == 1) {
            buffer.append("(");
        }
        if (pds != null && pds.length > 0) {
            int i = 0;
            while (i < pds.length) {
                if (i != 0) {
                    buffer.append(", ");
                }
                if (values == null || values.size() <= i || values.get(i) == null) {
                    buffer.append("null");
                } else if (pds[i].isStringType() && SQLUtil.findQuotes(values.get(i).toString()) == 0) {
                    buffer.append(SQLUtil.quote((String)values.get(i), '\''));
                } else {
                    buffer.append(values.get(i));
                }
                ++i;
            }
        }
        if (type == 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static String quote(String in, char quoteChar) {
        StringBuffer buffer = new StringBuffer(in.length() + 8);
        buffer.append(quoteChar);
        int len = in.length();
        int i = 0;
        while (i < len) {
            char c = in.charAt(i);
            if (c == quoteChar) {
                buffer.append(c);
            }
            buffer.append(c);
            ++i;
        }
        buffer.append(quoteChar);
        return buffer.toString();
    }

    public static String constructTriggerEventString(ProcIdentifier proc, Map values, boolean quoted_id) {
        StringBuffer sb = new StringBuffer("TRIGGER EVENT ");
        if (proc != null) {
            sb.append(SQLUtil.quoteWhenNecessary(proc.getProcName(), proc.getDatabaseIdentifier()));
        }
        if (values != null && values.size() > 0) {
            sb.append("(");
            for (String name : values.keySet()) {
                String value = (String)values.get(name);
                sb.append("\"" + name + "\"").append("=").append("'" + value + "'").append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        }
        return sb.toString();
    }

    public static boolean justWarnings(SQLException sqlexception) {
        do {
            if (sqlexception instanceof SQLWarning) continue;
            return false;
        } while ((sqlexception = sqlexception.getNextException()) != null);
        return true;
    }

    public static void saveResultToStream(ObjectOutputStream oos, Object result) throws IOException {
        if (oos != null) {
            oos.writeObject(result);
            oos.flush();
        }
    }

    public static Map getSPParamDefaultValues(DatabaseIdentifier databaseIdentifier, String sp) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap params = SQLUtil.getSPParams(databaseIdentifier, sp);
        for (String name : params.keySet()) {
            String value;
            IASTSQLParam param = (IASTSQLParam)params.get(name);
            if (param.getDefaultValue() == null || (value = param.getDefaultValue()) != null && value.equalsIgnoreCase("null")) continue;
            map.put(name, value);
        }
        return map;
    }

    public static Map getSPParamTypeNameMapFromParser(DatabaseIdentifier databaseIdentifier, String sp) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap params = SQLUtil.getSPParams(databaseIdentifier, sp);
        for (String name : params.keySet()) {
            IASTSQLParam param = (IASTSQLParam)params.get(name);
            String type = param.getType();
            map.put(name, type);
        }
        return map;
    }

    public static HashMap getSPParams(DatabaseIdentifier databaseIdentifier, String sp) {
        new HashMap();
        SQLParser parser = SQLToolsFacade.getSQLParser((String)databaseIdentifier.getProfileName(), (String)"");
        Document doc = new Document(sp);
        ParsingResult result = parser.parse(sp, new ParserParameters(false));
        HashMap params = result.getParameters((IDocument)doc, doc.getLength() - 1);
        return params;
    }

    public static int convert2SQLType(String typeName) {
        if (typeName == null) {
            return 0;
        }
        String name = typeName.toUpperCase();
        if (name.equals("BIGINT") || name.equals("UNSIGNED BIGINT")) {
            return -5;
        }
        if (name.equals("BINARY") || name.equals("UNIQUEIDENTIFIER")) {
            return -2;
        }
        if (name.equals("BIT")) {
            return -7;
        }
        if (name.equals("BLOB")) {
            return 2004;
        }
        if (name.equals("BOOLEAN") || name.equals("BOOL")) {
            return 16;
        }
        if (name.equals("CHAR") || name.equals("CHARACTER") || name.equals("NCHAR") || name.equals("NATIONAL CHARACTER") || name.equals("NATIONAL CHAR") || name.equals("NCHAR") || name.equals("SYSNAME") || name.equals("UNICHAR") || name.equals("UNIQUEIDENTIFIERSTR")) {
            return 1;
        }
        if (name.equals("CLOB")) {
            return 2005;
        }
        if (name.equals("DATALINK")) {
            return 70;
        }
        if (name.equals("DATE")) {
            return 91;
        }
        if (name.equals("DECIMAL") || name.equals("DEC") || name.equals("MONEY") || name.equals("SMALLMONEY")) {
            return 3;
        }
        if (name.equals("DISTINCT")) {
            return 2001;
        }
        if (name.equals("DOUBLE") || name.equals("DOUBLE PRECISION")) {
            return 8;
        }
        if (name.equals("FLOAT")) {
            return 6;
        }
        if (name.equals("INTEGER") || name.equals("INT") || name.equals("UNSIGNED INTEGER") || name.equals("UNSIGNED INT")) {
            return 4;
        }
        if (name.equals("JAVA_OBJECT")) {
            return 2000;
        }
        if (name.equals("LONGVARBINARY") || name.equals("IMAGE") || name.equals("XML")) {
            return -4;
        }
        if (name.equals("LONGVARCHAR") || name.equals("LONG VARCHAR") || name.equals("TEXT")) {
            return -1;
        }
        if (name.equals("NULL")) {
            return 0;
        }
        if (name.equals("NUMERIC")) {
            return 2;
        }
        if (name.equals("OTHER")) {
            return 1111;
        }
        if (name.equals("REAL")) {
            return 7;
        }
        if (name.equals("REF")) {
            return 2006;
        }
        if (name.equals("SMALLINT")) {
            return 5;
        }
        if (name.equals("STRUCT")) {
            return 2002;
        }
        if (name.equals("TIME")) {
            return 92;
        }
        if (name.equals("TIMESTAMP") || name.equals("DATETIME") || name.equals("SMALLDATETIME")) {
            return 93;
        }
        if (name.equals("TINYINT")) {
            return -6;
        }
        if (name.equals("VARBINARY") || name.equals("UNITEXT")) {
            return -3;
        }
        if (name.equals("VARCHAR") || name.equals("NVARCHAR") || name.equals("UNIVARCHAR") || name.indexOf("CHAR") > 0 && name.indexOf("VARYING") > 0) {
            return 12;
        }
        return 0;
    }

    public static int getDefaultPrecision(int sqlType) {
        switch (sqlType) {
            case -5: {
                return 10;
            }
            case -2: {
                return 1;
            }
            case -7: {
                return 1;
            }
            case 2004: {
                return 10;
            }
            case 16: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 91: {
                return 10;
            }
            case 3: {
                return 30;
            }
            case 8: {
                return 15;
            }
            case 6: {
                return 10;
            }
            case 4: {
                return 10;
            }
            case 2: {
                return 10;
            }
            case 1111: {
                return 10;
            }
            case 7: {
                return 7;
            }
            case 5: {
                return 5;
            }
            case 92: {
                return 10;
            }
            case 93: {
                return 23;
            }
            case -6: {
                return 3;
            }
            case 12: {
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int getDefaultScale(int sqlType) {
        switch (sqlType) {
            case 92: 
            case 93: {
                return 3;
            }
        }
        return 0;
    }

    private static String escape(String s) {
        StringBuffer stringbuffer = new StringBuffer(s.length() + 16);
        int j = s.length();
        int i = 0;
        while (i < j) {
            char c = s.charAt(i);
            if (c == '\'') {
                stringbuffer.append("''");
            } else {
                stringbuffer.append(c);
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static int getSQLType(ProcIdentifier procId) {
        int procType = procId.getType();
        int sqlType = 100;
        switch (procType) {
            case 0: {
                sqlType = 58;
                break;
            }
            case 1: {
                sqlType = 59;
                break;
            }
            case 2: {
                sqlType = 60;
                break;
            }
            case 3: {
                sqlType = 61;
            }
        }
        return sqlType;
    }

    public static int getSQLType(SQLEditor sqlEditor) {
        int sqlType = 100;
        if (sqlEditor.getEditorInput() instanceof ProcEditorInput) {
            int procType = ((ProcEditorInput)sqlEditor.getEditorInput()).getProcIdentifier().getType();
            switch (procType) {
                case 0: {
                    sqlType = 58;
                    break;
                }
                case 1: {
                    sqlType = 59;
                    break;
                }
                case 2: {
                    sqlType = 60;
                    break;
                }
                case 3: {
                    sqlType = 61;
                }
            }
        }
        return sqlType;
    }

    public static String getQuotedString(String dataType, String inputValue, DatabaseIdentifier databaseIdentifier) throws Exception {
        if (SQLUtil.isStringType(dataType)) {
            int quoteType = SQLUtil.findQuotes(inputValue);
            if (quoteType == 2 || quoteType == 1) {
                return inputValue;
            }
            if (quoteType == 0) {
                return "'" + inputValue + "'";
            }
            if (quoteType == 3) {
                if (databaseIdentifier == null) {
                    throw new SQLException(NLS.bind((String)Messages.SQLUtil_error_invalid_quotes, (Object[])new Object[]{dataType, inputValue}));
                }
                Statement stmt = null;
                ResultSet rs = null;
                Connection cn = null;
                try {
                    cn = SQLUtil.getConnection(databaseIdentifier);
                    StringBuffer queryWithSingleQuote = new StringBuffer();
                    queryWithSingleQuote.append("select convert(").append(dataType).append(",'").append(inputValue).append("')");
                    StringBuffer queryWithDoubleQuote = new StringBuffer();
                    queryWithDoubleQuote.append("select convert(").append(dataType).append(",\"").append(inputValue).append("\")");
                    stmt = cn.createStatement();
                    String sql = queryWithSingleQuote.toString();
                    rs = stmt.executeQuery(sql);
                    sql = queryWithDoubleQuote.toString();
                    rs = stmt.executeQuery(sql);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {
                            _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {
                            _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                        }
                    }
                    throw throwable;
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {
                        _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                    }
                }
            }
        }
        return inputValue;
    }

    public static int findQuotes(String content) {
        if (content == null) {
            return 0;
        }
        if (content.indexOf(39) < 0 && content.indexOf(34) < 0) {
            return 0;
        }
        if (content.indexOf("'") == 0 && content.lastIndexOf("'") == content.length() - 1) {
            return 1;
        }
        if (content.indexOf("\"") == 0 && content.lastIndexOf("\"") == content.length() - 1) {
            return 2;
        }
        return 3;
    }

    public static String quoteStringWhenNecessary(String objstr) {
        String r = null;
        Matcher m = STRING_PATTERN.matcher(objstr);
        if (m.find()) {
            r = m.group();
        }
        if (r != null && r.equals(objstr)) {
            return r;
        }
        return SQLUtil.quote(objstr, "'");
    }

    public static String quoteWhenNecessary(String content, DatabaseIdentifier databaseIdentifier) {
        return SQLUtil.quoteWhenNecessary(content, databaseIdentifier, "\"");
    }

    public static String quoteWhenNecessary(String id, DatabaseIdentifier databaseIdentifier, String quote, int identiferType) {
        ValidatorMessage msg;
        if (id == null || id.equals("") || databaseIdentifier == null) {
            return id;
        }
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName());
        IIdentifierValidator validator = factory.getSQLService().getIdentifierValidator();
        if (!(validator == null || (msg = validator.isValid(id, identiferType, databaseIdentifier)) != null && ValidatorMessage.hasError((ValidatorMessage)msg, (int)2))) {
            return id;
        }
        boolean quoted_id = false;
        IDatabaseSetting databaseConfiguration = factory.getDatabaseSetting(databaseIdentifier);
        if (databaseConfiguration != null) {
            try {
                quoted_id = (Boolean)databaseConfiguration.getConnectionConfigProperty("C_QUOTED_IDENTIFIER");
            }
            catch (Exception exception) {}
        }
        if (quoted_id) {
            return SQLUtil.quote(id, quote);
        }
        return id;
    }

    public static String quoteWhenNecessary(String id, DatabaseIdentifier databaseIdentifier, String quote) {
        return SQLUtil.quoteWhenNecessary(id, databaseIdentifier, quote, -1);
    }

    public static String unquoteWhenNecessary(String id, DatabaseIdentifier databaseIdentifier) {
        ValidatorMessage msg;
        if (id == null || id.equals("") || databaseIdentifier == null) {
            return id;
        }
        String newId = SQLUtil.unquote(id);
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName());
        IIdentifierValidator validator = factory.getSQLService().getIdentifierValidator();
        if (!(validator == null || (msg = validator.isValid(newId, -1, databaseIdentifier)) != null && ValidatorMessage.hasError((ValidatorMessage)msg, (int)2))) {
            return newId;
        }
        return id;
    }

    public static String quote(String content, String quoteMark) {
        return String.valueOf(quoteMark) + content.replaceAll(quoteMark, String.valueOf(quoteMark) + quoteMark) + quoteMark;
    }

    public static String unquote(String quoted) {
        String content = quoted;
        if (quoted.indexOf("'") == 0 && quoted.lastIndexOf("'") == quoted.length() - 1 && quoted.length() > 1) {
            content = quoted.substring(1, quoted.length() - 1).replaceAll("''", "'");
        } else if (quoted.indexOf("\"") == 0 && quoted.lastIndexOf("\"") == quoted.length() - 1 && quoted.length() > 1) {
            content = quoted.substring(1, quoted.length() - 1).replaceAll("\"\"", "\"");
        } else if (quoted.indexOf("[") == 0 && quoted.lastIndexOf("]") == quoted.length() - 1 && quoted.length() > 1) {
            content = quoted.substring(1, quoted.length() - 1);
        }
        return content;
    }

    public static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    public static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    public static IDatatype getDatatypeByName(String typeName, DBObject[] dTypes) {
        if (dTypes == null) {
            return null;
        }
        int count = dTypes.length;
        int i = 0;
        while (i < count) {
            if (typeName.equals(dTypes[i].getName())) {
                return (IDatatype)dTypes[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isBinaryType(IDatatype datatype) {
        if (datatype.isUDT()) {
            return SQLUtil.isBinaryType(datatype.getBaseType().toString());
        }
        return SQLUtil.isBinaryType(datatype.toString());
    }

    public static boolean isBinaryType(String datatype) {
        int _sqlDataType;
        String strType = datatype;
        int position = strType.indexOf(40);
        if (position > 0) {
            strType = strType.substring(0, position);
        }
        return (_sqlDataType = SQLUtil.convert2SQLType(strType)) == -2 || _sqlDataType == -4 || _sqlDataType == -3;
    }

    public static boolean isNumericType(String datatype) {
        int _sqlDataType;
        int position = datatype.indexOf(40);
        if (position > 0) {
            datatype = datatype.substring(0, position);
        }
        return (_sqlDataType = SQLUtil.convert2SQLType(datatype)) == -5 || _sqlDataType == 3 || _sqlDataType == 8 || _sqlDataType == 6 || _sqlDataType == 4 || _sqlDataType == 2 || _sqlDataType == 7 || _sqlDataType == 5 || _sqlDataType == -6;
    }

    public static boolean isNumericType(int datatype) {
        return datatype == -5 || datatype == 3 || datatype == 8 || datatype == 6 || datatype == 4 || datatype == 2 || datatype == 7 || datatype == 5 || datatype == -6;
    }

    public static boolean isNumericType(IDatatype datatype) {
        if (datatype.isUDT()) {
            return SQLUtil.isNumericType(datatype.getBaseType().toString());
        }
        return SQLUtil.isNumericType(datatype.toString());
    }

    public static boolean isStringType(String datatype) {
        String strType = datatype;
        int position = strType.indexOf(40);
        if (position > 0) {
            strType = strType.substring(0, position);
        }
        int _sqlDataType = SQLUtil.convert2SQLType(strType);
        return SQLUtil.isStringType(_sqlDataType);
    }

    public static boolean isStringType(IDatatype datatype) {
        if (datatype.isUDT()) {
            return SQLUtil.isStringType(datatype.getBaseType().toString());
        }
        return SQLUtil.isStringType(datatype.toString());
    }

    public static boolean isStringType(int sqlType) {
        return sqlType == 1 || sqlType == 12 || sqlType == -1 || sqlType == 91 || sqlType == 92 || sqlType == 93;
    }

    public static String addDefOfAss(String sql, DatabaseIdentifier databaseIdentifier, Map varDecs, ArrayList refWithoutDef) {
        int i;
        String newSql = sql;
        SQLParser p = SQLToolsFacade.getSQLParser((String)databaseIdentifier.getProfileName(), (String)"");
        if (newSql == null) {
            return null;
        }
        if (p == null) {
            return sql;
        }
        Document doc = new Document(newSql);
        ParsingResult result = p.parse(newSql, new ParserParameters(false));
        IASTStart root = result.getRootNode();
        root.setDocument((IDocument)doc);
        String[] varRefs = result.getEntries("__variable_references");
        String[] varAsss = result.getEntries("__variable_assignments");
        String[] varDefs = result.getEntries("__variable_declarations");
        ArrayList<IASTSQLParam> assWithoutDef = new ArrayList<IASTSQLParam>();
        if (varRefs != null && varRefs.length > 0 && varDecs != null) {
            i = 0;
            while (i < varRefs.length) {
                block15: {
                    if (varDecs.containsKey(varRefs[i])) {
                        int j = 0;
                        while (j < varDefs.length) {
                            if (!varDefs[j].equals(varRefs[i])) {
                                ++j;
                                continue;
                            }
                            break block15;
                        }
                        refWithoutDef.add(varDecs.get(varRefs[i]));
                    }
                }
                ++i;
            }
        }
        if (varAsss != null && varAsss.length > 0 && varDecs != null) {
            i = 0;
            while (i < varAsss.length) {
                block16: {
                    if (varDecs.containsKey(varAsss[i])) {
                        int j = 0;
                        while (j < varDefs.length) {
                            if (!varDefs[j].equals(varAsss[i])) {
                                ++j;
                                continue;
                            }
                            break block16;
                        }
                        IASTSQLParam param = (IASTSQLParam)varDecs.get(varAsss[i]);
                        if (!refWithoutDef.contains(param)) {
                            assWithoutDef.add(param);
                        }
                    }
                }
                ++i;
            }
        }
        if (assWithoutDef.size() > 0) {
            i = 0;
            while (i < assWithoutDef.size()) {
                IASTSQLParam param = (IASTSQLParam)assWithoutDef.get(i);
                IASTSQLDataType datatype = param.getTypeObject();
                newSql = "declare " + param.getName() + " " + ((SimpleNode)datatype).getSQLText() + System.getProperty("line.separator") + newSql;
                ++i;
            }
        }
        return newSql;
    }

    public static String addDefOfAssAndRef(String sql, DatabaseIdentifier databaseIdentifier, Map varDecs) {
        ArrayList refWithoutDef = new ArrayList();
        String newSql = SQLUtil.addDefOfAss(sql, databaseIdentifier, varDecs, refWithoutDef);
        if (refWithoutDef.size() > 0) {
            int i = 0;
            while (i < refWithoutDef.size()) {
                IASTSQLParam param = (IASTSQLParam)refWithoutDef.get(i);
                IASTSQLDataType datatype = param.getTypeObject();
                newSql = "declare " + param.getName() + " " + ((SimpleNode)datatype).getSQLText() + System.getProperty("line.separator") + newSql;
                ++i;
            }
        }
        return newSql;
    }

    public static Connection getConnection(DatabaseIdentifier databaseIdentifier) {
        try {
            IControlConnection c = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
            return c.getReusableConnection();
        }
        catch (Exception exception) {
            _log.log((IStatus)new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.ObjectViewerUtil_exception_getconnection));
            return null;
        }
    }

    public static IControlConnection getControlConnection(DatabaseIdentifier databaseIdentifier) {
        try {
            return EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
        }
        catch (SQLException sQLException) {
            return null;
        }
        catch (NoSuchProfileException noSuchProfileException) {
            return null;
        }
    }

    public static synchronized String[] getAvaiableCurrencySymbols() {
        if (_allCurrencySymbols == null) {
            Locale[] locals = Locale.getAvailableLocales();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < locals.length) {
                list.add(NumberFormat.getInstance(locals[i]).getCurrency().getSymbol(locals[i]));
                ++i;
            }
            _allCurrencySymbols = list.toArray(new String[list.size()]);
            return _allCurrencySymbols;
        }
        return _allCurrencySymbols;
    }

    public static String stripNameForMessages(String name) {
        String tempName = name;
        if (tempName != null && tempName.length() > MAX_NAME_LENGTH_FOR_MESSAGE_DIALOGS) {
            tempName = String.valueOf(tempName.substring(0, MAX_NAME_LENGTH_FOR_MESSAGE_DIALOGS)) + "...";
        }
        return tempName;
    }

    public static SQLException retrieveDetailException(Throwable throwable) {
        String lineSep = System.getProperty("line.separator");
        if (throwable != null) {
            StringBuffer msg = new StringBuffer("");
            if (throwable.getLocalizedMessage() != null) {
                msg.append(throwable.getLocalizedMessage());
            } else {
                msg.append(throwable.getMessage());
            }
            if (throwable instanceof SQLException) {
                SQLException sqlEx = (SQLException)throwable;
                while (sqlEx.getNextException() != null) {
                    if ((sqlEx = sqlEx.getNextException()).getLocalizedMessage() != null) {
                        msg.append("").append(lineSep).append(sqlEx.getLocalizedMessage());
                        continue;
                    }
                    msg.append("").append(lineSep).append(sqlEx.getMessage());
                }
            }
            return new SQLException(msg.toString());
        }
        return null;
    }
}

