DELETE FROM DGB_SCHEMA_VERSIONS;
INSERT INTO DGB_SCHEMA_VERSIONS (
	SCHV_VERSION, SCHV_DESCRIPTION)
	VALUES (7, 'Messaging Hub');

CREATE TABLE DGB_MSG_CLIENTS ( -- the registered clients in the messaging hub
	MSGCLIENT_ID INTEGER NOT NULL,
	MSGCLIENT_NAME VARCHAR(128) NOT NULL,
	MSGCLIENT_CREATED_BY VARCHAR(32),
	MSGCLIENT_CREATED_AT $TIMESTAMP$,
	PRIMARY KEY (MSGCLIENT_ID)
);

CREATE TABLE DGB_MSG_TOPICS ( -- the registered topics in the messaging hub
	MSGTOPIC_ID INTEGER NOT NULL,
	MSGTOPIC_NAME VARCHAR(128),
	MSGTOPIC_CREATED_BY VARCHAR(32),
	MSGTOPIC_CREATED_AT $TIMESTAMP$,
	PRIMARY KEY (MSGTOPIC_ID)
);

CREATE TABLE DGB_MSG_MESSAGES ( -- the messages content
	MSG_ID INTEGER NOT NULL,
	MSG_MSGTOPIC_ID INTEGER NOT NULL,
	MSG_SUBJECT VARCHAR(128),
	MSG_BODY VARCHAR(4000),
	MSG_CREATED_BY VARCHAR(32),
	MSG_CREATED_AT $TIMESTAMP$,
	PRIMARY KEY (MSG_ID)
);

CREATE TABLE DGB_MSG_IN ( -- the incoming messages
	MSGIN_ID INTEGER NOT NULL,
	MSGIN_MSG_ID INTEGER NOT NULL,
	MSGIN_SENDER INTEGER NOT NULL, -- MSGCLIENT_ID
	MSGIN_STATUS INTEGER NOT NULL, -- 0 (New), 1 (Routed)
	MSGIN_CREATED_BY VARCHAR(32),
	MSGIN_CREATED_AT $TIMESTAMP$,
	PRIMARY KEY (MSGIN_ID)
);

CREATE TABLE DGB_MSG_SUBS ( -- the registered subscriptions in the messaging hub
	MSGSUB_ID INTEGER NOT NULL,
	MSGSUB_SUBSCRIBER INTEGER NOT NULL, -- MSGCLIENT_ID
	MSGSUB_MSGTOPIC_ID INTEGER NOT NULL,
	MSGSUB_CREATED_BY VARCHAR(32),
	MSGSUB_CREATED_AT $TIMESTAMP$,
	PRIMARY KEY (MSGSUB_ID)
);

CREATE TABLE DGB_MSG_OUT ( -- the incoming messages
	MSGOUT_ID INTEGER NOT NULL,
	MSGOUT_MSG_ID INTEGER NOT NULL,
	MSGOUT_RECEIVER INTEGER NOT NULL, -- MSGCLIENT_ID
	MSGOUT_STATUS INTEGER NOT NULL, -- 0 (New), 1 (Received)
	MSGOUT_CREATED_BY VARCHAR(32),
	MSGOUT_CREATED_AT $TIMESTAMP$,
	PRIMARY KEY (MSGOUT_ID)
);
