/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db;

public class DBSupportedTypesMap {
    public static final String VARCHAR = "VARCHAR";
    public static final String TINYINT = "TINYINT";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TIME = "TIME";
    public static final String SMALLINT = "SMALLINT";
    public static final String NVARCHAR = "NVARCHAR";
    public static final String NUMERIC = "NUMERIC";
    public static final String INTEGER = "INTEGER";
    public static final String REAL = "REAL";
    public static final String FLOAT = "FLOAT";
    public static final String DOUBLE = "DOUBLE";
    public static final String DECIMAL = "DECIMAL";
    public static final String DATE = "DATE";
    public static final String CLOB = "CLOB";
    public static final String CHAR = "CHAR";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String BLOB = "BLOB";
    public static final String BIT = "BIT";
    public static final String BINARY = "BINARY";
    public static final String BIGINT = "BIGINT";
    public static final String UNSUPPORTED_TYPE = "Unsupported Type:";

    public static String[] getSupportedTypes() {
        return new String[]{VARCHAR, CHAR, INTEGER, BIGINT, SMALLINT, REAL, DOUBLE, DATE, TIME, TIMESTAMP, BLOB};
    }

    public static String getTypeName(int type) {
        String typeName = null;
        switch (type) {
            case -5: {
                typeName = BIGINT;
                break;
            }
            case -2: {
                typeName = BINARY;
                break;
            }
            case -7: {
                typeName = BIT;
                break;
            }
            case 2004: {
                typeName = BLOB;
                break;
            }
            case 16: {
                typeName = BOOLEAN;
                break;
            }
            case 1: {
                typeName = CHAR;
                break;
            }
            case 2005: {
                typeName = CLOB;
                break;
            }
            case 91: {
                typeName = DATE;
                break;
            }
            case 3: {
                typeName = DECIMAL;
                break;
            }
            case 8: {
                typeName = DOUBLE;
                break;
            }
            case 6: {
                typeName = FLOAT;
                break;
            }
            case 4: {
                typeName = INTEGER;
                break;
            }
            case 2: {
                typeName = NUMERIC;
                break;
            }
            case -9: {
                typeName = NVARCHAR;
                break;
            }
            case 5: {
                typeName = SMALLINT;
                break;
            }
            case 92: {
                typeName = TIME;
                break;
            }
            case 93: {
                typeName = TIMESTAMP;
                break;
            }
            case -6: {
                typeName = TINYINT;
                break;
            }
            case 7: {
                typeName = REAL;
                break;
            }
            case 12: {
                typeName = VARCHAR;
                break;
            }
            default: {
                typeName = UNSUPPORTED_TYPE + type;
            }
        }
        return typeName;
    }
}

