/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.dialect;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.repository.ext.db.dialect.IDialectSpecifier;

public class DerbyDBSpecifier
implements IDialectSpecifier {
    private static final String OFFSET_D_ROWS_FETCH_FIRST_D_ROWS_ONLY = "OFFSET %d ROWS FETCH FIRST %d ROWS ONLY";
    private static final String DERBY_TIMESTAMP = "TIMESTAMP";
    private static final String DERBY_FLOAT = "DOUBLE";
    private static final String DERBY_BLOB = "BLOB";
    private static final String DERBY_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(OFFSET_D_ROWS_FETCH_FIRST_D_ROWS_ONLY, offset, limit);
    }

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", DERBY_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", DERBY_TIMESTAMP);
        sql = sql.replace("$BLOB$", DERBY_BLOB);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if ("FLOAT".equals(commonType)) {
            return DERBY_FLOAT;
        }
        return commonType;
    }

    @Override
    public String createTopAndStart(int limit, int offset) {
        return "";
    }

    @Override
    public boolean isSchemaFilterSupported() {
        return false;
    }

    @Override
    public String getSchemaFilterScript() {
        return null;
    }

    @Override
    public String getAlterAddOpen() {
        return " ADD ";
    }

    @Override
    public String getAlterAddClose() {
        return "";
    }

    @Override
    public InputStream getBinaryStream(ResultSet resultSet, String columnName) throws SQLException {
        Blob data = resultSet.getBlob(columnName);
        return data.getBinaryStream();
    }
}

