/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.dialect;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.repository.ext.db.dialect.IDialectSpecifier;

public class HANADBSpecifier
implements IDialectSpecifier {
    private static final String LIMIT_D_OFFSET_D = "LIMIT %d OFFSET %d";
    private static final String HANA_FLOAT = "DOUBLE";
    private static final String HANA_TIMESTAMP = "TIMESTAMP";
    private static final String HANA_BLOB = "BLOB";
    private static final String HANA_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(LIMIT_D_OFFSET_D, limit, offset);
    }

    @Override
    public boolean isSchemaFilterSupported() {
        return true;
    }

    @Override
    public String getSchemaFilterScript() {
        return "SELECT * FROM PUBLIC.SCHEMAS WHERE HAS_PRIVILEGES='TRUE'";
    }

    @Override
    public String getAlterAddOpen() {
        return " ADD ( ";
    }

    @Override
    public String getAlterAddClose() {
        return " ) ";
    }

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", HANA_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", HANA_TIMESTAMP);
        sql = sql.replace("$BLOB$", HANA_BLOB);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if ("FLOAT".equals(commonType)) {
            return HANA_FLOAT;
        }
        return commonType;
    }

    @Override
    public String createTopAndStart(int limit, int offset) {
        return "";
    }

    @Override
    public InputStream getBinaryStream(ResultSet resultSet, String columnName) throws SQLException {
        Blob data = resultSet.getBlob(columnName);
        return data.getBinaryStream();
    }
}

