/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.dialect;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.repository.ext.db.dialect.IDialectSpecifier;

public class PostgreSQLDBSpecifier
implements IDialectSpecifier {
    private static final String LIMIT_D_OFFSET_D = "LIMIT %d OFFSET %d";
    private static final String POSTGRESQL_TIMESTAMP = "TIMESTAMP";
    private static final String POSTGRESQL_FLOAT = "REAL";
    private static final String POSTGRESQL_DOUBLE = "DOUBLE PRECISION";
    private static final String POSTGRESQL_BLOB = "BYTEA";
    private static final String POSTGRESQL_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(LIMIT_D_OFFSET_D, limit, offset);
    }

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", POSTGRESQL_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", POSTGRESQL_TIMESTAMP);
        sql = sql.replace("$BLOB$", POSTGRESQL_BLOB);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if ("FLOAT".equals(commonType)) {
            return POSTGRESQL_FLOAT;
        }
        if ("DOUBLE".equals(commonType)) {
            return POSTGRESQL_DOUBLE;
        }
        return commonType;
    }

    @Override
    public String createTopAndStart(int limit, int offset) {
        return "";
    }

    @Override
    public boolean isSchemaFilterSupported() {
        return false;
    }

    @Override
    public String getSchemaFilterScript() {
        return null;
    }

    @Override
    public String getAlterAddOpen() {
        return " ADD COLUMN ";
    }

    @Override
    public String getAlterAddClose() {
        return "";
    }

    @Override
    public InputStream getBinaryStream(ResultSet resultSet, String columnName) throws SQLException {
        return new ByteArrayInputStream(resultSet.getBytes(columnName));
    }
}

