DELETE FROM DGB_SCHEMA_VERSIONS;
INSERT INTO DGB_SCHEMA_VERSIONS (
	SCHV_VERSION, SCHV_DESCRIPTION)
	VALUES (5, 'Security Features');

CREATE TABLE DGB_SECURITY_ACCESS ( -- the secured location by role
	ACCESS_LOCATION VARCHAR(1000) NOT NULL,
	ACCESS_ROLE VARCHAR(100) NOT NULL,
	ACCESS_CREATED_BY VARCHAR(32),
	ACCESS_CREATED_AT $TIMESTAMP$,
	PRIMARY KEY (ACCESS_LOCATION, ACCESS_ROLE)
);

CREATE TABLE DGB_SECURITY_ROLES ( -- the available roles
	ROLE_NAME VARCHAR(100) NOT NULL,
	ROLE_DESCRIPTION VARCHAR(2000),
	ROLE_CREATED_BY VARCHAR(32),
	ROLE_CREATED_AT $TIMESTAMP$,
	PRIMARY KEY (ROLE_NAME)
);

INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('Administrator', 'Administrtive Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('Manager', 'Manager Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('PowerUser', 'Power User Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('User', 'User Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('ReadWrite', 'Read and Write Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('ReadOnly', 'Read Only Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('Everyone', 'Every Signed In User Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('Level1', 'Level 1 Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('Level2', 'Level 2 Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('Level3', 'Level 3 Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('Level4', 'Level 4 Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);
INSERT INTO DGB_SECURITY_ROLES (ROLE_NAME, ROLE_DESCRIPTION, ROLE_CREATED_BY, ROLE_CREATED_AT) 
    VALUES ('Level5', 'Level 5 Permissions', 'SYSTEM', $CURRENT_TIMESTAMP$);