/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.command;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.eclipse.dirigible.repository.ext.command.Piper;
import org.eclipse.dirigible.repository.ext.command.ProcessUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class WebSocketTerminalBridgeServletInternal {
    private static final Logger logger = Logger.getLogger(WebSocketTerminalBridgeServletInternal.class);
    private static Map<String, Session> openSessions = new ConcurrentHashMap<String, Session>();
    private static Map<String, Process> session2process = new ConcurrentHashMap<String, Process>();

    @OnOpen
    public void onOpen(Session session) throws IOException {
        openSessions.put(session.getId(), session);
        session.getBasicRemote().sendText("[terminal] open: " + session.getId());
        logger.debug("[ws:terminal] onOpen: " + session.getId());
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        block7: {
            logger.debug("[ws:terminal] onMessage: " + message);
            Process process = session2process.get(session.getId());
            if (process != null) {
                try {
                    if ("exit".equalsIgnoreCase(message)) {
                        logger.debug("onMessage: exit command received");
                        process.destroy();
                        break block7;
                    }
                    new OutputStreamWriter(new BufferedOutputStream(process.getOutputStream())).write(message);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                try {
                    process = this.startProcess(message, session);
                    logger.debug("onMessage: process started");
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                session2process.put(session.getId(), process);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process startProcess(String message, Session session) throws IOException {
        logger.debug("entering startProcess: " + message + " | " + session.getId());
        String[] args = ProcessUtils.translateCommandline((String)message);
        ProcessBuilder processBuilder = ProcessUtils.createProcess((String[])args);
        ProcessUtils.addEnvironmentVariables((ProcessBuilder)processBuilder, null);
        ProcessUtils.removeEnvironmentVariables((ProcessBuilder)processBuilder, null);
        processBuilder.redirectErrorStream(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Process process = ProcessUtils.startProcess((String[])args, (ProcessBuilder)processBuilder);
        Piper pipe = new Piper(process.getInputStream(), (OutputStream)out);
        new Thread((Runnable)pipe).start();
        try {
            int i = 0;
            boolean deadYet = false;
            do {
                Thread.sleep(ProcessUtils.DEFAULT_WAIT_TIME);
                try {
                    ByteArrayOutputStream byteArrayOutputStream = out;
                    synchronized (byteArrayOutputStream) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            logger.debug("sending process data: " + line);
                            if (!session.isOpen()) continue;
                            session.getBasicRemote().sendText(line);
                            out.reset();
                        }
                    }
                    process.exitValue();
                    deadYet = true;
                    this.removeProcess(process);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (++i < 600) continue;
                    process.destroy();
                    throw new RuntimeException("Exeeds timeout: " + ProcessUtils.DEFAULT_WAIT_TIME / 1000 * 600);
                }
            } while (!deadYet);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        session.getBasicRemote().sendText(new String(out.toByteArray()));
        logger.debug("exiting startProcess: " + message + " | " + session.getId());
        return process;
    }

    protected void removeProcess(Process process) {
        Iterator<Map.Entry<String, Process>> iter = session2process.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Process> entry = iter.next();
            if (!entry.getValue().equals(process)) continue;
            iter.remove();
            break;
        }
    }

    @OnError
    public void onError(Session session, String error) {
        logger.debug("[ws:terminal] onError: " + error);
    }

    @OnClose
    public void onClose(Session session) {
        Process process = session2process.get(session.getId());
        process.destroy();
        openSessions.remove(session.getId());
        logger.debug("[ws:terminal] onClose: Session " + session.getId() + " has ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        for (Session session : openSessions.values()) {
            try {
                Session session2 = session;
                synchronized (session2) {
                    Process process = session2process.get(session.getId());
                    process.destroy();
                    session.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

