/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.mobile.wizard;

import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.mobile.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.mobile.wizard.MobileTemplateModel;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.repository.ext.utils.CommonUtils;

public class MobileTemplateTargetLocationPage
extends TemplateTargetLocationPage {
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.mobile.wizard.MobileTemplateTargetLocationPage";
    private static final String TARGET_LOCATION = Messages.MobileTemplateTargetLocationPage_TARGET_LOCATION;
    private static final String SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME = Messages.MobileTemplateTargetLocationPage_SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME;
    private static final String DEFAULT_FILE_NAME = "app_name.js";
    private static final String FILE_EXTENSION = ".js";
    private MobileTemplateModel model;

    protected MobileTemplateTargetLocationPage(MobileTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(TARGET_LOCATION);
        this.setDescription(SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME);
    }

    protected void checkPageStatus() {
        boolean isFileNameSet;
        boolean isTargetLocationSet = this.getModel().getTargetLocation() != null && !this.getModel().getTargetLocation().equals("");
        boolean bl = isFileNameSet = this.getModel().getFileName() != null && !this.getModel().getFileName().equals("");
        if (isTargetLocationSet && isFileNameSet) {
            IValidationStatus status = this.model.validateLocation();
            if (status.hasErrors()) {
                this.setErrorMessage(status.getMessage());
                this.setPageComplete(false);
            } else if (status.hasWarnings()) {
                this.setErrorMessage(status.getMessage());
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        } else {
            this.setPageComplete(false);
        }
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getDefaultFileName(String preset) {
        if (this.getModel().getFileName() == null || "".equals(this.getModel().getFileName())) {
            return DEFAULT_FILE_NAME;
        }
        return preset == null ? this.getModel().getFileName() : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + FILE_EXTENSION;
    }

    protected boolean isForcedFileName() {
        return true;
    }

    protected String getArtifactContainerName() {
        return "MobileApplications";
    }
}

