/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource.db.dialect;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.repository.datasource.DBSupportedTypesMap;
import org.eclipse.dirigible.repository.datasource.db.dialect.RDBGenericDialectSpecifier;

public class SybaseDBSpecifier
extends RDBGenericDialectSpecifier {
    public static final String PRODUCT_SYBASE = "Adaptive Server Enterprise";
    private static final String SYBASE_TIMESTAMP = "DATETIME";
    private static final String SYBASE_FLOAT = "REAL";
    private static final String SYBASE_BLOB = "IMAGE";
    private static final String SYBASE_CURRENT_TIMESTAMP = "GETDATE()";
    private static final String SYBASE_KEY_VARCHAR = "VARCHAR(1000)";
    private static final String SYBASE_BIG_VARCHAR = "VARCHAR(4000)";

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", SYBASE_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", SYBASE_TIMESTAMP);
        sql = sql.replace("$BLOB$", SYBASE_BLOB);
        sql = sql.replace("$KEY_VARCHAR$", SYBASE_KEY_VARCHAR);
        sql = sql.replace("$BIG_VARCHAR$", SYBASE_BIG_VARCHAR);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if (DBSupportedTypesMap.DataTypes.TIMESTAMP.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)commonType))) {
            return SYBASE_TIMESTAMP;
        }
        if (DBSupportedTypesMap.DataTypes.FLOAT.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)commonType))) {
            return SYBASE_FLOAT;
        }
        if (DBSupportedTypesMap.DataTypes.BLOB.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)commonType))) {
            return SYBASE_BLOB;
        }
        return commonType;
    }

    @Override
    public String createTopAndStart(int limit, int offset) {
        return String.format("TOP %d ROWS START AT %d", limit, offset);
    }

    @Override
    public InputStream getBinaryStream(ResultSet resultSet, String columnName) throws SQLException {
        return new ByteArrayInputStream(resultSet.getBytes(columnName));
    }

    @Override
    public boolean isDialectForName(String productName) {
        return PRODUCT_SYBASE.equalsIgnoreCase(productName);
    }
}

