/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import javax.websocket.ClientEndpoint;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.eclipse.dirigible.ide.bridge.WebSocketTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class WebSocketTunnelClient {
    private static final Logger logger = LoggerFactory.getLogger((String)WebSocketTunnelClient.class.getCanonicalName());

    @OnOpen
    public void onOpen(Session session) throws IOException {
        logger.error("opened tunnelled session");
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        Session inbound = WebSocketTunnel.INBOUND_SESSIONS.get(session.getId());
        if (inbound != null) {
            try {
                inbound.getBasicRemote().sendText(message);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            logger.error("Received a message for unbound session");
        }
    }

    @OnError
    public void onError(Session session, Throwable t) throws Throwable {
        logger.error(t.getMessage(), t);
        Session inbound = WebSocketTunnel.INBOUND_SESSIONS.get(session.getId());
        if (inbound != null) {
            try {
                inbound.getBasicRemote().sendText(t.getMessage());
                inbound.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            logger.error("Received an error message for unbound session");
        }
    }

    @OnClose
    public void onClose(Session session) {
        Session inbound = WebSocketTunnel.INBOUND_SESSIONS.get(session.getId());
        if (inbound != null) {
            try {
                inbound.getBasicRemote().sendText("closed by the peer");
                inbound.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            logger.error("Received closing for unbound session");
        }
    }
}

