/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.tester;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.logging.Logger;

public class RepositoryPermissionTester
extends PropertyTester {
    private static final Logger logger = Logger.getLogger(RepositoryPermissionTester.class);
    private static final String REPOSITORY_COMMAND_COPY = "copy";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        String operation = (String)expectedValue;
        String currentUser = CommonIDEParameters.getUserName();
        String createdBy = null;
        boolean allowed = false;
        String allowedCopyPath = "/db/dirigible/";
        String allowedWorkspacePath = CommonIDEParameters.getWorkspace((HttpServletRequest)CommonIDEParameters.getRequest());
        String allowedSandboxPath = "/db/dirigible/sandbox/" + currentUser;
        boolean isOperator = CommonIDEParameters.isUserInRole((String)"Operator");
        IEntity selectedEntity = (IEntity)receiver;
        String selectedEntityPath = selectedEntity.getPath();
        try {
            if (isOperator) {
                allowed = true;
            } else if (operation.equalsIgnoreCase(REPOSITORY_COMMAND_COPY)) {
                allowed = selectedEntityPath.startsWith(allowedCopyPath);
            } else {
                createdBy = selectedEntity.getInformation().getCreatedBy();
                allowed = (selectedEntityPath.startsWith(allowedWorkspacePath) || selectedEntityPath.startsWith(allowedSandboxPath)) && currentUser.equalsIgnoreCase(createdBy);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            allowed = false;
        }
        return allowed;
    }
}

