/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.ext.conf.ConfigurationStore;
import org.eclipse.dirigible.repository.ext.conf.IConfigurationStore;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;

public abstract class AbstractRepositoryPreferenceStore
implements IPreferenceStore {
    private static final long serialVersionUID = 1L;
    private static final String CHANAGED_BY = "Chanaged by ";
    private static final Logger logger = Logger.getLogger(AbstractRepositoryPreferenceStore.class);
    private PreferenceStore delegate = new PreferenceStore();
    private String path;
    private String name;

    public AbstractRepositoryPreferenceStore(String path, String name) {
        this.path = path;
        this.name = name;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.delegate.addPropertyChangeListener(listener);
    }

    public boolean contains(String name) {
        return this.delegate.contains(name);
    }

    public boolean equals(Object arg0) {
        return this.delegate.equals(arg0);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.delegate.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public boolean getBoolean(String name) {
        return this.delegate.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.delegate.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.delegate.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.delegate.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.delegate.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.delegate.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.delegate.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.delegate.getDouble(name);
    }

    public float getFloat(String name) {
        return this.delegate.getFloat(name);
    }

    public int getInt(String name) {
        return this.delegate.getInt(name);
    }

    public long getLong(String name) {
        return this.delegate.getLong(name);
    }

    public String getString(String name) {
        return this.delegate.getString(name);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isDefault(String name) {
        return this.delegate.isDefault(name);
    }

    public void list(PrintStream out) {
        this.delegate.list(out);
    }

    public void list(PrintWriter out) {
        this.delegate.list(out);
    }

    public void load() throws IOException {
        IConfigurationStore configurationStorage = AbstractRepositoryPreferenceStore.getConfigurationStore();
        byte[] bytes = this.loadSettings(configurationStorage);
        this.delegate.load((InputStream)new ByteArrayInputStream(bytes));
    }

    protected abstract byte[] loadSettings(IConfigurationStore var1) throws IOException;

    public void load(InputStream in) throws IOException {
        this.delegate.load(in);
    }

    public boolean needsSaving() {
        return this.delegate.needsSaving();
    }

    public String[] preferenceNames() {
        return this.delegate.preferenceNames();
    }

    public void putValue(String name, String value) {
        this.delegate.putValue(name, value);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.delegate.removePropertyChangeListener(listener);
    }

    public void save() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.delegate.save((OutputStream)baos, CHANAGED_BY + CommonIDEParameters.getUserName());
        this.saveSettingd(baos);
    }

    protected abstract void saveSettingd(ByteArrayOutputStream var1) throws IOException;

    public void save(OutputStream out, String header) throws IOException {
        this.delegate.save(out, header);
    }

    public void setDefault(String name, double value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, float value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, long value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, String value) {
        this.delegate.setDefault(name, value);
    }

    public void setDefault(String name, boolean value) {
        this.delegate.setDefault(name, value);
    }

    public void setFilename(String name) {
        this.delegate.setFilename(name);
    }

    public void setToDefault(String name) {
        this.delegate.setToDefault(name);
    }

    public void setValue(String name, double value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, float value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, int value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, long value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, String value) {
        this.delegate.setValue(name, value);
    }

    public void setValue(String name, boolean value) {
        this.delegate.setValue(name, value);
    }

    public String toString() {
        return this.delegate.toString();
    }

    protected static IConfigurationStore getConfigurationStore() {
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        ConfigurationStore configurationStorage = new ConfigurationStore(repository);
        return configurationStorage;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }
}

